/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jviewElement;

import java.awt.Font;
import net.astah.golf.draw.GGeometry;
import net.astah.golf.draw.GGraphics;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GNodeSelectionListener;
import net.astah.golf.draw.GRect;
import net.astah.golf.draw.GText;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.util.Debug;
import net.astah.golf.widget.CColor;
import net.astah.golf.widget.CGraphics;
import net.astah.golf.widget.CTextComponent;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.UserObject;
import net.astah.jomt.jutil.JomtFontUtilities;
import net.astah.jomt.jviewElement.CJomtTextComponentNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public abstract class CJomtTextNode
extends GGeometry {
    private static final Logger a = LoggerFactory.getLogger(CJomtTextNode.class);
    public static final byte LEFT = 0;
    public static final byte CENTER = 1;
    public static final byte RIGHT = 2;
    public static final byte NONE = 100;
    public static final byte RECT = 101;
    public static final byte LABEL = 102;
    protected boolean editable = true;
    protected GText textNode;
    public GRect body;
    protected CJomtTextComponentNode compNode;
    protected CTextComponent textComponent;
    public double x = 0.0;
    public double y = 0.0;
    public double width = 0.0;
    public double height = 0.0;
    protected String str = "";
    protected String selectedString = "";
    protected Font font;
    protected byte labelPointType = 0;
    private byte b = (byte)101;
    private boolean c;

    public CJomtTextNode() {
        this.setType(64);
        this.a();
    }

    public CJomtTextNode(Presentation presentation) {
        UserObject userObject = new UserObject(presentation.getModel(), presentation);
        this.setModel(userObject);
        this.setType(64);
        this.a();
    }

    public CJomtTextNode(UserObject userObject) {
        this.setModel(userObject);
        this.setType(64);
        this.a();
    }

    private void a() {
        if (this.textNode == null) {
            this.textNode = new GText();
            this.textNode.setString("");
            this.textNode.setBackgroundNo((byte)1);
            this.textNode.setModel(this.getModel());
            this.textNode.setColorNo((byte)2);
            this.textNode.setPickable(false);
            this.addNode((GNode)this.textNode);
        }
        if (this.body == null) {
            this.body = new GRect();
            this.body.setModel(this.getModel());
            this.body.setKnobColorNo((byte)2);
            this.body.addNodeSelectionListener((GNodeSelectionListener)this.body);
            this.addNodeSelectionListener((GNodeSelectionListener)this.body);
            this.addNode((GNode)this.body);
        }
        this.initComponentNode();
    }

    protected abstract void initComponentNode();

    public void setSelectionType(byte by) {
        this.setBodySelectionType(by);
    }

    public void setColorNo(byte by) {
        this.setTextColorNo(by);
    }

    public void setKnobColorNo(byte by) {
        this.setBodyKnobColorNo(by);
    }

    public void setBodySelectionType(byte by) {
        this.body.setSelectionType(by);
    }

    public void setBodyKnobColorNo(byte by) {
        this.body.setKnobColorNo(by);
    }

    public void setTextColorNo(byte by) {
        this.textNode.setColorNo(by);
        this.compNode.setTempTextColorNo(by);
    }

    public void setDepth(int n) {
        super.setDepth(n);
        this.textNode.setDepth(n - 3);
        this.body.setDepth(n - 2);
    }

    public void setAlpha(float f) {
        this.body.setAlpha(f);
    }

    public void setModel(Object object) {
        super.setModel(object);
        if (this.body != null) {
            this.body.setModel(object);
        }
        if (this.textNode != null) {
            this.textNode.setModel(object);
        }
        if (this.compNode != null) {
            this.compNode.setModel(object);
        }
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.body.setVisible(bl);
        this.textNode.setVisible(bl);
        this.compNode.setVisible(bl);
    }

    public void setSelected(boolean bl) {
        this.compNode.setSelected(bl);
        if (this.b == 101) {
            this.body.setSelected(bl);
        } else if (this.b == 102) {
            this.textNode.setSelected(bl);
        }
        if (!bl && this.isComponentFocus()) {
            this.setComponentFocus(false);
        }
        super.setSelected(bl);
    }

    public void setString(String string) {
        this.str = string;
        this.textNode.setString(this.str);
    }

    public void clearString() {
        this.textComponent.setText(this.selectedString);
    }

    public void setSelectedString(String string) {
        this.selectedString = string;
    }

    public void setFont(Font font) {
        this.font = font;
        this.textNode.setFont(this.font);
        this.compNode.setTempTextFont(this.font);
    }

    public Font getFont() {
        return this.font;
    }

    public void setPoint(Pnt2d pnt2d) {
        this.setPoint(pnt2d.x, pnt2d.y);
    }

    public void setPoint(double d, double d2) {
        if (this.x == d && this.y == d2) {
            return;
        }
        this.x = d;
        this.y = d2;
        this.body.setPoint(d, d2);
        this.compNode.setBounds2d(d, d2, this.width, this.height);
        this.compNode.setTempTextPoint(d, d2 + (double)this.getFontAscent());
        this.updateTextNodePoint();
    }

    protected void updateTextNodePoint() {
        switch (this.labelPointType) {
            case 0: {
                this.textNode.setPoint(this.x, this.y + (double)this.getFontAscent());
                break;
            }
            case 1: {
                if (this.font == null || this.str == null) {
                    this.textNode.setPoint(this.x, this.y + (double)this.getFontAscent());
                    break;
                }
                double d = JomtFontUtilities.computeMultiLineStringWidth((Font)this.font, (String)this.str);
                double d2 = 0.0;
                if (this.width - d > 0.0) {
                    d2 = this.width - d;
                }
                this.textNode.setPoint(this.x + d2 / 2.0, this.y + (double)this.getFontAscent());
                break;
            }
            case 2: {
                a.trace("setPoint : case RIGHT hasn't implemented");
                break;
            }
            default: {
                Debug.impossible();
            }
        }
    }

    public void setRect(double d, double d2, double d3, double d4) {
        this.width = d3;
        this.height = d4;
        this.x = d;
        this.y = d2;
        this.body.setRect(d, d2, d3, d4);
        this.compNode.setBounds2d(d, d2, d3, d4 + 4.0);
        this.compNode.setTempTextPoint(d, d2 + (double)this.getFontAscent());
        this.updateTextNodePoint();
    }

    public int getFontAscent() {
        if (this.textNode.doWrapLine()) {
            return 0;
        }
        if (this.font != null) {
            return (int)(JomtFontUtilities.computeStringHeight((Font)this.font, (String)"m") * 0.8) + 1;
        }
        return 13;
    }

    public void setWidth(double d) {
        this.width = d;
        this.body.setWidth(d);
        this.compNode.setBounds2d(this.x, this.y, d, this.height);
    }

    public void setHeight(double d) {
        this.height = d;
        this.body.setHeight(d);
        this.compNode.setBounds2d(this.x, this.y, this.width, d + 4.0);
    }

    public void setRect(Rectangle2d rectangle2d) {
        this.setRect(rectangle2d.x, rectangle2d.y, rectangle2d.width, rectangle2d.height);
    }

    public void setPickable(boolean bl) {
        super.setPickable(bl);
    }

    public CTextComponent getTextComponent() {
        return this.textComponent;
    }

    public int getDiagonalLength(GGraphics gGraphics) {
        return (int)Math.round(Math.sqrt(this.width * this.width + this.height * this.height) * gGraphics.getCamera().getScale());
    }

    public void setComponentFocus(boolean bl) {
    }

    public boolean isComponentFocus() {
        return this.compNode.isFocus();
    }

    public void setLabelPointType(byte by) {
        this.labelPointType = by;
    }

    public void setSelectionKnobNodeType(byte by) {
        this.b = by;
    }

    public void setComponentSelectAll(boolean bl) {
        this.compNode.setSelectAll(bl);
    }

    public boolean isComponentSelectAll() {
        return this.compNode.isSelectAll();
    }

    public void setWrapLine(boolean bl) {
        if (bl != this.textNode.doWrapLine()) {
            this.textNode.setWrapLine(bl);
            this.updateTextNodePoint();
        }
    }

    public boolean doWrapLine() {
        return this.textNode.doWrapLine();
    }

    public boolean isAllowedNewLine() {
        return this.compNode.isAllowedNewLine();
    }

    public void setAllowedNewLine(boolean bl) {
        this.compNode.setAllowedNewLine(bl);
    }

    public boolean isUnderlineOn() {
        return this.textNode.isUnderlineOn();
    }

    public void setUnderlineOn(boolean bl) {
        this.textNode.setUnderlineOn(bl);
    }

    public void setBodyType(int n) {
        this.body.setType(n);
    }

    public void setFontColor(CColor cColor) {
        this.textNode.setForegroundColor(cColor);
    }

    public boolean isDirectEditing() {
        return this.c;
    }

    public void setDirectEditing(boolean bl) {
        this.c = bl;
    }

    public void setEnableCopyPaste(boolean bl) {
        this.body.setEnableCopyPaste(bl);
        super.setEnableCopyPaste(bl);
    }

    public Rectangle2d getBounds2d(CGraphics cGraphics) {
        return new Rectangle2d(this.body.getX(), this.body.getY(), this.body.getWidth(), this.body.getHeight());
    }
}

