/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.astah.common.collect.Streams;
import net.astah.golf.draw.GArrow;
import net.astah.golf.draw.GCurve;
import net.astah.golf.draw.GIconButton;
import net.astah.golf.draw.GKnob;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GRoundKnob;
import net.astah.golf.geom2D.Line2d;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.jomt.jview.BaseDrawSuggest;
import net.astah.notation.editor.IViewElement;

public abstract class EdgeDrawSuggest
extends BaseDrawSuggest {
    protected static final double LINE_OFFSET = 15.0;

    public EdgeDrawSuggest(IViewElement iViewElement) {
        super(iViewElement);
    }

    @Override
    public abstract Pnt2d createModeArgumentPoint(Pnt2d var1);

    @Override
    protected boolean contains(Pnt2d pnt2d) {
        return this.contains(pnt2d, false);
    }

    @Override
    protected boolean contains(Pnt2d pnt2d, boolean bl) {
        List<Pnt2d> list = this.a();
        if (!list.isEmpty()) {
            boolean bl2 = !bl && this.containsOnPath(pnt2d, list, 15.0) && this.withinValidArea(pnt2d, list, 15.0);
            return bl2 ? true : this.withinPreferentialArea(pnt2d, list, 15.0);
        }
        return false;
    }

    private List<Pnt2d> a() {
        GArrow gArrow = this.b();
        if (gArrow instanceof GCurve) {
            return this.a((GCurve)gArrow);
        }
        if (gArrow instanceof GArrow) {
            return this.a(gArrow);
        }
        return Collections.emptyList();
    }

    private GArrow b() {
        IViewElement iViewElement = this.getOwner();
        if (iViewElement instanceof GNode) {
            List list = ((GNode)iViewElement).getChildren();
            Optional optional = Streams.stream((Collection)list, GCurve.class).findFirst();
            if (optional.isPresent()) {
                return (GArrow)optional.get();
            }
            Optional optional2 = Streams.stream((Collection)list, GArrow.class).findFirst();
            if (optional2.isPresent()) {
                return (GArrow)optional2.get();
            }
        }
        return null;
    }

    private List<Pnt2d> a(GCurve gCurve) {
        double d = Math.min(Math.max(5.0, 5.0), 10.0);
        PathIterator pathIterator = gCurve.getPeerCurve().getPathIterator(null, d);
        double[] dArray = new double[6];
        ArrayList arrayList = new ArrayList();
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(dArray)) {
                case 0: 
                case 1: {
                    arrayList.add(new Pnt2d(dArray[0], dArray[1]));
                    break;
                }
            }
            pathIterator.next();
        }
        return arrayList.isEmpty() ? Collections.emptyList() : arrayList;
    }

    private List<Pnt2d> a(GArrow gArrow) {
        Pnt2d[] pnt2dArray = gArrow.getPoints();
        return pnt2dArray != null && pnt2dArray.length > 0 ? Arrays.asList(pnt2dArray) : Collections.emptyList();
    }

    protected boolean containsOnPath(Pnt2d pnt2d, List<Pnt2d> list, double d) {
        for (int i = 0; i < list.size() - 1; ++i) {
            Pnt2d pnt2d2;
            Pnt2d pnt2d3 = list.get(i);
            Line2d line2d = new Line2d(pnt2d3, pnt2d2 = list.get(i + 1));
            if (!(line2d.ptSegDist(pnt2d.getX(), pnt2d.getY()) <= d)) continue;
            return true;
        }
        return false;
    }

    protected boolean withinValidArea(Pnt2d pnt2d, List<Pnt2d> list, double d) {
        IViewElement iViewElement;
        double d2 = d * d;
        Pnt2d pnt2d2 = list.get(0);
        if (pnt2d.distanceSq((Point2D)pnt2d2) < d2) {
            return false;
        }
        Pnt2d pnt2d3 = list.get(list.size() - 1);
        if (pnt2d.distanceSq((Point2D)pnt2d3) < d2) {
            return false;
        }
        if (this.isExcludeKnobsOnWay() && (iViewElement = this.getOwner()) instanceof GNode) {
            for (GNode gNode : ((GNode)iViewElement).getAllNodes()) {
                Pnt2d pnt2d4;
                GKnob gKnob;
                if (!gNode.isVisible()) continue;
                if (gNode instanceof GKnob) {
                    gKnob = (GKnob)gNode;
                    pnt2d4 = new Pnt2d(gKnob.getX() + gKnob.getWidth() / 2.0, gKnob.getY() + gKnob.getHeight() / 2.0);
                } else {
                    if (!(gNode instanceof GRoundKnob)) continue;
                    gKnob = (GRoundKnob)gNode;
                    pnt2d4 = new Pnt2d(gKnob.getX() + gKnob.getWidth() / 2.0, gKnob.getY() + gKnob.getHeight() / 2.0);
                }
                if (pnt2d4.equals((Object)pnt2d2) || pnt2d4.equals((Object)pnt2d3) || !(pnt2d.distanceSq((Point2D)pnt2d4) < d2)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isExcludeKnobsOnWay() {
        return true;
    }

    protected boolean withinPreferentialArea(Pnt2d pnt2d, List<Pnt2d> list, double d) {
        for (GNode gNode : this.getButtonManager().getChildren()) {
            GIconButton gIconButton = (GIconButton)gNode;
            Line2d line2d = this.getNearestLine(list, gIconButton.getCenterPnt());
            if (line2d == null) continue;
            Pnt2d pnt2d2 = this.a(line2d, gIconButton.getCenterPnt());
            Line2d line2d2 = new Line2d(gIconButton.getCenterPnt(), pnt2d2);
            if (!(line2d2.ptSegDist(pnt2d.getX(), pnt2d.getY()) <= d) || !(gIconButton.getDistance(line2d.getX1(), line2d.getY1()) >= d) || !(gIconButton.getDistance(line2d.getX2(), line2d.getY2()) >= d)) continue;
            return true;
        }
        return false;
    }

    protected Line2d getNearestLine(List<Pnt2d> list, Pnt2d pnt2d) {
        double d = Double.POSITIVE_INFINITY;
        Line2d line2d = null;
        for (int i = 0; i < list.size() - 1; ++i) {
            Line2d line2d2 = new Line2d(list.get(i), list.get(i + 1));
            double d2 = line2d2.ptLineDist((Point2D)pnt2d);
            if (!(d2 < d)) continue;
            d = d2;
            line2d = line2d2;
        }
        return line2d;
    }

    private Pnt2d a(Line2d line2d, Pnt2d pnt2d) {
        Pnt2d pnt2d2 = new Pnt2d(line2d.x2 - line2d.x1, line2d.y2 - line2d.y1);
        Pnt2d pnt2d3 = new Pnt2d(pnt2d.x - line2d.x1, pnt2d.y - line2d.y1);
        Pnt2d pnt2d4 = this.a(pnt2d2);
        double d = this.a(pnt2d4, pnt2d3);
        if (d < 0.0) {
            return new Pnt2d(line2d.x1, line2d.y1);
        }
        if (d > pnt2d3.distance(0.0, 0.0)) {
            return new Pnt2d(line2d.x2, line2d.y2);
        }
        return new Pnt2d(line2d.x1 + d * pnt2d4.x, line2d.y1 + d * pnt2d4.y);
    }

    private Pnt2d a(Pnt2d pnt2d) {
        double d = Math.sqrt(Math.pow(pnt2d.x, 2.0) + Math.pow(pnt2d.y, 2.0));
        return new Pnt2d(pnt2d.x / d, pnt2d.y / d);
    }

    private double a(Pnt2d pnt2d, Pnt2d pnt2d2) {
        return pnt2d.x * pnt2d2.x + pnt2d.y * pnt2d2.y;
    }

    @Override
    protected boolean isTargetBody(GNode gNode) {
        return gNode instanceof GArrow;
    }

    @Override
    protected abstract Pnt2d getButtonPoint(GNode var1, GIconButton var2, Pnt2d var3);
}

