/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import java.awt.AWTEvent;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import net.astah.golf.control.GolfAction;
import net.astah.golf.draw.GDropDownButton;
import net.astah.golf.draw.GIconButton;
import net.astah.golf.draw.GNode;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.widget.CCanvas;
import net.astah.golf.widget.CImageIcon;
import net.astah.jomt.jutil.DropDownButtonUtil;
import net.astah.jomt.jview.DrawSuggest;
import net.astah.notation.editor.IViewElement;

public abstract class BaseDrawSuggest
implements DrawSuggest {
    private IViewElement a;
    private GNode b;

    public BaseDrawSuggest(IViewElement iViewElement) {
        this.setOwner(iViewElement);
    }

    @Override
    public boolean doAction(CCanvas cCanvas, Pnt2d pnt2d, int n) {
        for (GNode gNode : this.b.getChildren()) {
            AWTEvent aWTEvent;
            GolfAction golfAction;
            if (!((GIconButton)gNode).contains(pnt2d.getX(), pnt2d.getY())) continue;
            if (gNode instanceof GDropDownButton) {
                gNode.setModel((Object)this);
                golfAction = ((GDropDownButton)gNode).getAction(pnt2d);
                DropDownButtonUtil.setButton((GDropDownButton)gNode);
                aWTEvent = new MouseEvent(cCanvas.getComponent(), n, System.currentTimeMillis(), 0, (int)pnt2d.getX(), (int)pnt2d.getY(), (int)pnt2d.getX(), (int)pnt2d.getY(), 1, true, 1);
                DropDownButtonUtil.setMouseEvent((MouseEvent)aWTEvent);
            } else {
                golfAction = ((GIconButton)gNode).getAction();
            }
            aWTEvent = new ActionEvent(this, n, golfAction.getActionName());
            golfAction.actionPerformed(aWTEvent);
            return true;
        }
        return false;
    }

    @Override
    public boolean doDoubleClick(CCanvas cCanvas, Pnt2d pnt2d, int n) {
        return false;
    }

    @Override
    public DrawSuggest activate(Pnt2d pnt2d, DrawSuggest drawSuggest, boolean bl) {
        if (!this.contains(pnt2d, bl)) {
            return drawSuggest == this ? null : drawSuggest;
        }
        if (drawSuggest != null) {
            if (drawSuggest != this && ((BaseDrawSuggest)drawSuggest).contains(pnt2d, true)) {
                return drawSuggest;
            }
            if (((GNode)this.a).getDepth() > ((GNode)drawSuggest.getOwner()).getDepth()) {
                return drawSuggest;
            }
        }
        this.relocate(pnt2d);
        if (!((GNode)this.a).getAllNodes().containsAll(Arrays.asList(this.a()))) {
            ((GNode)this.a).addNodes(this.a());
        }
        return this;
    }

    @Override
    public void deactivate() {
        ((GNode)this.a).removeNodes(this.a());
    }

    private GNode[] a() {
        return this.b.getChildren().toArray(new GNode[this.b.getChildren().size()]);
    }

    @Override
    public abstract Pnt2d createModeArgumentPoint(Pnt2d var1);

    public void setOwner(IViewElement iViewElement) {
        this.a = iViewElement;
    }

    @Override
    public IViewElement getOwner() {
        return this.a;
    }

    public void setButtonManager(GNode gNode) {
        this.b = gNode;
    }

    public GNode getButtonManager() {
        return this.b;
    }

    public void addButton(GIconButton gIconButton) {
        if (this.b == null) {
            this.b = new GNode();
        }
        this.b.addChild((GNode)gIconButton);
    }

    protected abstract boolean contains(Pnt2d var1);

    protected abstract boolean contains(Pnt2d var1, boolean var2);

    public void addModeAction(String string, CImageIcon cImageIcon) {
        this.addCommandAction("SetMode%" + string + "Mode", cImageIcon);
    }

    public void addModeAction(String string, CImageIcon cImageIcon, String string2) {
        this.addCommandAction("SetMode%" + string + "Mode", cImageIcon, string2);
    }

    public void addCommandAction(String string, CImageIcon cImageIcon) {
        this.addButton(new GIconButton(cImageIcon, string, 1));
    }

    public void addCommandAction(String string, int n, CImageIcon cImageIcon) {
        this.addButton(new GIconButton(cImageIcon, string, n));
    }

    public void addCommandAction(String string, CImageIcon cImageIcon, String string2) {
        this.addButton(new GDropDownButton(cImageIcon, string, 1, string2));
    }

    protected void relocate(Pnt2d pnt2d) {
        IViewElement iViewElement = this.getOwner();
        if (iViewElement instanceof GNode) {
            List list = ((GNode)iViewElement).getChildren();
            for (GNode gNode : list) {
                if (!this.isTargetBody(gNode)) continue;
                for (GNode gNode2 : this.b.getChildren().toArray(new GNode[0])) {
                    GIconButton gIconButton = (GIconButton)gNode2;
                    Pnt2d pnt2d2 = this.getButtonPoint(gNode, gIconButton, pnt2d);
                    if (pnt2d2 == null) continue;
                    this.setButtonLocation(gIconButton, gNode, pnt2d2);
                }
            }
        }
    }

    protected void setButtonLocation(GIconButton gIconButton, GNode gNode, Pnt2d pnt2d) {
        gIconButton.setPoint(pnt2d);
    }

    protected abstract boolean isTargetBody(GNode var1);

    protected abstract Pnt2d getButtonPoint(GNode var1, GIconButton var2, Pnt2d var3);
}

