/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jutil;

import com.google.common.base.Strings;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import java.util.function.Function;
import javax.swing.SwingUtilities;
import lombok.NonNull;
import net.astah.golf.util.GolfUtilities;
import net.astah.jmodel.MessageManagerAccessor;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jutil.JomtWidgetFactory;
import net.astah.jomt.jutil.PathUtil;

public class SaveFileChooser {
    protected final Component parentComponent;
    protected final String filterExtension;
    protected final String filterDescription;
    protected final String initialFileName;
    protected final boolean doBackup;

    public SaveFileChooser(Component component, String string, String string2, String string3, boolean bl) {
        this.parentComponent = component;
        this.filterExtension = Strings.nullToEmpty((String)string);
        this.filterDescription = Strings.nullToEmpty((String)string2);
        this.initialFileName = string3;
        this.doBackup = bl;
    }

    public boolean select(@NonNull Function<File, Boolean> function) {
        if (function == null) {
            throw new NullPointerException("saveAction");
        }
        MessageManagerAccessor messageManagerAccessor = ModelGlobal.messageManagerAccessor;
        File file = this.a();
        while (true) {
            if ((file = this.a(file)) == null) {
                return false;
            }
            if (!function.apply(file).booleanValue()) continue;
            if (file.exists()) break;
            messageManagerAccessor.displayAlertMessageDialog("app", "tell_save_fail.message");
        }
        return true;
    }

    private File a() {
        if (Strings.isNullOrEmpty((String)this.initialFileName)) {
            return new File(this.getDefaultDirectory());
        }
        return new File(this.getDefaultDirectory(), this.initialFileName);
    }

    protected String getDefaultDirectory() {
        return System.getProperty("user.dir");
    }

    private File a(File file) {
        block7: {
            MessageManagerAccessor messageManagerAccessor = ModelGlobal.messageManagerAccessor;
            while (true) {
                if ((file = this.b(file)) == null) {
                    return null;
                }
                if (!file.exists()) {
                    if (!PathUtil.isLegalFileName((String)file.getName())) {
                        messageManagerAccessor.displayErrorMessage("app", "tell_save_fail_illegal_file_name.message");
                        continue;
                    }
                    break block7;
                }
                if (!file.canWrite()) {
                    messageManagerAccessor.displayAlertMessageDialog("app", "read_only.message");
                    continue;
                }
                int n = messageManagerAccessor.displayMessageYesNoDialog("app", "ask_overwrite_file.message");
                if (n == 0) {
                    if (this.doBackup) {
                        this.backup(file);
                    }
                    break block7;
                }
                if (n != 1) break;
            }
            return null;
        }
        return file;
    }

    private File b(File file) {
        File file2;
        Object object;
        String string;
        String string2;
        if (file.isDirectory()) {
            string2 = file.getPath();
            string = "";
        } else {
            string2 = file.getParent();
            string = file.getName();
        }
        if (PropertyManager.isMacOS()) {
            object = this.b();
            ((FileDialog)object).setMode(1);
            ((FileDialog)object).setFilenameFilter(new a());
            ((FileDialog)object).setFile(string);
            ((FileDialog)object).setDirectory(string2);
            ((Dialog)object).setVisible(true);
            if (((FileDialog)object).getFile() == null) {
                return null;
            }
            file2 = new File(((FileDialog)object).getDirectory() + ((FileDialog)object).getFile());
        } else {
            object = JomtWidgetFactory.instance().createFileChooser(string2, "Save Dialog");
            if (!Strings.isNullOrEmpty((String)this.filterExtension)) {
                object.setFileFilter(this.filterExtension, this.filterDescription);
            }
            object.setSelectedFile(new File(string2, string.isEmpty() ? File.separator : string));
            if (!object.isApproveSaveDialog()) {
                return null;
            }
            file2 = object.getSelectedFile();
        }
        object = file2.getAbsolutePath();
        if (!Strings.isNullOrEmpty((String)this.filterExtension) && !((String)object).endsWith("." + this.filterExtension)) {
            object = (String)object + "." + this.filterExtension;
        }
        return new File(GolfUtilities.normalizeToNFC((String)object));
    }

    private FileDialog b() {
        if (this.parentComponent instanceof Frame) {
            return new FileDialog((Frame)this.parentComponent);
        }
        if (this.parentComponent instanceof Dialog) {
            return new FileDialog((Dialog)this.parentComponent);
        }
        Dialog dialog = SaveFileChooser.a(Dialog.class, this.parentComponent);
        if (dialog != null) {
            return new FileDialog(dialog);
        }
        Frame frame = SaveFileChooser.a(Frame.class, this.parentComponent);
        if (frame != null) {
            return new FileDialog(frame);
        }
        return new FileDialog((Frame)null);
    }

    private static <T> T a(Class<T> clazz, Component component) {
        return clazz.cast(SwingUtilities.getAncestorOfClass(clazz, component));
    }

    protected void backup(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("targetFile");
        }
        String string = file + ".bak";
        File file2 = new File(string);
        if (file2.exists()) {
            file2.delete();
        }
        file.renameTo(file2);
    }

    class a
    implements FilenameFilter {
        a() {
        }

        @Override
        public boolean accept(File file, String string) {
            if (Strings.isNullOrEmpty((String)SaveFileChooser.this.filterExtension)) {
                return true;
            }
            return string.toLowerCase().endsWith("." + SaveFileChooser.this.filterExtension);
        }
    }
}

