/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.draw;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.ImageIcon;
import net.astah.golf.control.GolfAction;
import net.astah.golf.draw.GGraphics;
import net.astah.golf.draw.GIconButton;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.util.ResourceBundleList;
import net.astah.golf.widget.CImageIcon;
import net.astah.golf.widget.swing.SwingImageIcon;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jview.IconResource;

public class GDropDownButton
extends GIconButton {
    private GIconButton arrow;
    private String key;
    public static final double OFFSET = 5.0;

    public GDropDownButton(CImageIcon cImageIcon, String string, int n, String string2) {
        super(cImageIcon, string, n);
        this.key = string2;
        SwingImageIcon swingImageIcon = new SwingImageIcon((ImageIcon)IconResource.getNormalSizeArrowDownIcon2());
        this.arrow = new GIconButton((CImageIcon)swingImageIcon, GDropDownButton.getSetDropDownButtonModeCommandString() + "%" + string2, 1);
    }

    private static String getSetDropDownButtonModeCommandString() {
        ResourceBundleList resourceBundleList = PropertyManager.getJudeResourceBundle();
        if (resourceBundleList != null) {
            String string = resourceBundleList.getString("jude.set_drop_down_button_mode_command");
            return string;
        }
        return "";
    }

    public boolean intersect(Rectangle2d rectangle2d) {
        Rectangle2d rectangle2d2 = new Rectangle2d(this.x, this.y, this.getWidth(), this.getHeight());
        rectangle2d2.add((Rectangle2D)new Rectangle2d(this.arrow.x, this.arrow.y, this.arrow.getWidth(), this.arrow.getHeight()));
        return rectangle2d.intersects((Rectangle2D)rectangle2d2);
    }

    public boolean contains(double d, double d2) {
        Rectangle2d rectangle2d = new Rectangle2d(this.x, this.y, this.getWidth(), this.getHeight());
        rectangle2d.add((Rectangle2D)new Rectangle2d(this.arrow.x, this.arrow.y, this.arrow.getWidth(), this.arrow.getHeight()));
        return rectangle2d.contains(d, d2);
    }

    public void draw(GGraphics gGraphics) {
        if (gGraphics.printing) {
            return;
        }
        super.draw(gGraphics);
        this.arrow.draw(gGraphics);
    }

    public void setPoint(double d, double d2) {
        super.setPoint(d, d2);
        this.arrow.setPoint(d + this.getWidth() - 5.0, d2);
    }

    public GolfAction getAction(Pnt2d pnt2d) {
        Rectangle2d rectangle2d = new Rectangle2d(this.arrow.x + 5.0, this.arrow.y, this.arrow.getWidth() - 5.0, this.arrow.getHeight());
        if (rectangle2d.contains((Point2D)pnt2d)) {
            return this.arrow.getAction();
        }
        return this.getAction();
    }

    public double getArrowWidth() {
        return this.arrow.getWidth() - 5.0;
    }

    public double getArrowHeight() {
        return this.arrow.getHeight();
    }

    public void setArrowActionArgument(String string) {
        if (!this.key.equals(string)) {
            this.key = string;
            GolfAction golfAction = new GolfAction(GDropDownButton.getSetDropDownButtonModeCommandString() + "%" + string);
            this.arrow.setAction(golfAction);
        }
    }
}

