/*
 * Decompiled with CFR 0.152.
 */
package net.astah.project.util;

import java.io.IOException;
import java.util.Map;
import java.util.function.Predicate;
import net.astah.project.Facet;
import net.astah.project.PreferenceContainer;
import net.astah.project.Project;
import net.astah.project.ProjectElement;
import net.astah.project.ProjectPackage;
import net.astah.project.StylePreferenceContainer;
import net.astah.project.StylePreferences;
import net.astah.project.VersionHistory;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class ProjectValidator
extends EObjectValidator {
    public static final ProjectValidator INSTANCE = new ProjectValidator();
    public static final String DIAGNOSTIC_SOURCE = "net.astah.project";
    public static final int FACET__VALIDATE_CONTENTS = 1;
    private static final int a = 1;
    protected static final int DIAGNOSTIC_CODE_COUNT = 1;

    protected EPackage getEPackage() {
        return ProjectPackage.eINSTANCE;
    }

    protected boolean validate(int n, Object object, DiagnosticChain diagnosticChain, Map<Object, Object> map) {
        switch (n) {
            case 0: {
                return this.validateProjectElement((ProjectElement)object, diagnosticChain, map);
            }
            case 1: {
                return this.validateProject((Project)object, diagnosticChain, map);
            }
            case 2: {
                return this.validateFacet((Facet)object, diagnosticChain, map);
            }
            case 3: {
                return this.validateStylePreferenceContainer((StylePreferenceContainer)object, diagnosticChain, map);
            }
            case 4: {
                return this.validateStylePreferences((StylePreferences)object, diagnosticChain, map);
            }
            case 5: {
                return this.validateStylePreferenceEntry((Map.Entry)object, diagnosticChain, map);
            }
            case 6: {
                return this.validateVersionHistory((VersionHistory)object, diagnosticChain, map);
            }
            case 7: {
                return this.validatePreferenceContainer((PreferenceContainer)object, diagnosticChain, map);
            }
            case 8: {
                return this.validateSequencer((Map.Entry)object, diagnosticChain, map);
            }
            case 9: {
                return this.validateURI((URI)object, diagnosticChain, map);
            }
            case 10: {
                return this.validateResource((Resource)object, diagnosticChain, map);
            }
            case 11: {
                return this.validateIOException((IOException)object, diagnosticChain, map);
            }
            case 12: {
                return this.validatePredicate((Predicate)object, diagnosticChain, map);
            }
        }
        return true;
    }

    public boolean validateProjectElement(ProjectElement projectElement, DiagnosticChain diagnosticChain, Map<Object, Object> map) {
        return this.validate_EveryDefaultConstraint(projectElement, diagnosticChain, map);
    }

    public boolean validateProject(Project project, DiagnosticChain diagnosticChain, Map<Object, Object> map) {
        return this.validate_EveryDefaultConstraint(project, diagnosticChain, map);
    }

    public boolean validateFacet(Facet facet, DiagnosticChain diagnosticChain, Map<Object, Object> map) {
        if (!this.validate_NoCircularContainment(facet, diagnosticChain, map)) {
            return false;
        }
        boolean bl = this.validate_EveryMultiplicityConforms(facet, diagnosticChain, map);
        if (bl || diagnosticChain != null) {
            bl &= this.validate_EveryDataValueConforms(facet, diagnosticChain, map);
        }
        if (bl || diagnosticChain != null) {
            bl &= this.validate_EveryReferenceIsContained(facet, diagnosticChain, map);
        }
        if (bl || diagnosticChain != null) {
            bl &= this.validate_EveryBidirectionalReferenceIsPaired(facet, diagnosticChain, map);
        }
        if (bl || diagnosticChain != null) {
            bl &= this.validate_EveryProxyResolves(facet, diagnosticChain, map);
        }
        if (bl || diagnosticChain != null) {
            bl &= this.validate_UniqueID(facet, diagnosticChain, map);
        }
        if (bl || diagnosticChain != null) {
            bl &= this.validate_EveryKeyUnique(facet, diagnosticChain, map);
        }
        if (bl || diagnosticChain != null) {
            bl &= this.validate_EveryMapEntryUnique(facet, diagnosticChain, map);
        }
        if (bl || diagnosticChain != null) {
            bl &= this.validateFacet_validateContents(facet, diagnosticChain, map);
        }
        return bl;
    }

    public boolean validateFacet_validateContents(Facet facet, DiagnosticChain diagnosticChain, Map<Object, Object> map) {
        return facet.validateContents(diagnosticChain, map);
    }

    public boolean validateStylePreferenceContainer(StylePreferenceContainer stylePreferenceContainer, DiagnosticChain diagnosticChain, Map<Object, Object> map) {
        return this.validate_EveryDefaultConstraint(stylePreferenceContainer, diagnosticChain, map);
    }

    public boolean validateStylePreferences(StylePreferences stylePreferences, DiagnosticChain diagnosticChain, Map<Object, Object> map) {
        return this.validate_EveryDefaultConstraint(stylePreferences, diagnosticChain, map);
    }

    public boolean validateStylePreferenceEntry(Map.Entry<?, ?> entry, DiagnosticChain diagnosticChain, Map<Object, Object> map) {
        return this.validate_EveryDefaultConstraint((EObject)entry, diagnosticChain, map);
    }

    public boolean validateVersionHistory(VersionHistory versionHistory, DiagnosticChain diagnosticChain, Map<Object, Object> map) {
        return this.validate_EveryDefaultConstraint(versionHistory, diagnosticChain, map);
    }

    public boolean validatePreferenceContainer(PreferenceContainer preferenceContainer, DiagnosticChain diagnosticChain, Map<Object, Object> map) {
        return this.validate_EveryDefaultConstraint(preferenceContainer, diagnosticChain, map);
    }

    public boolean validateSequencer(Map.Entry<?, ?> entry, DiagnosticChain diagnosticChain, Map<Object, Object> map) {
        return this.validate_EveryDefaultConstraint((EObject)entry, diagnosticChain, map);
    }

    public boolean validateURI(URI uRI, DiagnosticChain diagnosticChain, Map<Object, Object> map) {
        return true;
    }

    public boolean validateResource(Resource resource, DiagnosticChain diagnosticChain, Map<Object, Object> map) {
        return true;
    }

    public boolean validateIOException(IOException iOException, DiagnosticChain diagnosticChain, Map<Object, Object> map) {
        return true;
    }

    public boolean validatePredicate(Predicate<?> predicate, DiagnosticChain diagnosticChain, Map<Object, Object> map) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

