/*
 * Decompiled with CFR 0.152.
 */
package net.astah.project.resource.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.astah.project.Project;
import net.astah.project.ProjectManagerAdapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;

public class ProjectResourceURIHandlerImpl
extends URIHandlerImpl {
    public static final String SCHEME_PROJECT = "project";
    protected final ProjectManagerAdapter projectManager;

    public ProjectResourceURIHandlerImpl(ProjectManagerAdapter projectManagerAdapter) {
        this.projectManager = Objects.requireNonNull(projectManagerAdapter, "projectManager");
    }

    public static boolean isProjectResource(URI uRI) {
        return SCHEME_PROJECT.equals(uRI.scheme());
    }

    public Project getProject(URI uRI) {
        if (uRI.isPlatformResource()) {
            return this.getPlatformResourceOwner(uRI);
        }
        if (ProjectResourceURIHandlerImpl.isProjectResource(uRI)) {
            return this.getProjectResourceOwner(uRI);
        }
        return null;
    }

    public boolean canHandle(URI uRI) {
        if (uRI.isPlatformResource()) {
            return this.getPlatformResourceOwner(uRI) != null;
        }
        return ProjectResourceURIHandlerImpl.isProjectResource(uRI);
    }

    public OutputStream createOutputStream(URI uRI, Map<?, ?> map) throws IOException {
        Map.Entry<Project, URI> entry = this.mapRequiredURI(uRI, map);
        this.ensureWritable(uRI, entry.getKey());
        URIConverter uRIConverter = this.getURIConverter(map);
        return uRIConverter.createOutputStream(entry.getValue(), map);
    }

    public InputStream createInputStream(URI uRI, Map<?, ?> map) throws IOException {
        Map.Entry<Project, URI> entry = this.mapRequiredURI(uRI, map);
        URIConverter uRIConverter = this.getURIConverter(map);
        return uRIConverter.createInputStream(entry.getValue(), map);
    }

    public void delete(URI uRI, Map<?, ?> map) throws IOException {
        Map.Entry<Project, URI> entry = this.mapRequiredURI(uRI, map);
        this.ensureWritable(uRI, entry.getKey());
        URIConverter uRIConverter = this.getURIConverter(map);
        uRIConverter.delete(entry.getValue(), map);
    }

    public Map<String, ?> contentDescription(URI uRI, Map<?, ?> map) throws IOException {
        Map.Entry<Project, URI> entry = this.mapRequiredURI(uRI, map);
        URIConverter uRIConverter = this.getURIConverter(map);
        return uRIConverter.contentDescription(entry.getValue(), map);
    }

    public boolean exists(URI uRI, Map<?, ?> map) {
        Map.Entry<Project, URI> entry = this.mapURI(uRI, map);
        if (entry != null) {
            URIConverter uRIConverter = this.getURIConverter(map);
            return uRIConverter.exists(entry.getValue(), map);
        }
        return false;
    }

    public Map<String, ?> getAttributes(URI uRI, Map<?, ?> map) {
        Map.Entry<Project, URI> entry = this.mapURI(uRI, map);
        if (entry != null) {
            Set set;
            URIConverter uRIConverter = this.getURIConverter(map);
            Map map2 = uRIConverter.getAttributes(entry.getValue(), map);
            Object v = map2.get("readOnly");
            if (!(v instanceof Boolean && ((Boolean)v).booleanValue() || (set = this.getRequestedAttributes(map)) != null && !set.contains("readOnly"))) {
                Project project = entry.getKey();
                map2.put("readOnly", project.isReadonly());
            }
            return map2;
        }
        return new HashMap();
    }

    public void setAttributes(URI uRI, Map<String, ?> map, Map<?, ?> map2) throws IOException {
        Map.Entry<Project, URI> entry = this.mapRequiredURI(uRI, map2);
        this.ensureWritable(uRI, entry.getKey());
        URIConverter uRIConverter = this.getURIConverter(map2);
        uRIConverter.setAttributes(entry.getValue(), map, map2);
    }

    protected Map.Entry<Project, URI> mapURI(URI uRI, Map<?, ?> map) {
        Project project = this.getProject(uRI);
        if (project == null) {
            return null;
        }
        URI uRI2 = project.getRealURI();
        if (uRI2 == null) {
            return null;
        }
        int n = uRI.segmentCount();
        if (n == 2) {
            uRI2 = uRI2.appendSegment(uRI.segment(1));
        } else if (n > 2) {
            uRI2 = uRI2.appendSegments(Arrays.copyOfRange(uRI.segments(), 1, n));
        }
        if (uRI.hasQuery()) {
            uRI2 = uRI2.appendQuery(uRI.query());
        }
        if (uRI.hasFragment()) {
            uRI2 = uRI2.appendFragment(uRI.fragment());
        }
        return new AbstractMap.SimpleEntry<Project, URI>(project, uRI2);
    }

    protected Map.Entry<Project, URI> mapRequiredURI(URI uRI, Map<?, ?> map) throws IOException {
        Map.Entry<Project, URI> entry = this.mapURI(uRI, map);
        if (entry == null) {
            throw new FileNotFoundException(uRI.toString());
        }
        return entry;
    }

    protected void ensureWritable(URI uRI, Project project) throws IOException {
        if (project.isReadonly()) {
            throw new IOException("Readonly: " + uRI);
        }
    }

    protected Project getProjectResourceOwner(URI uRI) {
        int n = uRI.segmentCount();
        if (n < 1) {
            return null;
        }
        String string = uRI.segment(0);
        return this.projectManager.getProject(string);
    }

    protected Project getPlatformResourceOwner(URI uRI) {
        String string = uRI.toPlatformString(true);
        for (Project project : this.projectManager.getProjects().values()) {
            File file;
            URI uRI2 = project.getRealURI();
            if (uRI2 == null || !uRI2.isFile() || !(file = new File(uRI2.toFileString(), string)).exists()) continue;
            return project;
        }
        return null;
    }
}

