/*
 * Decompiled with CFR 0.152.
 */
package net.astah.project.resource.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.astah.emf.common.resource.ProgressInputStream;
import net.astah.emf.common.resource.Resources;
import net.astah.project.resource.AstahXMIResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;

public class AstahURIConverterImpl
extends ExtensibleURIConverterImpl {
    private static final URI a = URI.createURI((String)"/");

    public AstahURIConverterImpl() {
    }

    public AstahURIConverterImpl(Collection<URIHandler> collection, Collection<ContentHandler> collection2) {
        super(collection, collection2);
    }

    public InputStream createInputStream(URI uRI, Map<?, ?> map) throws IOException {
        long l;
        IProgressMonitor iProgressMonitor;
        InputStream inputStream = super.createInputStream(uRI, map);
        if (map != null && (iProgressMonitor = Resources.getProgressMonitor(map, (String)"MONITOR")) != null && (l = this.getLengthAttribute(uRI, map)) >= 0L) {
            int n = (int)Math.min(l, Integer.MAX_VALUE);
            iProgressMonitor.beginTask("Loading " + uRI, n);
            return new ProgressInputStream(inputStream, iProgressMonitor);
        }
        return inputStream;
    }

    public URI normalize(URI uRI) {
        return super.normalize(this.mapArchiveURI(uRI));
    }

    protected URI mapArchiveURI(URI uRI) {
        int n = 0;
        URI uRI2 = null;
        String[] stringArray = uRI.segments();
        for (int i = 1; i < stringArray.length; ++i) {
            String string = stringArray[i - 1];
            int n2 = string.lastIndexOf(46);
            if (n2 <= 0 || !this.isArchiveExtension(string.substring(n2 + 1))) continue;
            if (uRI2 == null) {
                uRI2 = a.resolve(uRI);
            }
            uRI2 = uRI2.appendSegments(Arrays.copyOfRange(stringArray, n, i));
            uRI2 = this.toArchiveURI(uRI2);
            n = i;
        }
        if (uRI2 == null) {
            return uRI;
        }
        String[] stringArray2 = Arrays.copyOfRange(stringArray, n, stringArray.length);
        return URI.createHierarchicalURI((String[])stringArray2, (String)uRI.query(), (String)uRI.fragment()).resolve(uRI2);
    }

    protected boolean isArchiveExtension(String string) {
        return AstahXMIResource.ARCHIVE_EXTENSION.equalsIgnoreCase(string);
    }

    protected URI toArchiveURI(URI uRI) {
        return URI.createURI((String)("archive:" + super.normalize(uRI) + "!/"));
    }

    protected long getLengthAttribute(URI uRI, Map<?, ?> map) {
        HashMap hashMap = new HashMap(map);
        hashMap.put("requestedAttributes", Collections.singleton("length"));
        Map map2 = this.getAttributes(uRI, hashMap);
        Object v = map2.get("length");
        return v instanceof Number ? ((Number)v).longValue() : -1L;
    }
}

