/*
 * Decompiled with CFR 0.152.
 */
package net.astah.project.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.astah.emf.common.resource.ResourceSets;
import net.astah.emf.common.resource.Resources;
import net.astah.project.Facet;
import net.astah.project.Messages;
import net.astah.project.Project;
import net.astah.project.ProjectManagerAdapter;
import net.astah.project.ProjectPackage;
import net.astah.project.impl.ProjectElementImpl;
import net.astah.project.impl.a;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectImpl
extends ProjectElementImpl
implements Project {
    private static final Logger b = LoggerFactory.getLogger(ProjectImpl.class);
    protected static final String ID_EDEFAULT = null;
    protected String id = ID_EDEFAULT;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final URI REAL_URI_EDEFAULT = null;
    protected URI realURI = REAL_URI_EDEFAULT;
    protected static final URI VIRTUAL_URI_EDEFAULT = null;
    protected URI virtualURI = VIRTUAL_URI_EDEFAULT;
    protected EList<Resource> mutableResources;
    protected EList<Resource> resources;
    protected Map<String, Facet> facetMap;
    protected static final boolean READONLY_EDEFAULT = false;
    protected boolean readonly = false;
    protected static final boolean MODIFIED_EDEFAULT = false;
    protected boolean modified = false;
    protected static final boolean MANAGED_EDEFAULT = false;
    protected boolean managed = false;
    protected EList<Project> nestedProjects;
    protected EList<Project> dependingProjects;
    protected EList<Facet> facets;
    protected EList<EObject> contents;

    protected ProjectImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return ProjectPackage.Literals.PROJECT;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        String string2 = this.id;
        this.id = string;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)string2, (Object)this.id));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void internalSetName(String string) {
        String string2 = this.name;
        this.name = string;
        ProjectManagerAdapter projectManagerAdapter = this.b();
        if (this.a(projectManagerAdapter)) {
            this.a(projectManagerAdapter, (Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)string2, (Object)this.name));
        }
    }

    @Override
    public URI getRealURI() {
        return this.realURI;
    }

    @Override
    public void setRealURI(URI uRI) {
        this.a();
        URI uRI2 = ProjectManagerAdapter.resolveProjectURI(uRI);
        this.eDirectResource().setURI(uRI2);
    }

    public void internalSetRealURI(URI uRI) {
        URI uRI2 = this.realURI;
        this.realURI = uRI;
        ProjectManagerAdapter projectManagerAdapter = this.b();
        if (this.a(projectManagerAdapter)) {
            this.a(projectManagerAdapter, (Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)uRI2, (Object)this.realURI));
        }
    }

    @Override
    public URI getVirtualURI() {
        return this.virtualURI;
    }

    public void internalSetVirtualURI(URI uRI) {
        URI uRI2 = this.virtualURI;
        this.virtualURI = uRI;
        ProjectManagerAdapter projectManagerAdapter = this.b();
        if (this.a(projectManagerAdapter)) {
            this.a(projectManagerAdapter, (Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)uRI2, (Object)this.virtualURI));
        }
    }

    public EList<Resource> getMutableResources() {
        if (this.mutableResources == null) {
            this.mutableResources = new ResourcesEList(null);
        }
        return this.mutableResources;
    }

    public void unsetMutableResources() {
        this.mutableResources = null;
        this.resources = null;
    }

    @Override
    public EList<Resource> getResources() {
        if (this.resources == null) {
            this.resources = ECollections.unmodifiableEList(this.getMutableResources());
        }
        return this.resources;
    }

    @Override
    public boolean isReadonly() {
        return this.readonly;
    }

    public void internalSetReadonly(boolean bl) {
        boolean bl2 = this.readonly;
        this.readonly = bl;
        ProjectManagerAdapter projectManagerAdapter = this.b();
        if (this.a(projectManagerAdapter)) {
            this.a(projectManagerAdapter, (Notification)new ENotificationImpl((InternalEObject)this, 1, 13, bl2, this.readonly));
        }
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void setModified(boolean bl) {
        this.a();
        if (!bl && this.mutableResources != null) {
            for (Resource resource : this.mutableResources) {
                resource.setModified(false);
            }
        }
        this.eDirectResource().setModified(bl);
    }

    public void internalSetModified(boolean bl) {
        boolean bl2 = this.modified;
        this.modified = bl;
        ProjectManagerAdapter projectManagerAdapter = this.b();
        if (this.a(projectManagerAdapter)) {
            this.a(projectManagerAdapter, (Notification)new ENotificationImpl((InternalEObject)this, 1, 14, bl2, this.modified));
        }
    }

    @Override
    public boolean isManaged() {
        return this.managed;
    }

    public void internalSetManaged(boolean bl) {
        boolean bl2 = this.managed;
        this.managed = bl;
        ProjectManagerAdapter projectManagerAdapter = this.b();
        if (this.a(projectManagerAdapter)) {
            this.a(projectManagerAdapter, (Notification)new ENotificationImpl((InternalEObject)this, 1, 15, bl2, this.managed));
        }
    }

    @Override
    public Project getNestingProject() {
        if (this.eContainerFeatureID() != 16) {
            return null;
        }
        return (Project)this.eContainer();
    }

    public Project basicGetNestingProject() {
        if (this.eContainerFeatureID() != 16) {
            return null;
        }
        return (Project)this.eInternalContainer();
    }

    public NotificationChain basicSetNestingProject(Project project, NotificationChain notificationChain) {
        notificationChain = this.eBasicSetContainer((InternalEObject)project, 16, notificationChain);
        return notificationChain;
    }

    @Override
    public void setNestingProject(Project project) {
        if (project != this.eInternalContainer() || this.eContainerFeatureID() != 16 && project != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)project)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain notificationChain = null;
            if (this.eInternalContainer() != null) {
                notificationChain = this.eBasicRemoveFromContainer(notificationChain);
            }
            if (project != null) {
                notificationChain = ((InternalEObject)project).eInverseAdd((InternalEObject)this, 17, Project.class, notificationChain);
            }
            if ((notificationChain = this.basicSetNestingProject(project, notificationChain)) != null) {
                notificationChain.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 16, (Object)project, (Object)project));
        }
    }

    @Override
    public EList<Project> getNestedProjects() {
        if (this.nestedProjects == null) {
            this.nestedProjects = new EObjectContainmentWithInverseEList.Resolving(Project.class, (InternalEObject)this, 17, 16);
        }
        return this.nestedProjects;
    }

    @Override
    public EList<Project> getDependingProjects() {
        if (this.dependingProjects == null) {
            this.dependingProjects = new EObjectResolvingEList(Project.class, (InternalEObject)this, 18);
        }
        return this.dependingProjects;
    }

    @Override
    public EList<Facet> getFacets() {
        if (this.facets == null) {
            this.facets = new EObjectContainmentWithInverseEList.Resolving(Facet.class, (InternalEObject)this, 19, 8);
        }
        return this.facets;
    }

    @Override
    public EList<EObject> getContents() {
        if (this.contents == null) {
            this.contents = new EObjectResolvingEList(EObject.class, (InternalEObject)this, 20);
        }
        return this.contents;
    }

    @Override
    public void load(Map<?, ?> map) throws IOException {
        Object object2;
        List list = this.getMutableResources().stream().filter(resource -> !resource.isLoaded()).collect(Collectors.toList());
        HashMap hashMap = new HashMap(map != null ? map : Collections.emptyMap());
        SubMonitor subMonitor = Resources.getSubMonitor(map, (String)"MONITOR");
        subMonitor.beginTask(Messages.ProjectImpl_loadingResources, list.size() * 5);
        for (Object object2 : list) {
            URI uRI = object2.getURI();
            String string = uRI.lastSegment();
            subMonitor.subTask(NLS.bind((String)Messages.ProjectImpl_loadingResource, (Object)string));
            hashMap.put("MONITOR", subMonitor.newChild(4));
            b.debug("Loading model resource[uri={}]", (Object)uRI);
            object2.load(hashMap);
        }
        this.validateOnLoad();
        ResourceSet resourceSet = this.eResource().getResourceSet();
        object2 = eObject -> ResourceSets.isLoaded((ResourceSet)resourceSet, (EObject)eObject);
        for (String string : list) {
            ResourceSets.resolveAllProperContents((Resource)string, (Predicate)object2);
            subMonitor.worked(1);
        }
        b.debug("Loading project is completed[id={}]", (Object)this.getId());
        subMonitor.done();
    }

    @Override
    public void save(Map<?, ?> map) throws IOException {
        this.a();
        boolean bl = this.isSaveUnmodified(map);
        if (this.mutableResources != null) {
            for (Resource resource : this.mutableResources) {
                if (!bl && !resource.isModified()) continue;
                this.doSave(resource, map);
            }
        }
        Resource.Internal internal = this.eDirectResource();
        if (bl || internal.isModified()) {
            this.doSave((Resource)internal, map);
        }
    }

    @Override
    public void saveAs(URI uRI, Map<?, ?> map) throws IOException {
        this.setRealURI(uRI);
        this.save(map);
    }

    @Override
    public void close() {
        this.a();
        Resource.Internal internal = this.eDirectResource();
        EList eList = internal.getResourceSet().getResources();
        if (this.mutableResources != null) {
            for (Resource resource : this.mutableResources) {
                resource.unload();
            }
            eList.removeAll(this.mutableResources);
            assert (this.mutableResources.isEmpty());
        }
        internal.unload();
        eList.remove((Object)internal);
    }

    @Override
    public URI createResourceURI(String string) {
        URI uRI = URI.createURI((String)string);
        Preconditions.checkArgument((boolean)uRI.isRelative(), (Object)"segments must be relative URI");
        return this.virtualURI != null ? this.virtualURI.appendSegments(uRI.segments()) : null;
    }

    @Override
    public Facet getFacet(String string) {
        assert (!this.eIsSet(19) || this.facetMap != null) : "missing ProjectManagerAdapter";
        return this.facetMap != null ? this.facetMap.get(string) : null;
    }

    public Map<String, Facet> getFacetMap() {
        if (this.facetMap == null) {
            this.facetMap = new HashMap<String, Facet>();
        }
        return this.facetMap;
    }

    public NotificationChain eInverseAdd(InternalEObject internalEObject, int n, NotificationChain notificationChain) {
        switch (n) {
            case 16: {
                if (this.eInternalContainer() != null) {
                    notificationChain = this.eBasicRemoveFromContainer(notificationChain);
                }
                return this.basicSetNestingProject((Project)internalEObject, notificationChain);
            }
            case 17: {
                return ((InternalEList)this.getNestedProjects()).basicAdd((Object)internalEObject, notificationChain);
            }
            case 19: {
                return ((InternalEList)this.getFacets()).basicAdd((Object)internalEObject, notificationChain);
            }
        }
        return super.eInverseAdd(internalEObject, n, notificationChain);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject internalEObject, int n, NotificationChain notificationChain) {
        switch (n) {
            case 16: {
                return this.basicSetNestingProject(null, notificationChain);
            }
            case 17: {
                return ((InternalEList)this.getNestedProjects()).basicRemove((Object)internalEObject, notificationChain);
            }
            case 19: {
                return ((InternalEList)this.getFacets()).basicRemove((Object)internalEObject, notificationChain);
            }
        }
        return super.eInverseRemove(internalEObject, n, notificationChain);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain notificationChain) {
        switch (this.eContainerFeatureID()) {
            case 16: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 17, Project.class, notificationChain);
            }
        }
        return super.eBasicRemoveFromContainerFeature(notificationChain);
    }

    @Override
    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 8: {
                return this.getId();
            }
            case 9: {
                return this.getName();
            }
            case 10: {
                return this.getRealURI();
            }
            case 11: {
                return this.getVirtualURI();
            }
            case 12: {
                return this.getResources();
            }
            case 13: {
                return this.isReadonly();
            }
            case 14: {
                return this.isModified();
            }
            case 15: {
                return this.isManaged();
            }
            case 16: {
                if (bl) {
                    return this.getNestingProject();
                }
                return this.basicGetNestingProject();
            }
            case 17: {
                return this.getNestedProjects();
            }
            case 18: {
                return this.getDependingProjects();
            }
            case 19: {
                return this.getFacets();
            }
            case 20: {
                return this.getContents();
            }
        }
        return super.eGet(n, bl, bl2);
    }

    @Override
    public void eSet(int n, Object object) {
        switch (n) {
            case 8: {
                this.setId((String)object);
                return;
            }
            case 10: {
                this.setRealURI((URI)object);
                return;
            }
            case 14: {
                this.setModified((Boolean)object);
                return;
            }
            case 16: {
                this.setNestingProject((Project)object);
                return;
            }
            case 17: {
                this.getNestedProjects().clear();
                this.getNestedProjects().addAll((Collection)object);
                return;
            }
            case 18: {
                this.getDependingProjects().clear();
                this.getDependingProjects().addAll((Collection)object);
                return;
            }
            case 19: {
                this.getFacets().clear();
                this.getFacets().addAll((Collection)object);
                return;
            }
            case 20: {
                this.getContents().clear();
                this.getContents().addAll((Collection)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    @Override
    public void eUnset(int n) {
        switch (n) {
            case 8: {
                this.setId(ID_EDEFAULT);
                return;
            }
            case 10: {
                this.setRealURI(REAL_URI_EDEFAULT);
                return;
            }
            case 14: {
                this.setModified(false);
                return;
            }
            case 16: {
                this.setNestingProject(null);
                return;
            }
            case 17: {
                this.getNestedProjects().clear();
                return;
            }
            case 18: {
                this.getDependingProjects().clear();
                return;
            }
            case 19: {
                this.getFacets().clear();
                return;
            }
            case 20: {
                this.getContents().clear();
                return;
            }
        }
        super.eUnset(n);
    }

    @Override
    public boolean eIsSet(int n) {
        switch (n) {
            case 8: {
                return ID_EDEFAULT == null ? this.id != null : !ID_EDEFAULT.equals(this.id);
            }
            case 9: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 10: {
                return REAL_URI_EDEFAULT == null ? this.realURI != null : !REAL_URI_EDEFAULT.equals(this.realURI);
            }
            case 11: {
                return VIRTUAL_URI_EDEFAULT == null ? this.virtualURI != null : !VIRTUAL_URI_EDEFAULT.equals(this.virtualURI);
            }
            case 12: {
                return !this.getResources().isEmpty();
            }
            case 13: {
                return this.readonly;
            }
            case 14: {
                return this.modified;
            }
            case 15: {
                return this.managed;
            }
            case 16: {
                return this.basicGetNestingProject() != null;
            }
            case 17: {
                return this.nestedProjects != null && !this.nestedProjects.isEmpty();
            }
            case 18: {
                return this.dependingProjects != null && !this.dependingProjects.isEmpty();
            }
            case 19: {
                return this.facets != null && !this.facets.isEmpty();
            }
            case 20: {
                return this.contents != null && !this.contents.isEmpty();
            }
        }
        return super.eIsSet(n);
    }

    @Override
    public Object eInvoke(int n, EList<?> eList) throws InvocationTargetException {
        switch (n) {
            case 3: {
                try {
                    this.load((Map)eList.get(0));
                    return null;
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
            case 4: {
                try {
                    this.save((Map)eList.get(0));
                    return null;
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
            case 5: {
                try {
                    this.saveAs((URI)eList.get(0), (Map)eList.get(1));
                    return null;
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
            case 6: {
                this.close();
                return null;
            }
            case 7: {
                return this.createResourceURI((String)eList.get(0));
            }
            case 8: {
                return this.getFacet((String)eList.get(0));
            }
        }
        return super.eInvoke(n, eList);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" (id: ");
        stringBuffer.append(this.id);
        stringBuffer.append(", name: ");
        stringBuffer.append(this.name);
        stringBuffer.append(", realURI: ");
        stringBuffer.append(this.realURI);
        stringBuffer.append(", virtualURI: ");
        stringBuffer.append(this.virtualURI);
        stringBuffer.append(", readonly: ");
        stringBuffer.append(this.readonly);
        stringBuffer.append(", modified: ");
        stringBuffer.append(this.modified);
        stringBuffer.append(", managed: ");
        stringBuffer.append(this.managed);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    protected void validateOnLoad() throws IOException {
        BasicDiagnostic basicDiagnostic = new BasicDiagnostic();
        HashMap hashMap = new HashMap();
        for (EObject eObject : Iterables.concat(Collections.singleton(this), this.getFacets())) {
            EPackage ePackage = eObject.eClass().getEPackage();
            EValidator eValidator = EValidator.Registry.INSTANCE.getEValidator(ePackage);
            if (eValidator == null) continue;
            eValidator.validate(eObject, (DiagnosticChain)basicDiagnostic, hashMap);
        }
        if (basicDiagnostic.getSeverity() >= 4) {
            throw new IOException((Throwable)new DiagnosticException((Diagnostic)basicDiagnostic));
        }
    }

    protected void doSave(Resource resource, Map<?, ?> map) throws IOException {
        if (resource.getContents().isEmpty()) {
            URIConverter uRIConverter = resource.getResourceSet().getURIConverter();
            if (uRIConverter.exists(resource.getURI(), map)) {
                uRIConverter.delete(resource.getURI(), map);
            }
        } else {
            resource.save(map);
        }
    }

    protected boolean isSaveUnmodified(Map<?, ?> map) {
        if (map != null) {
            Object obj = map.get("SAVE_UNMODIFIED");
            return obj instanceof Boolean && (Boolean)obj != false;
        }
        return false;
    }

    private void a() {
        Resource.Internal internal = this.eDirectResource();
        if (internal == null) {
            throw new IllegalStateException("Not attached to resource");
        }
        if (internal.getResourceSet() == null) {
            throw new IllegalStateException("Not attached to ResourceSet");
        }
    }

    private ProjectManagerAdapter b() {
        return this.isManaged() ? ProjectManagerAdapter.getProjectManagerAdapter(this) : null;
    }

    private boolean a(ProjectManagerAdapter projectManagerAdapter) {
        return projectManagerAdapter != null && projectManagerAdapter.notificationRequired();
    }

    private void a(ProjectManagerAdapter projectManagerAdapter, Notification notification) {
        if (projectManagerAdapter != null) {
            projectManagerAdapter.fireNotifyChanged(notification);
        }
    }

    private final class ResourcesEList
    extends EDataTypeUniqueEList<Resource> {
        private static final long serialVersionUID = 1L;

        private ResourcesEList() {
            super(Resource.class, (InternalEObject)ProjectImpl.this, 12);
        }

        protected boolean isNotificationRequired() {
            ProjectManagerAdapter projectManagerAdapter = ProjectImpl.this.b();
            return ProjectImpl.this.a(projectManagerAdapter);
        }

        protected void dispatchNotification(Notification notification) {
            ProjectManagerAdapter projectManagerAdapter = ProjectImpl.this.b();
            ProjectImpl.this.a(projectManagerAdapter, notification);
        }

        protected boolean useEquals() {
            return true;
        }

        /* synthetic */ ResourcesEList(a a2) {
            this();
        }
    }
}

