/*
 * Decompiled with CFR 0.152.
 */
package net.astah.project;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Predicate;
import lombok.NonNull;
import net.astah.project.Facet;
import net.astah.project.Project;
import net.astah.project.ProjectElement;
import net.astah.project.ProjectManagerAdapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class Projects {
    public static <T extends EObject> Iterable<T> getFacetContents(Notifier notifier, Class<T> clazz) {
        Project project = ProjectManagerAdapter.getRootProject(notifier);
        if (project == null) {
            return null;
        }
        return Projects.getFacetContents(project, clazz);
    }

    public static Iterable<EObject> getFacetContents(Notifier notifier) {
        Project project = ProjectManagerAdapter.getRootProject(notifier);
        if (project == null) {
            return null;
        }
        return Projects.getFacetContents(project);
    }

    public static <T extends EObject> Iterable<T> getFacetContents(Project project, Class<T> clazz) {
        return Iterables.filter(Projects.getFacetContents(project), clazz);
    }

    public static Iterable<EObject> getFacetContents(Project project) {
        if (project == null) {
            return Collections.emptyList();
        }
        return Iterables.concat((Iterable)Iterables.transform(project.getFacets(), Facet::getContents));
    }

    public static String generateName(@NonNull Notifier notifier, @NonNull EClass eClass, String string) {
        if (notifier == null) {
            throw new NullPointerException("notifier");
        }
        if (eClass == null) {
            throw new NullPointerException("eClass");
        }
        Project project = ProjectManagerAdapter.getRootProject(notifier);
        if (project == null) {
            return null;
        }
        return project.generateLabel((ENamedElement)eClass, string, null);
    }

    public static String generateName(@NonNull EObject eObject, String string, @NonNull EAttribute eAttribute) {
        if (eObject == null) {
            throw new NullPointerException("eObject");
        }
        if (eAttribute == null) {
            throw new NullPointerException("attribute");
        }
        Project project = ProjectManagerAdapter.getContainingProject((Notifier)eObject, eObject);
        if (project == null) {
            return null;
        }
        return Projects.a((ProjectElement)project, eObject, string, eAttribute);
    }

    static String a(@NonNull EObject eObject, String string, @NonNull Predicate<String> predicate) {
        if (eObject == null) {
            throw new NullPointerException("eObject");
        }
        if (predicate == null) {
            throw new NullPointerException("predicate");
        }
        Project project = ProjectManagerAdapter.getContainingProject((Notifier)eObject, eObject);
        if (project == null) {
            return null;
        }
        return Projects.a((ProjectElement)project, eObject, string, predicate);
    }

    static String a(ProjectElement projectElement, EObject eObject, String string2, EAttribute eAttribute) {
        EObject eObject2 = eObject.eContainer();
        return Projects.a(projectElement, eObject, string2, eObject2 != null ? string -> {
            if (eObject2 != null) {
                EClass eClass = eAttribute.getEContainingClass();
                for (EObject eObject3 : eObject2.eContents()) {
                    if (eObject3 == eObject || !eClass.isInstance((Object)eObject3) || !Objects.equals(string, eObject3.eGet((EStructuralFeature)eAttribute))) continue;
                    return false;
                }
            }
            return true;
        } : null);
    }

    static String a(ProjectElement projectElement, EObject eObject, String string, Predicate<String> predicate) {
        EClass eClass = eObject.eClass();
        if (eClass == null) {
            return null;
        }
        return projectElement.generateLabel((ENamedElement)eClass, string, predicate);
    }
}

