/*
 * Decompiled with CFR 0.152.
 */
package net.astah.project;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.astah.emf.common.collect.ECompositeReferenceIterator;
import net.astah.emf.common.resource.ResourceSets;
import net.astah.emf.common.resource.Resources;
import net.astah.project.Facet;
import net.astah.project.Messages;
import net.astah.project.Project;
import net.astah.project.ProjectNotFoundException;
import net.astah.project.ProjectPackage;
import net.astah.project.impl.FacetImpl;
import net.astah.project.impl.ProjectImpl;
import net.astah.project.resource.AstahXMIResource;
import net.astah.project.resource.impl.ProjectResourceURIHandlerImpl;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectManagerAdapter
extends EContentAdapter
implements IChangeNotifier {
    private static final Logger a = LoggerFactory.getLogger(ProjectManagerAdapter.class);
    private final ProjectResourceURIHandlerImpl b;
    private final ChangeNotifier c = new ChangeNotifier();
    private final Map<String, ProjectImpl> d = new HashMap<String, ProjectImpl>();
    private final Map<String, Project> e = Collections.unmodifiableMap(this.d);
    private Set<ProjectImpl> f = Collections.emptySet();
    private ResourceSet g;
    private URI h;
    private Project i;

    public static ProjectManagerAdapter getProjectManagerAdapter(Notifier notifier) {
        if (notifier instanceof EObject) {
            return ProjectManagerAdapter.getProjectManagerAdapter((EObject)notifier);
        }
        if (notifier instanceof Resource) {
            return ProjectManagerAdapter.getProjectManagerAdapter((Resource)notifier);
        }
        if (notifier instanceof ResourceSet) {
            return ProjectManagerAdapter.getProjectManagerAdapter((ResourceSet)notifier);
        }
        return null;
    }

    public static ProjectManagerAdapter getProjectManagerAdapter(EObject eObject) {
        ResourceSet resourceSet;
        Resource resource = eObject.eResource();
        if (resource != null && (resourceSet = resource.getResourceSet()) != null) {
            return ProjectManagerAdapter.a((Notifier)resourceSet);
        }
        return ProjectManagerAdapter.a((Notifier)eObject);
    }

    public static ProjectManagerAdapter getProjectManagerAdapter(Resource resource) {
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceSet != null) {
            return ProjectManagerAdapter.a((Notifier)resourceSet);
        }
        return ProjectManagerAdapter.a((Notifier)resource);
    }

    public static ProjectManagerAdapter getProjectManagerAdapter(ResourceSet resourceSet) {
        return ProjectManagerAdapter.a((Notifier)resourceSet);
    }

    static ProjectManagerAdapter a(Notifier notifier) {
        EList eList = notifier.eAdapters();
        Adapter adapter = EcoreUtil.getAdapter((List)eList, ProjectManagerAdapter.class);
        if (adapter instanceof ProjectManagerAdapter) {
            return (ProjectManagerAdapter)adapter;
        }
        return null;
    }

    public ProjectManagerAdapter() {
        this(null);
    }

    public ProjectManagerAdapter(ResourceSet resourceSet) {
        this.b = new ProjectResourceURIHandlerImpl(this);
        if (resourceSet != null) {
            resourceSet.eAdapters().add((Object)this);
        }
    }

    public static Project open(Notifier notifier, URI uRI) throws IOException {
        return ProjectManagerAdapter.open(notifier, uRI, null);
    }

    public static Project open(Notifier notifier, URI uRI, Map<?, ?> map) throws IOException {
        ProjectManagerAdapter projectManagerAdapter = ProjectManagerAdapter.getProjectManagerAdapter(notifier);
        return projectManagerAdapter != null ? projectManagerAdapter.open(uRI, map) : null;
    }

    public static Project getRootProject(Notifier notifier) {
        ProjectManagerAdapter projectManagerAdapter = ProjectManagerAdapter.getProjectManagerAdapter(notifier);
        return projectManagerAdapter != null ? projectManagerAdapter.getRootProject() : null;
    }

    public static Project getProject(Notifier notifier, String string) {
        ProjectManagerAdapter projectManagerAdapter = ProjectManagerAdapter.getProjectManagerAdapter(notifier);
        return projectManagerAdapter != null ? projectManagerAdapter.getProject(string) : null;
    }

    public static Project getContainingProject(Notifier notifier, EObject eObject) {
        ProjectManagerAdapter projectManagerAdapter = ProjectManagerAdapter.getProjectManagerAdapter(notifier);
        return projectManagerAdapter != null ? projectManagerAdapter.getContainingProject(eObject) : null;
    }

    public static Project getContainingProject(Notifier notifier, Resource resource) {
        ProjectManagerAdapter projectManagerAdapter = ProjectManagerAdapter.getProjectManagerAdapter(notifier);
        return projectManagerAdapter != null ? projectManagerAdapter.getContainingProject(resource) : null;
    }

    public static URI resolveProjectURI(URI uRI) {
        if (uRI != null && AstahXMIResource.ARCHIVE_EXTENSION.equalsIgnoreCase(uRI.fileExtension())) {
            return uRI.appendSegment("project.axmp");
        }
        return uRI;
    }

    public Project open(URI uRI) throws IOException {
        return this.open(uRI, null);
    }

    public Project open(URI uRI, Map<?, ?> map) throws IOException {
        Preconditions.checkState((this.g != null ? 1 : 0) != 0, (Object)"resourceSet is not attached");
        SubMonitor subMonitor = Resources.getSubMonitor(map, (String)"MONITOR");
        subMonitor.subTask(Messages.ProjectManagerAdapter_loadingDescriptor);
        URI uRI2 = ProjectManagerAdapter.resolveProjectURI(uRI);
        Resource resource = ResourceSets.createResourceOrThrow((ResourceSet)this.g, (URI)uRI2, (String)"");
        a.debug("Loading project[uri={}]", (Object)uRI);
        resource.load(map);
        for (EObject eObject : resource.getContents()) {
            if (!(eObject instanceof Project)) continue;
            Project project = (Project)eObject;
            a.debug("Loaded project model[id={}]", (Object)project.getId());
            return project;
        }
        throw new ProjectNotFoundException(NLS.bind((String)"No project descriptor exist in resource ''{0}''", (Object)uRI), uRI);
    }

    public Project getRootProject() {
        return this.getRootProject(true);
    }

    public void setRootProject(Project project) {
        if (project != null) {
            if (ProjectManagerAdapter.getProjectManagerAdapter(project) != this) {
                throw new IllegalArgumentException("rootProject");
            }
            this.h = EcoreUtil.getURI((EObject)project);
            this.f = new HashSet<ProjectImpl>(this.d.values());
        } else {
            this.h = null;
        }
        this.clearCache();
    }

    public Project getProject(String string) {
        return this.d.get(string);
    }

    public Map<String, Project> getProjects() {
        return this.e;
    }

    public Project getContainingProject(EObject eObject) {
        Resource resource = eObject.eResource();
        return resource != null ? this.getContainingProject(resource) : null;
    }

    public Project getContainingProject(Resource resource) {
        return this.b.getProject(resource.getURI());
    }

    public Project getContainedProject(Resource resource) {
        for (ProjectImpl projectImpl : this.d.values()) {
            if (projectImpl.eResource() != resource) continue;
            return projectImpl;
        }
        return null;
    }

    public boolean isAdapterForType(Object object) {
        return object == ProjectManagerAdapter.class;
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        Object object = notification.getNotifier();
        if (object instanceof ProjectImpl) {
            this.projectChanged(notification, (ProjectImpl)object);
        } else if (object instanceof FacetImpl) {
            this.facetChanged(notification, (FacetImpl)object);
        } else if (object instanceof Resource) {
            this.resourceChanged(notification, (Resource)object);
        }
    }

    public boolean notificationRequired() {
        return !this.c.isEmpty();
    }

    public void fireNotifyChanged(Notification notification) {
        this.c.fireNotifyChanged(notification);
    }

    public void addListener(INotifyChangedListener iNotifyChangedListener) {
        this.c.addListener(iNotifyChangedListener);
    }

    public void removeListener(INotifyChangedListener iNotifyChangedListener) {
        this.c.removeListener(iNotifyChangedListener);
    }

    protected void setTarget(EObject eObject) {
        this.basicSetTarget((Notifier)eObject);
    }

    protected void unsetTarget(EObject eObject) {
        this.basicUnsetTarget((Notifier)eObject);
    }

    protected void setTarget(ResourceSet resourceSet) {
        super.setTarget(resourceSet);
        if (this.g == null) {
            this.a(resourceSet);
        }
    }

    protected void unsetTarget(ResourceSet resourceSet) {
        if (this.g == resourceSet) {
            this.a((ResourceSet)null);
        }
        super.unsetTarget(resourceSet);
    }

    protected void addAdapter(Notifier notifier) {
        if (notifier instanceof ProjectImpl) {
            super.addAdapter(notifier);
            this.addProject((ProjectImpl)notifier);
        } else if (notifier instanceof FacetImpl) {
            super.addAdapter(notifier);
        } else if (notifier instanceof Resource) {
            super.addAdapter(notifier);
            this.addResource((Resource)notifier);
        } else if (notifier instanceof ResourceSet) {
            super.addAdapter(notifier);
        }
    }

    protected void removeAdapter(Notifier notifier) {
        if (notifier instanceof ProjectImpl) {
            this.removeProject((ProjectImpl)notifier);
            super.removeAdapter(notifier);
        } else if (notifier instanceof FacetImpl) {
            super.removeAdapter(notifier);
        } else if (notifier instanceof Resource) {
            this.removeResource((Resource)notifier);
            super.removeAdapter(notifier);
        } else if (notifier instanceof ResourceSet) {
            super.removeAdapter(notifier);
        }
    }

    protected void addProject(ProjectImpl projectImpl) {
        String string = projectImpl.getId();
        if (string != null) {
            this.a(projectImpl, string);
            if (projectImpl.eIsSet(20)) {
                for (EObject eObject : projectImpl.getContents()) {
                    this.a(eObject);
                }
            }
        }
    }

    protected void removeProject(ProjectImpl projectImpl) {
        String string = projectImpl.getId();
        if (string != null) {
            this.b(projectImpl, string);
        }
    }

    protected void addFacet(ProjectImpl projectImpl, FacetImpl facetImpl) {
        String string = facetImpl.getSymbolicName();
        if (string != null) {
            projectImpl.getFacetMap().put(string, facetImpl);
        }
        if (facetImpl.eIsSet(11)) {
            for (EObject eObject : facetImpl.getContents()) {
                this.a(eObject);
            }
        }
    }

    protected void removeFacet(ProjectImpl projectImpl, FacetImpl facetImpl) {
        String string = facetImpl.getSymbolicName();
        if (string != null) {
            projectImpl.getFacetMap().remove(string, facetImpl);
        }
    }

    protected void addResource(Resource resource) {
        this.a(resource);
    }

    protected void removeResource(Resource resource) {
        this.b(resource);
    }

    protected void projectChanged(Notification notification, ProjectImpl projectImpl) {
        int n = notification.getFeatureID(Project.class);
        if (notification.isTouch()) {
            if (notification.getEventType() == 9 && n == 17) {
                this.updateWritableProjects(false);
            }
            return;
        }
        block0 : switch (n) {
            case 8: {
                switch (notification.getEventType()) {
                    case 1: 
                    case 2: {
                        String string;
                        String string2 = (String)notification.getOldValue();
                        if (string2 != null) {
                            this.b(projectImpl, string2);
                        }
                        if ((string = (String)notification.getNewValue()) == null) break block0;
                        this.a(projectImpl, string);
                        break block0;
                    }
                }
                break;
            }
            case 17: {
                switch (notification.getEventType()) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        this.updateWritableProjects(false);
                        break block0;
                    }
                }
                break;
            }
            case 19: {
                switch (notification.getEventType()) {
                    case 3: {
                        this.addFacet(projectImpl, (FacetImpl)notification.getNewValue());
                        break;
                    }
                    case 4: {
                        this.removeFacet(projectImpl, (FacetImpl)notification.getOldValue());
                        break;
                    }
                    case 5: {
                        for (Object e : (List)notification.getNewValue()) {
                            this.addFacet(projectImpl, (FacetImpl)e);
                        }
                        break block0;
                    }
                    case 6: {
                        for (Object e : (List)notification.getOldValue()) {
                            this.removeFacet(projectImpl, (FacetImpl)e);
                        }
                        break block0;
                    }
                }
                break;
            }
            case 20: {
                switch (notification.getEventType()) {
                    case 3: {
                        this.a((EObject)notification.getNewValue());
                        break;
                    }
                    case 5: {
                        for (Object e : (List)notification.getNewValue()) {
                            this.a((EObject)e);
                        }
                        break block0;
                    }
                }
                break;
            }
        }
    }

    protected void facetChanged(Notification notification, FacetImpl facetImpl) {
        if (notification.isTouch()) {
            return;
        }
        block0 : switch (notification.getFeatureID(Project.class)) {
            case 10: {
                switch (notification.getEventType()) {
                    case 1: 
                    case 2: {
                        Object object;
                        ProjectImpl projectImpl = (ProjectImpl)facetImpl.getProject();
                        if (projectImpl == null) break;
                        Map<String, Facet> map = projectImpl.getFacetMap();
                        Object object2 = notification.getOldValue();
                        if (object2 instanceof String) {
                            map.remove(object2);
                        }
                        if (!((object = notification.getNewValue()) instanceof String)) break block0;
                        map.put((String)object, facetImpl);
                        break;
                    }
                }
                break;
            }
            case 11: {
                switch (notification.getEventType()) {
                    case 3: {
                        this.a((EObject)notification.getNewValue());
                        break;
                    }
                    case 5: {
                        for (Object e : (List)notification.getNewValue()) {
                            this.a((EObject)e);
                        }
                        break;
                    }
                }
                break;
            }
        }
    }

    protected void resourceChanged(Notification notification, Resource resource) {
        if (notification.isTouch()) {
            return;
        }
        switch (notification.getFeatureID(Resource.class)) {
            case 1: {
                for (ProjectImpl projectImpl : this.d.values()) {
                    if (projectImpl.eDirectResource() != resource) continue;
                    projectImpl.internalSetRealURI(this.resolveProjectRealURI(projectImpl));
                    projectImpl.internalSetName(this.resolveProjectName(projectImpl));
                }
                break;
            }
            case 3: {
                ProjectImpl projectImpl = (ProjectImpl)this.getContainingProject(resource);
                if (projectImpl != null) {
                    if (Resources.isLoading((Resource)resource) || !resource.isLoaded()) break;
                    this.updateProjectModified(projectImpl);
                    Resource.Internal internal = projectImpl.eDirectResource();
                    if (internal == null || !notification.getNewBooleanValue()) break;
                    internal.setModified(true);
                    break;
                }
                for (ProjectImpl projectImpl2 : this.d.values()) {
                    if (projectImpl2.eDirectResource() != resource) continue;
                    this.updateProjectModified(projectImpl2);
                }
                break;
            }
        }
    }

    protected Project getRootProject(boolean bl) {
        if (this.i == null) {
            this.i = this.resolveRootProject(bl);
        }
        return this.i;
    }

    protected void updateProjectModified(ProjectImpl projectImpl) {
        boolean bl = this.resolveProjectModified(projectImpl);
        this.validateProjectModified(projectImpl, bl);
        projectImpl.internalSetModified(bl);
    }

    protected void validateProjectModified(Project project, boolean bl) {
        if (bl && project.isReadonly()) {
            throw new IllegalStateException("Readonly project");
        }
    }

    protected Project resolveRootProject(boolean bl) {
        Project project;
        EObject eObject;
        if (this.g != null && this.h != null && (eObject = this.g.getEObject(this.h, bl)) instanceof Project && (project = (Project)eObject).getId() != null) {
            return project;
        }
        return null;
    }

    protected Set<ProjectImpl> resolveWritableProjects(boolean bl) {
        Project project = this.getRootProject(bl);
        if (project == null) {
            return new HashSet<ProjectImpl>(this.d.values());
        }
        UnmodifiableIterator unmodifiableIterator = Iterators.filter((Iterator)new ECompositeReferenceIterator((EObject)((ProjectImpl)project), ProjectPackage.Literals.PROJECT__NESTED_PROJECTS, true, bl), Project::isManaged);
        return unmodifiableIterator.hasNext() ? Sets.newHashSet((Iterator)unmodifiableIterator) : Collections.emptySet();
    }

    protected void updateWritableProjects(boolean bl) {
        Map<Resource, Boolean> map = this.a();
        Set<ProjectImpl> set = this.resolveWritableProjects(bl);
        Set<ProjectImpl> set2 = this.f;
        this.f = set;
        for (ProjectImpl projectImpl : set2) {
            if (!projectImpl.isManaged() || set.contains(projectImpl)) continue;
            projectImpl.internalSetReadonly(true);
            if (map == null) continue;
            for (Resource resource : projectImpl.getResources()) {
                map.put(resource, true);
            }
        }
        for (ProjectImpl projectImpl : set) {
            if (!projectImpl.isManaged() || set2.contains(projectImpl)) continue;
            projectImpl.internalSetReadonly(false);
            if (map == null) continue;
            for (Resource resource : projectImpl.getResources()) {
                map.remove(resource);
            }
        }
    }

    protected String resolveProjectName(ProjectImpl projectImpl) {
        URI uRI = projectImpl.getRealURI();
        if (uRI != null) {
            String string = URI.decode((String)uRI.lastSegment());
            String string2 = URI.decode((String)uRI.fileExtension());
            if (string2 != null) {
                string = string.substring(0, string.length() - string2.length() - 1);
            }
            return string;
        }
        return null;
    }

    protected URI resolveProjectRealURI(ProjectImpl projectImpl) {
        URI uRI;
        Resource.Internal internal = projectImpl.eDirectResource();
        if (internal != null && (uRI = internal.getURI()) != null) {
            return uRI.trimFragment().trimSegments(1);
        }
        return null;
    }

    protected URI resolveProjectVirtualURI(ProjectImpl projectImpl) {
        String[] stringArray = new String[]{projectImpl.getId()};
        return URI.createHierarchicalURI((String)"project", null, null, (String[])stringArray, null, null);
    }

    protected boolean resolveProjectReadonly(ProjectImpl projectImpl) {
        return this.h != null && !this.f.contains(projectImpl);
    }

    protected boolean resolveProjectModified(ProjectImpl projectImpl) {
        Resource.Internal internal = projectImpl.eDirectResource();
        if (internal != null && internal.isModified()) {
            return true;
        }
        return projectImpl.getMutableResources().stream().anyMatch(Resource::isModified);
    }

    protected List<Resource> resolveProjectResources(ProjectImpl projectImpl) {
        return this.g != null ? this.g.getResources().stream().filter(resource -> this.getContainingProject((Resource)resource) == projectImpl).collect(Collectors.toList()) : Collections.emptyList();
    }

    protected void clearCache() {
        this.updateWritableProjects(false);
        this.i = null;
    }

    void a(ProjectImpl projectImpl, String string) {
        Objects.requireNonNull(string, "id");
        if (this.d.putIfAbsent(string, projectImpl) == null) {
            Object object;
            String string2;
            Resource.Internal internal = projectImpl.eDirectResource();
            if (internal instanceof XMLResource && !string.equals(string2 = (object = (XMLResource)internal).getID((EObject)projectImpl))) {
                object.setID((EObject)projectImpl, string);
                if (internal instanceof XMLResourceImpl) {
                    ((XMLResourceImpl)internal).getIDToEObjectMap().put(string2, projectImpl);
                }
            }
            a.debug("Registering Project[uri={}]", (Object)EcoreUtil.getURI((EObject)projectImpl));
            object = this.resolveProjectResources(projectImpl);
            if (!object.isEmpty()) {
                projectImpl.getMutableResources().addAll((Collection)object);
            }
            projectImpl.internalSetRealURI(this.resolveProjectRealURI(projectImpl));
            projectImpl.internalSetVirtualURI(this.resolveProjectVirtualURI(projectImpl));
            projectImpl.internalSetName(this.resolveProjectName(projectImpl));
            projectImpl.internalSetReadonly(this.resolveProjectReadonly(projectImpl));
            projectImpl.internalSetModified(this.resolveProjectModified(projectImpl));
            projectImpl.internalSetManaged(true);
            this.clearCache();
        } else {
            a.warn("Registering Project[id={}] has already exists", (Object)string);
        }
    }

    void b(ProjectImpl projectImpl, String string) {
        if (this.d.remove(string, projectImpl)) {
            a.debug("Unregistering Project[id={}]", (Object)string);
            projectImpl.internalSetManaged(false);
            projectImpl.internalSetModified(false);
            projectImpl.internalSetReadonly(false);
            projectImpl.internalSetName(null);
            projectImpl.internalSetVirtualURI(null);
            projectImpl.internalSetRealURI(null);
            projectImpl.unsetMutableResources();
            this.clearCache();
        } else {
            a.warn("Unregistering Project[id={}] is not matched", (Object)string);
        }
    }

    void a(Resource resource) {
        ProjectImpl projectImpl = (ProjectImpl)this.getContainingProject(resource);
        if (projectImpl != null) {
            projectImpl.getMutableResources().add((Object)resource);
        }
    }

    void b(Resource resource) {
        ProjectImpl projectImpl = (ProjectImpl)this.getContainingProject(resource);
        if (projectImpl != null) {
            projectImpl.getMutableResources().remove((Object)resource);
        }
    }

    void a(EObject eObject) {
        URI uRI;
        if (this.g != null && (uRI = EcoreUtil.getURI((EObject)eObject)) != null) {
            URI uRI2 = uRI.trimFragment();
            ResourceSets.getOrCreateResource((ResourceSet)this.g, (URI)uRI2, (String)"");
        }
    }

    void a(ResourceSet resourceSet) {
        if (this.g != null && this.b != null) {
            this.g.getURIConverter().getURIHandlers().remove((Object)this.b);
        }
        if (resourceSet != null) {
            resourceSet.getURIConverter().getURIHandlers().add(0, (Object)this.b);
        }
        this.g = resourceSet;
        this.h = null;
        this.clearCache();
    }

    Map<Resource, Boolean> a() {
        EditingDomain editingDomain;
        if (this.g != null && (editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((Object)this.g)) instanceof AdapterFactoryEditingDomain) {
            return ((AdapterFactoryEditingDomain)editingDomain).getResourceToReadOnlyMap();
        }
        return null;
    }

    static class a
    implements INotifyChangedListener {
        protected final AdapterFactoryEditingDomain a;

        public a(AdapterFactoryEditingDomain adapterFactoryEditingDomain) {
            this.a = adapterFactoryEditingDomain;
        }

        public void notifyChanged(Notification notification) {
            Map map = this.a.getResourceToReadOnlyMap();
            if (map != null && !notification.isTouch() && notification.getFeature() == ProjectPackage.Literals.PROJECT__READONLY) {
                Project project = (Project)notification.getNotifier();
                for (Resource resource : project.getResources()) {
                    if (notification.getNewBooleanValue()) {
                        map.put(resource, true);
                        continue;
                    }
                    map.remove(resource);
                }
            }
        }
    }
}

