/*
 * Decompiled with CFR 0.152.
 */
package net.astah.project;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.function.Predicate;
import lombok.NonNull;
import net.astah.common.collect.Streams;
import net.astah.emf.common.ecore.EObjects;
import net.astah.project.Facet;
import net.astah.project.Project;
import net.astah.project.ProjectElement;
import net.astah.project.ProjectManagerAdapter;
import net.astah.project.Projects;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class Facets {
    public static Iterable<Facet> getFacets(EObject eObject) {
        EList<Facet> eList;
        Resource resource = eObject.eResource();
        Project project = ProjectManagerAdapter.getContainingProject((Notifier)resource, resource);
        if (project != null && !(eList = project.getFacets()).isEmpty()) {
            return Iterables.filter(eList, facet -> {
                EList<EObject> eList = facet.getContents();
                EObject eObject2 = EObjects.getAncestor(arg_0 -> eList.contains(arg_0), (EObject)eObject);
                return eObject2 != null && eObject2.eResource() == resource;
            });
        }
        return Collections.emptySet();
    }

    public static EList<EObject> getContents(Project project, String string) {
        Facet facet = Facets.a(project, string);
        return facet != null ? facet.getContents() : ECollections.emptyEList();
    }

    public static <T extends EObject> T getFirstContent(Project project, String string, Class<T> clazz, T t) {
        EList<EObject> eList = Facets.getContents(project, string);
        if (eList.isEmpty()) {
            return t;
        }
        return (T)((EObject)Streams.stream(eList, clazz).findFirst().orElse(t));
    }

    public static String generateName(@NonNull Notifier notifier, @NonNull String string, @NonNull EClass eClass, String string2) {
        if (notifier == null) {
            throw new NullPointerException("notifier");
        }
        if (string == null) {
            throw new NullPointerException("symbolicName");
        }
        if (eClass == null) {
            throw new NullPointerException("eClass");
        }
        Project project = ProjectManagerAdapter.getRootProject(notifier);
        Facet facet = Facets.a(project, string);
        if (facet == null) {
            return null;
        }
        return facet.generateLabel((ENamedElement)eClass, string2, null);
    }

    public static String generateName(@NonNull EObject eObject, @NonNull String string, String string2, @NonNull EAttribute eAttribute) {
        if (eObject == null) {
            throw new NullPointerException("eObject");
        }
        if (string == null) {
            throw new NullPointerException("symbolicName");
        }
        if (eAttribute == null) {
            throw new NullPointerException("attribute");
        }
        Project project = ProjectManagerAdapter.getContainingProject((Notifier)eObject, eObject);
        Facet facet = Facets.a(project, string);
        if (facet == null) {
            return null;
        }
        return Projects.a((ProjectElement)facet, eObject, string2, eAttribute);
    }

    static String a(@NonNull EObject eObject, @NonNull String string, String string2, @NonNull Predicate<String> predicate) {
        if (eObject == null) {
            throw new NullPointerException("eObject");
        }
        if (string == null) {
            throw new NullPointerException("symbolicName");
        }
        if (predicate == null) {
            throw new NullPointerException("predicate");
        }
        Project project = ProjectManagerAdapter.getContainingProject((Notifier)eObject, eObject);
        Facet facet = Facets.a(project, string);
        if (facet == null) {
            return null;
        }
        return Projects.a((ProjectElement)facet, eObject, string2, predicate);
    }

    static Facet a(Project project, String string) {
        return project != null ? project.getFacet(string) : null;
    }
}

