/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.notation.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.DCFactory;
import net.astah.dd.dc.Dimension;
import net.astah.dd.dc.Point;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.dd.di.util.DiagramElements;
import net.astah.emf.common.notify.EFeaturePath;
import net.astah.notation.NotationPackage;
import net.astah.notation.Shape;
import net.astah.notation.edit.layout.DiagramElementOperations;
import net.astah.notation.provider.GeometryProviderHelper;
import net.astah.notation.provider.MoveLocationHelper;
import net.astah.stpa.stamp.Component;
import net.astah.stpa.stamp.ControlAction;
import net.astah.stpa.stamp.Element;
import net.astah.stpa.stamp.NamedElement;
import net.astah.stpa.stamp.Note;
import net.astah.stpa.stamp.ProcessValue;
import net.astah.stpa.stamp.ProcessVariable;
import net.astah.stpa.stamp.STAMPPackage;
import net.astah.stpa.stamp.Signal;
import net.astah.stpa.stamp.UCAAnalysisResult;
import net.astah.stpa.stamp.notation.STAMPComponentShape;
import net.astah.stpa.stamp.notation.STAMPControlStructureDiagram;
import net.astah.stpa.stamp.notation.STAMPEdge;
import net.astah.stpa.stamp.notation.STAMPLabel;
import net.astah.stpa.stamp.notation.STAMPNotationPackage;
import net.astah.stpa.stamp.notation.STAMPShape;
import net.astah.stpa.stamp.notation.UCATable;
import net.astah.stpa.stamp.notation.provider.STAMPShapeItemProvider;
import net.astah.stpa.stamp.notation.util.STAMPDiagramElements;
import net.astah.stpa.stamp.util.STAMPSwitch;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;

public class STAMPLabelItemProvider
extends STAMPShapeItemProvider {
    public STAMPLabelItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addTextPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addTextPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_STAMPLabel_text_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_STAMPLabel_text_feature", "_UI_STAMPLabel_type"), (EStructuralFeature)STAMPNotationPackage.Literals.STAMP_LABEL__TEXT, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    @Override
    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/STAMPLabel"));
    }

    @Override
    protected boolean shouldComposeCreationImage() {
        return true;
    }

    @Override
    public String getText(Object object) {
        String label = ((STAMPLabel)object).getText();
        return label == null || label.length() == 0 ? this.getString("_UI_STAMPLabel_type") : this.getString("_UI_STAMPLabel_type") + " " + label;
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(STAMPLabel.class)) {
            case 19: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public String getModifyingText(Object object) {
        final STAMPLabel label = (STAMPLabel)object;
        Iterator iterator = label.getSTAMPModelElements().iterator();
        if (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            return (String)new STAMPSwitch<String>(){

                public String caseComponent(Component component) {
                    return label.getText();
                }

                public String caseNote(Note object) {
                    return label.getText();
                }
            }.doSwitch((EObject)element);
        }
        return label.getText();
    }

    public Command parseModifyingText(final EditingDomain domain, Object owner, final String text) {
        STAMPLabel label = (STAMPLabel)owner;
        Iterator iterator = label.getSTAMPModelElements().iterator();
        if (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            return (Command)new STAMPSwitch<Command>(){

                public Command caseNamedElement(NamedElement object) {
                    return SetCommand.create((EditingDomain)domain, (Object)object, (Object)STAMPPackage.Literals.NAMED_ELEMENT__NAME, (Object)STAMPLabelItemProvider.this.replaceLineFeedCode(text));
                }

                public Command caseNote(Note object) {
                    return SetCommand.create((EditingDomain)domain, (Object)object, (Object)STAMPPackage.Literals.NOTE__BODY, (Object)text);
                }
            }.doSwitch((EObject)element);
        }
        return SetCommand.create((EditingDomain)domain, (Object)owner, (Object)STAMPNotationPackage.Literals.STAMP_LABEL__TEXT, (Object)text);
    }

    @Override
    public Point getLocationOn(Object object, LayoutCalculator layoutCalculator) {
        Shape label = (Shape)object;
        return GeometryProviderHelper.getLocationOn((Shape)label, null, (LayoutCalculator)layoutCalculator);
    }

    @Override
    public Dimension getBoundsSize(Object object, LayoutCalculator layoutCalculator) {
        Object parent = this.getOriginatingElement(object, layoutCalculator);
        return layoutCalculator.getElementSize(parent, object);
    }

    @Override
    protected boolean adjustCopySelection(EditingDomain domain, Object owner, Set<Object> selection) {
        STAMPLabel label = (STAMPLabel)owner;
        boolean changed = selection.remove(label);
        return super.adjustCopySelection(domain, owner, selection) || changed;
    }

    protected boolean adjustMoveSelection(EditingDomain domain, Object owner, Set<Object> selection) {
        DiagramElement owningElement;
        if (owner instanceof STAMPLabel && (owningElement = ((STAMPLabel)owner).getOwningElement()) instanceof STAMPShape) {
            selection.remove(owner);
            selection.add(owningElement);
            return true;
        }
        return false;
    }

    @Override
    public void collectDependents(EditingDomain domain, Object object, Collection<Object> collection) {
        ControlAction controlAction;
        STAMPLabel label = (STAMPLabel)object;
        DiagramElement owner = label.getOwningElement();
        if (Objects.equals(owner.getModelElements(), label.getModelElements())) {
            collection.add(owner);
        }
        if ((controlAction = this.getControlAction(label)) != null) {
            List<UCAAnalysisResult> referedUCAAnalysisResults = this.getReferedUCAAnalysisResults(label);
            referedUCAAnalysisResults.removeAll(this.getNotDeleteResults(collection, controlAction, label));
            collection.addAll(referedUCAAnalysisResults);
        }
        super.collectDependents(domain, object, collection);
    }

    private String replaceLineFeedCode(String originString) {
        String replaceString1 = originString.replaceAll("\r\n", " ");
        String replaceString2 = replaceString1.replaceAll("\r", " ");
        String result = replaceString2.replaceAll("\n", " ");
        return result;
    }

    private List<UCAAnalysisResult> getReferedUCAAnalysisResults(STAMPLabel label) {
        ArrayList<UCAAnalysisResult> referedUCAAnalysisResults = new ArrayList<UCAAnalysisResult>();
        List<UCATable> referedUCATables = this.getReferedUCATables(label);
        for (UCATable ucaTable : referedUCATables) {
            for (UCAAnalysisResult result : ucaTable.getResults()) {
                if (result.getControlAction() != this.getControlAction(label)) continue;
                referedUCAAnalysisResults.add(result);
            }
        }
        return referedUCAAnalysisResults;
    }

    private List<UCAAnalysisResult> getNotDeleteResults(Collection<Object> deletes, ControlAction controlAction, STAMPLabel current) {
        List labels = STAMPDiagramElements.getDiagramElements((EObject)controlAction, null, STAMPLabel.class);
        labels.remove(current);
        ArrayList<UCAAnalysisResult> notDeleteUCAAnalysisResults = new ArrayList<UCAAnalysisResult>();
        for (STAMPLabel stampLabel : labels) {
            if (deletes.contains(stampLabel)) continue;
            notDeleteUCAAnalysisResults.addAll(this.getReferedUCAAnalysisResults(stampLabel));
        }
        return notDeleteUCAAnalysisResults;
    }

    private ControlAction getControlAction(STAMPLabel label) {
        for (Element element : label.getSTAMPModelElements()) {
            if (!(element instanceof ControlAction)) continue;
            return (ControlAction)element;
        }
        return null;
    }

    private List<UCATable> getReferedUCATables(STAMPLabel label) {
        ArrayList<UCATable> ucaTables = new ArrayList<UCATable>();
        Diagram diagram = DiagramElementOperations.getDiagram((DiagramElement)label);
        if (diagram instanceof STAMPControlStructureDiagram) {
            EFeaturePath path = EFeaturePath.build((EStructuralFeature)STAMPNotationPackage.Literals.UCA_TABLE__CONTROL_STRUCTURE_DIAGRAM);
            for (EObject eObject : path.getInverseReferences((EObject)diagram)) {
                if (!(eObject instanceof UCATable)) continue;
                ucaTables.add((UCATable)eObject);
            }
        }
        return ucaTables;
    }

    public Collection<?> getIntentionDomains(Object object) {
        if (DiagramElements.isModelElementPresent((DiagramElement)((STAMPLabel)object), ControlAction.class)) {
            return Collections.emptySet();
        }
        return super.getIntentionDomains(object);
    }

    protected Command createSetBoundsCommand(EditingDomain domain, Object context, EObject owner, Object feature, Object value) {
        STAMPLabel label = (STAMPLabel)owner;
        if (!(label.getOwningElement() instanceof STAMPEdge)) {
            return UnexecutableCommand.INSTANCE;
        }
        return super.createSetBoundsCommand(domain, context, owner, feature, value);
    }

    protected Command createLocationMoveLocationCommand(EditingDomain domain, Object context, EObject owner, Object value) {
        if (((DiagramElement)owner).getOwningElement() instanceof STAMPComponentShape) {
            return IdentityCommand.INSTANCE;
        }
        return MoveLocationHelper.INSTANCE.applyFeature(domain, context, owner, NotationPackage.Literals.SHAPE__LOCATION, value);
    }

    protected Command createDefaultSetBoundsCommand(EditingDomain domain, Object context, EObject owner, Object value) {
        STAMPLabel label = (STAMPLabel)owner;
        if (value instanceof Bounds && label.getOwningElement() instanceof STAMPEdge) {
            Bounds bounds = (Bounds)value;
            CompoundCommand command = new CompoundCommand();
            Point locationPoint = DCFactory.eINSTANCE.createPoint(bounds.getX(), bounds.getY());
            command.append(this.createSetLocationCommand(domain, context, owner, null, locationPoint));
            command.append(this.createSetSizeCommand(domain, context, owner, null, DCFactory.eINSTANCE.createDimension(bounds.getWidth(), bounds.getHeight())));
            return command;
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected boolean adjustDepthSelection(EditingDomain domain, Object owner, Set<Object> selection) {
        DiagramElement owningElement;
        STAMPLabel label = (STAMPLabel)owner;
        boolean changed = false;
        if (selection.contains(label)) {
            changed |= selection.remove(label);
        }
        if (!selection.contains(owningElement = label.getOwningElement()) && owningElement instanceof Shape) {
            changed |= selection.add(owningElement);
        }
        return super.adjustDepthSelection(domain, owner, selection) || changed;
    }

    @Override
    protected boolean adjustDeleteDiagramElementSelection(EditingDomain domain, Object owner, Set<Object> selection) {
        STAMPLabel label = (STAMPLabel)owner;
        boolean changed = super.adjustDeleteDiagramElementSelection(domain, owner, selection);
        DiagramElement owningElement = label.getOwningElement();
        if (owningElement instanceof STAMPComponentShape && selection.contains(label)) {
            return changed |= selection.add(owningElement);
        }
        for (EObject modelElement : label.getModelElements()) {
            if (!(modelElement instanceof Signal) && !(modelElement instanceof ProcessVariable) && !(modelElement instanceof ProcessValue)) continue;
            if (selection.contains(label)) {
                changed |= selection.add(modelElement);
                break;
            }
            changed |= selection.remove(modelElement);
            break;
        }
        return changed;
    }
}

