/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.notation.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.Point;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.Edge;
import net.astah.dd.di.edit.provider.Geometries;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.jmodel.RightAngleUtil;
import net.astah.notation.RightAngleLine;
import net.astah.notation.provider.GeometryProviderHelper;
import org.eclipse.emf.common.util.EList;

public class STAMPGeometryProviderHelper
extends GeometryProviderHelper {
    public static List<Point> getControlPoints(net.astah.notation.Edge edge, Point origin, LayoutCalculator layoutCalculator) {
        DiagramElement target;
        List<Point> controlPoints;
        if (STAMPGeometryProviderHelper.canStraightLine(edge, origin, layoutCalculator) && !(controlPoints = STAMPGeometryProviderHelper.getAlignedAnchorPoints(target = layoutCalculator.getTarget((Edge)edge), edge, layoutCalculator, origin)).isEmpty()) {
            return controlPoints;
        }
        return GeometryProviderHelper.getControlPoints((net.astah.notation.Edge)edge, (Point)origin, (LayoutCalculator)layoutCalculator);
    }

    private static boolean canStraightLine(net.astah.notation.Edge edge, Point origin, LayoutCalculator layoutCalculator) {
        Rectangle2d targetRect;
        DiagramElement target;
        if (!(STAMPGeometryProviderHelper.getLine((net.astah.notation.Edge)edge, (LayoutCalculator)layoutCalculator) instanceof RightAngleLine)) {
            return false;
        }
        DiagramElement source = layoutCalculator.getSource((Edge)edge);
        if (source == (target = layoutCalculator.getTarget((Edge)edge))) {
            return false;
        }
        EList lastWayPoints = edge.getWaypoints();
        List rightAngleControlPoints = GeometryProviderHelper.getControlPoints((net.astah.notation.Edge)edge, (Point)origin, (LayoutCalculator)layoutCalculator);
        Rectangle2d sourceRect = Geometries.toRectangle2d((Bounds)layoutCalculator.getSourceEndBounds((Edge)edge, origin));
        if (RightAngleUtil.isOverlapXCoordinate((Rectangle2d)sourceRect, (Rectangle2d)(targetRect = Geometries.toRectangle2d((Bounds)layoutCalculator.getTargetEndBounds((Edge)edge, origin))))) {
            if (rightAngleControlPoints.size() <= 4 && RightAngleUtil.isOverlapXCoordinate((Rectangle2d)sourceRect, (Pnt2d)Geometries.toPnt2d((Point)((Point)rightAngleControlPoints.get(1)))) && RightAngleUtil.isOverlapXCoordinate((Rectangle2d)targetRect, (Pnt2d)Geometries.toPnt2d((Point)((Point)rightAngleControlPoints.get(rightAngleControlPoints.size() - 2)))) && RightAngleUtil.isOverlapXCoordinate((Rectangle2d)sourceRect, (Pnt2d)Geometries.toPnt2d((Point)((Point)rightAngleControlPoints.get(rightAngleControlPoints.size() - 1))))) {
                if (lastWayPoints.size() <= 2) {
                    return true;
                }
                if (rightAngleControlPoints.size() == 4 && Math.abs(((Point)rightAngleControlPoints.get(1)).getX() - ((Point)rightAngleControlPoints.get(2)).getX()) < 10.0) {
                    return true;
                }
            }
        } else if (RightAngleUtil.isOverlapYCoordinate((Rectangle2d)sourceRect, (Rectangle2d)targetRect) && rightAngleControlPoints.size() <= 4 && RightAngleUtil.isOverlapYCoordinate((Rectangle2d)sourceRect, (Pnt2d)Geometries.toPnt2d((Point)((Point)rightAngleControlPoints.get(1)))) && RightAngleUtil.isOverlapYCoordinate((Rectangle2d)targetRect, (Pnt2d)Geometries.toPnt2d((Point)((Point)rightAngleControlPoints.get(rightAngleControlPoints.size() - 2)))) && RightAngleUtil.isOverlapYCoordinate((Rectangle2d)sourceRect, (Pnt2d)Geometries.toPnt2d((Point)((Point)rightAngleControlPoints.get(rightAngleControlPoints.size() - 1))))) {
            if (lastWayPoints.size() <= 2) {
                return true;
            }
            if (rightAngleControlPoints.size() == 4 && Math.abs(((Point)rightAngleControlPoints.get(1)).getY() - ((Point)rightAngleControlPoints.get(2)).getY()) < 10.0) {
                return true;
            }
        }
        return false;
    }

    private static List<Point> getAlignedAnchorPoints(DiagramElement base, net.astah.notation.Edge edge, LayoutCalculator layoutCalculator, Point origin) {
        Rectangle2d alignRect;
        Point alignPoint;
        Point basePoint;
        ArrayList<Point> controlPoints = new ArrayList<Point>();
        DiagramElement source = layoutCalculator.getSource((Edge)edge);
        DiagramElement target = layoutCalculator.getTarget((Edge)edge);
        controlPoints.add(layoutCalculator.getSourceEndPoint((Edge)edge, origin));
        controlPoints.add(layoutCalculator.getTargetEndPoint((Edge)edge, origin));
        if (base == source) {
            basePoint = (Point)controlPoints.get(0);
            alignPoint = (Point)controlPoints.get(1);
            alignRect = Geometries.toRectangle2d((Bounds)layoutCalculator.getTargetEndBounds((Edge)edge, origin));
        } else if (base == target) {
            basePoint = (Point)controlPoints.get(1);
            alignPoint = (Point)controlPoints.get(0);
            alignRect = Geometries.toRectangle2d((Bounds)layoutCalculator.getSourceEndBounds((Edge)edge, origin));
        } else {
            return Collections.emptyList();
        }
        if (basePoint == null) {
            return Collections.emptyList();
        }
        if (RightAngleUtil.isOverlapXCoordinate((Rectangle2d)alignRect, (Pnt2d)Geometries.toPnt2d((Point)basePoint))) {
            alignPoint.setX(basePoint.getX());
        } else if (RightAngleUtil.isOverlapYCoordinate((Rectangle2d)alignRect, (Pnt2d)Geometries.toPnt2d((Point)basePoint))) {
            alignPoint.setY(basePoint.getY());
        } else {
            return Collections.emptyList();
        }
        return controlPoints;
    }
}

