/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.notation.edit.reactor;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashSet;
import net.astah.dd.dc.Dimension;
import net.astah.dd.di.DIPackage;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.provider.IItemGeometryProvider;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.dd.di.util.DiagramElements;
import net.astah.emf.common.notify.IPathNotification;
import net.astah.emf.edit.command.SynchronizeListCommand;
import net.astah.emf.edit.notify.EFeaturePathReactor;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.notation.Location;
import net.astah.notation.LocationConstraint;
import net.astah.notation.NotationFactory;
import net.astah.notation.NotationPackage;
import net.astah.stpa.stamp.Link;
import net.astah.stpa.stamp.Signal;
import net.astah.stpa.stamp.notation.STAMPEdge;
import net.astah.stpa.stamp.notation.STAMPLabel;
import net.astah.stpa.stamp.notation.STAMPNotationFactory;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class LinkEdgeSynchronizer
implements EFeaturePathReactor {
    public Command process(EditingDomain domain, Collection<IPathNotification> notifications) {
        HashSet<Object> processed = new HashSet<Object>();
        CompoundCommand result = new CompoundCommand();
        LayoutCalculator layoutCalculator = new LayoutCalculator();
        for (IPathNotification notification : notifications) {
            STAMPEdge edge;
            EObject element;
            Object notifier = notification.getNotifier();
            if (!processed.add(notifier) || !((element = DiagramElements.getModelElement((DiagramElement)(edge = (STAMPEdge)notification.getNotifier()))) instanceof Link)) continue;
            Link link = (Link)element;
            ImmutableList syncedLabels = FluentIterable.from((Iterable)link.getSignals()).transform(signal -> this.resolveOrCreateLabel((Signal)signal, edge)).toList();
            STAMPLabel lastLabel = null;
            Location lastLocation = null;
            for (DiagramElement syncedLabel : syncedLabels) {
                STAMPLabel label = (STAMPLabel)syncedLabel;
                if (lastLabel == null || label.getLocation() != null) {
                    lastLabel = label;
                    continue;
                }
                IItemGeometryProvider provider = (IItemGeometryProvider)ItemProviders.adapt((EditingDomain)domain, (Notifier)lastLabel, IItemGeometryProvider.class);
                if (provider == null) continue;
                layoutCalculator.getFeatureAccessor().put((Object)lastLabel, (Object)DIPackage.Literals.DIAGRAM_ELEMENT__OWNING_ELEMENT, (Object)edge);
                Dimension size = provider.getBoundsSize((Object)lastLabel, layoutCalculator);
                LocationConstraint locationConstraint = lastLabel.getLocation();
                if (locationConstraint != null) {
                    lastLocation = (Location)locationConstraint;
                } else if (lastLocation == null) {
                    lastLocation = NotationFactory.eINSTANCE.createLocation(0.0, 0.0);
                }
                Location location = NotationFactory.eINSTANCE.createLocation(lastLocation.getX(), lastLocation.getY() + size.getHeight() + 5.0);
                Command command = SetCommand.create((EditingDomain)domain, (Object)label, (Object)NotationPackage.Literals.SHAPE__LOCATION, (Object)location);
                result.appendIfCanExecute(command);
                lastLabel = label;
                lastLocation = location;
            }
            result.appendIfCanExecute((Command)new SynchronizeListCommand(domain, edge.getOwnedElements(), (Iterable)syncedLabels));
        }
        return result.isEmpty() ? null : result.unwrap();
    }

    private DiagramElement resolveOrCreateLabel(Signal signal, STAMPEdge edge) {
        return (DiagramElement)Iterables.tryFind((Iterable)edge.getOwnedElements(), label -> label.getModelElements().contains((Object)signal)).or((Object)this.createLabel(signal, edge));
    }

    private STAMPLabel createLabel(Signal signal, STAMPEdge edge) {
        STAMPLabel label = STAMPNotationFactory.eINSTANCE.createSTAMPLabel();
        DiagramElements.setModelElement((DiagramElement)label, (EObject)signal);
        label.setText(signal.getName());
        return label;
    }
}

