/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.notation.edit.reactor;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.astah.common.collect.Streams;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.util.DiagramElements;
import net.astah.emf.common.ecore.EObjects;
import net.astah.emf.common.notify.EFeaturePath;
import net.astah.emf.common.notify.IPathNotification;
import net.astah.emf.edit.notify.EFeaturePathReactor;
import net.astah.stpa.stamp.ControlAction;
import net.astah.stpa.stamp.ControlLink;
import net.astah.stpa.stamp.STAMPPackage;
import net.astah.stpa.stamp.UCAAnalysis;
import net.astah.stpa.stamp.notation.STAMPEdge;
import net.astah.stpa.stamp.notation.STAMPNotationPackage;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class ControlLinkSynchronizer
implements EFeaturePathReactor {
    public Command process(EditingDomain domain, Collection<IPathNotification> notifications) {
        HashSet<Object> processed = new HashSet<Object>();
        CompoundCommand result = new CompoundCommand();
        for (IPathNotification notification : notifications) {
            Object notifier = notification.getNotifier();
            if (!processed.add(notifier)) continue;
            STAMPEdge edge = (STAMPEdge)notification.getNotifier();
            EObject element = DiagramElements.getModelElement((DiagramElement)edge);
            Optional<UCAAnalysis> ucaAnalysis = this.getUCAAnalysis(edge);
            if (!ucaAnalysis.isPresent()) continue;
            UCAAnalysis analysis = ucaAnalysis.get();
            if (!(element instanceof ControlLink)) continue;
            List actions = ((ControlLink)element).getActions().stream().filter(action -> !analysis.getControlActions().contains(action)).collect(Collectors.toList());
            for (ControlAction action2 : actions) {
                result.appendIfCanExecute(AddCommand.create((EditingDomain)domain, (Object)analysis, (Object)STAMPPackage.Literals.UCA_ANALYSIS__CONTROL_ACTION, (Object)action2));
            }
        }
        return result.isEmpty() ? null : result.unwrap();
    }

    private Optional<UCAAnalysis> getUCAAnalysis(STAMPEdge edge) {
        EObject diagram = EObjects.getAncestor((EClass)STAMPNotationPackage.Literals.STAMP_CONTROL_STRUCTURE_DIAGRAM, (EObject)edge);
        EFeaturePath featurePath = EFeaturePath.builder().addInverse(STAMPNotationPackage.Literals.STAMP_CONTROL_STRUCTURE_DIAGRAM, STAMPNotationPackage.Literals.UCA_TABLE__CONTROL_STRUCTURE_DIAGRAM).add(STAMPNotationPackage.Literals.UCA_TABLE, (EStructuralFeature)STAMPNotationPackage.Literals.UCA_TABLE__ANALYSIS).create();
        return Streams.filterByType(featurePath.getReferences(diagram).stream(), UCAAnalysis.class).findFirst();
    }
}

