/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.notation.edit.layout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.DCFactory;
import net.astah.dd.dc.Dimension;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.notation.Location;
import net.astah.notation.LocationConstraint;
import net.astah.notation.Shape;
import net.astah.notation.edit.layout.FreeLayout;
import net.astah.notation.edit.layout.TextAreaLayout;
import net.astah.notation.provider.GeometryProviderHelper;
import net.astah.stpa.stamp.notation.STAMPCompartment;
import net.astah.stpa.stamp.notation.STAMPCompartmentableShape;
import net.astah.stpa.stamp.notation.STAMPLabel;
import net.astah.stpa.stamp.notation.provider.STAMPCompartmentableShapeItemProvider;

public class LayoutUtil {
    public static final String TEXT_AREA = "text_area";
    public static final String FREE = "free";
    public static final String COMPARTMENT = "compartment";

    public static Map<String, List<DiagramElement>> createChildrenMap(Iterable<? extends DiagramElement> children) {
        HashMap<String, List<DiagramElement>> childrenMap = new HashMap<String, List<DiagramElement>>();
        for (DiagramElement diagramElement : children) {
            if (diagramElement instanceof STAMPLabel) {
                LayoutUtil.addChild(TEXT_AREA, diagramElement, childrenMap);
                continue;
            }
            if (diagramElement instanceof STAMPCompartmentableShape) {
                LayoutUtil.addChild(FREE, diagramElement, childrenMap);
                continue;
            }
            if (!(diagramElement instanceof STAMPCompartment)) continue;
            LayoutUtil.addChild(COMPARTMENT, diagramElement, childrenMap);
        }
        return childrenMap;
    }

    private static void addChild(String id, DiagramElement child, Map<String, List<DiagramElement>> childrenMap) {
        List<Object> children = null;
        if (childrenMap.containsKey(id)) {
            children = childrenMap.get(id);
        } else {
            children = new ArrayList();
            childrenMap.put(id, children);
        }
        children.add(child);
    }

    public static Bounds getComponentNameBounds(Shape component, LayoutCalculator layoutCalculator) {
        TextAreaLayout textAreaLayout = (TextAreaLayout)STAMPCompartmentableShapeItemProvider.LAYOUT.getOwnedLayoutById(TEXT_AREA);
        FreeLayout freeLayout = (FreeLayout)STAMPCompartmentableShapeItemProvider.LAYOUT.getOwnedLayoutById(FREE);
        List elements = layoutCalculator.getOwnedElements((DiagramElement)component);
        Bounds totalBounds = DCFactory.eINSTANCE.createBounds();
        freeLayout.calculateTotalBounds((DiagramElement)component, null, LayoutUtil.createChildrenMap(elements), layoutCalculator, totalBounds);
        double x = 0.0;
        double y = 0.0;
        double width = 0.0;
        if (totalBounds.getWidth() != 0.0) {
            width = totalBounds.getWidth();
            LocationConstraint locationConstraint = GeometryProviderHelper.getLocation((Shape)component, (LayoutCalculator)layoutCalculator);
            if (locationConstraint instanceof Location) {
                Location location = (Location)locationConstraint;
                y = location.getY();
                if (location.getX() < totalBounds.getX()) {
                    width += totalBounds.getX() - location.getX();
                } else {
                    x = totalBounds.getX() - location.getX();
                }
            }
        }
        Dimension size = DCFactory.eINSTANCE.createDimension(width, 0.0);
        textAreaLayout.calculateTotalSize(elements.stream().filter(e -> e instanceof STAMPLabel).collect(Collectors.toList()), layoutCalculator, size);
        return DCFactory.eINSTANCE.createBounds(x, y, size.getWidth(), size.getHeight());
    }
}

