/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.notation.edit.command;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.util.DiagramElements;
import net.astah.emf.edit.command.SynchronizeListCommand;
import net.astah.stpa.stamp.NamedElement;
import net.astah.stpa.stamp.ProcessModel;
import net.astah.stpa.stamp.ProcessValue;
import net.astah.stpa.stamp.ProcessVariable;
import net.astah.stpa.stamp.notation.STAMPCompartment;
import net.astah.stpa.stamp.notation.STAMPDiagramElement;
import net.astah.stpa.stamp.notation.STAMPLabel;
import net.astah.stpa.stamp.notation.STAMPNotationFactory;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.domain.EditingDomain;

public class SynchronizeProcessModelCommand
extends CompoundCommand {
    private final EditingDomain domain;
    private final STAMPCompartment owner;

    public SynchronizeProcessModelCommand(EditingDomain domain, STAMPCompartment owner) {
        this.domain = domain;
        this.owner = owner;
    }

    protected boolean prepare() {
        this.prepareCommand();
        return super.prepare();
    }

    private void prepareCommand() {
        if (this.domain == null || this.owner == null || this.owner.getModelElements().isEmpty()) {
            return;
        }
        List<STAMPDiagramElement> elements = this.getElementsInCompartment((EList<STAMPDiagramElement>)this.owner.getElementInCompartments(), (EList<ProcessVariable>)((ProcessModel)DiagramElements.getModelElement((DiagramElement)this.owner, ProcessModel.class)).getVariables());
        ArrayList elementsWithCompartmentName = Lists.newArrayList((Object[])new STAMPDiagramElement[]{(STAMPDiagramElement)this.owner.getSTAMPOwnedElements().get(0)});
        elementsWithCompartmentName.addAll(elements);
        this.append((Command)new SynchronizeListCommand(this.domain, this.owner.getOwnedElements(), (Iterable)elementsWithCompartmentName));
        this.append((Command)new SynchronizeListCommand(this.domain, this.owner.getElementInCompartments(), elements));
    }

    private List<STAMPDiagramElement> getElementsInCompartment(EList<STAMPDiagramElement> oldElements, EList<ProcessVariable> processVariables) {
        ArrayList<STAMPDiagramElement> newElements = new ArrayList<STAMPDiagramElement>();
        for (ProcessVariable processVariable : processVariables) {
            STAMPDiagramElement variableLabel = this.getDiagramElementByNamedElement(oldElements, (NamedElement)processVariable);
            newElements.add((STAMPDiagramElement)(variableLabel != null ? variableLabel : this.createLabel((NamedElement)processVariable)));
            for (ProcessValue processValue : processVariable.getValues()) {
                STAMPDiagramElement valueLabel = this.getDiagramElementByNamedElement(oldElements, (NamedElement)processValue);
                newElements.add((STAMPDiagramElement)(valueLabel != null ? valueLabel : this.createLabel((NamedElement)processValue)));
            }
        }
        return newElements;
    }

    private STAMPDiagramElement getDiagramElementByNamedElement(EList<STAMPDiagramElement> elements, NamedElement element) {
        return elements.stream().filter(e -> e.getModelElements().contains((Object)element)).findFirst().orElse(null);
    }

    private STAMPLabel createLabel(NamedElement element) {
        STAMPLabel label = STAMPNotationFactory.eINSTANCE.createSTAMPLabel();
        label.getModelElements().add((Object)element);
        label.setText(element.getName());
        return label;
    }
}

