/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.notation.edit.command;

import com.google.common.base.Strings;
import java.util.Objects;
import net.astah.stpa.stamp.Element;
import net.astah.stpa.stamp.NamedElement;
import net.astah.stpa.stamp.Note;
import net.astah.stpa.stamp.notation.STAMPLabel;
import net.astah.stpa.stamp.notation.STAMPNotationPackage;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class SynchronizeLabelCommand
extends CompoundCommand {
    private EditingDomain domain;
    private STAMPLabel owner;

    public SynchronizeLabelCommand(EditingDomain domain, STAMPLabel owner) {
        this.domain = domain;
        this.owner = owner;
    }

    protected boolean prepare() {
        this.prepareCommand();
        return super.prepare();
    }

    private void prepareCommand() {
        if (this.domain == null || this.owner == null) {
            return;
        }
        String text = this.getText();
        if (Strings.isNullOrEmpty((String)text)) {
            this.append(SetCommand.create((EditingDomain)this.domain, (Object)this.owner, (Object)STAMPNotationPackage.Literals.STAMP_LABEL__TEXT, (Object)SetCommand.UNSET_VALUE));
        } else if (!Objects.equals(text, this.owner.getText())) {
            this.append(SetCommand.create((EditingDomain)this.domain, (Object)this.owner, (Object)STAMPNotationPackage.Literals.STAMP_LABEL__TEXT, (Object)text));
        }
    }

    private String getText() {
        if (this.owner.eIsSet((EStructuralFeature)STAMPNotationPackage.Literals.STAMP_DIAGRAM_ELEMENT__STAMP_MODEL_ELEMENT)) {
            for (Element element : this.owner.getSTAMPModelElements()) {
                if (element instanceof NamedElement) {
                    return ((NamedElement)element).getName();
                }
                if (!(element instanceof Note)) continue;
                return ((Note)element).getBody();
            }
        }
        return null;
    }
}

