/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.notation.edit.command;

import java.util.Collection;
import java.util.Collections;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.util.DiagramElements;
import net.astah.emf.common.ecore.EObjects;
import net.astah.emf.edit.command.DeferringCommandWrapper;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.notation.NotationFactory;
import net.astah.notation.NotationPackage;
import net.astah.notation.Shape;
import net.astah.notation.Size;
import net.astah.notation.edit.command.ApplyPreferenceStyleCommand;
import net.astah.project.Facet;
import net.astah.project.Project;
import net.astah.project.ProjectManagerAdapter;
import net.astah.project.StylePreferenceContainer;
import net.astah.stpa.stamp.Component;
import net.astah.stpa.stamp.ControlLink;
import net.astah.stpa.stamp.ControlStructure;
import net.astah.stpa.stamp.Element;
import net.astah.stpa.stamp.FeedbackLink;
import net.astah.stpa.stamp.Link;
import net.astah.stpa.stamp.LinkEnd;
import net.astah.stpa.stamp.Note;
import net.astah.stpa.stamp.NoteAnchor;
import net.astah.stpa.stamp.STAMPPackage;
import net.astah.stpa.stamp.STAMPPlugin;
import net.astah.stpa.stamp.STPAAnalysis;
import net.astah.stpa.stamp.Signal;
import net.astah.stpa.stamp.notation.STAMPComponentShape;
import net.astah.stpa.stamp.notation.STAMPControlLoopDiagram;
import net.astah.stpa.stamp.notation.STAMPControlStructureDiagram;
import net.astah.stpa.stamp.notation.STAMPDiagram;
import net.astah.stpa.stamp.notation.STAMPDiagramElement;
import net.astah.stpa.stamp.notation.STAMPEdge;
import net.astah.stpa.stamp.notation.STAMPLabel;
import net.astah.stpa.stamp.notation.STAMPNotationFactory;
import net.astah.stpa.stamp.notation.STAMPNotationPackage;
import net.astah.stpa.stamp.notation.STAMPShape;
import net.astah.stpa.stamp.notation.edit.command.SynchronizeLabelCommand;
import net.astah.stpa.stamp.notation.util.STAMPNotationSwitch;
import net.astah.stpa.stamp.util.STAMPSwitch;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitializeSTAMPDiagramElementCommand
extends CompoundCommand {
    static final Logger LOGGER = LoggerFactory.getLogger(InitializeSTAMPDiagramElementCommand.class);
    protected EditingDomain domain;
    protected EObject owner;
    protected Object value;
    protected int index;

    public InitializeSTAMPDiagramElementCommand(EditingDomain domain, EObject owner, Object value, int index) {
        super("InitializeSTAMPDiagramElementCommand", "InitializeSTAMPDiagramElementCommand");
        this.domain = domain;
        this.owner = owner;
        this.value = value;
        this.index = index;
    }

    protected boolean prepare() {
        if (this.owner == null || this.value == null) {
            return false;
        }
        STAMPDiagramElement diagramElement = (STAMPDiagramElement)this.value;
        EList modelElements = diagramElement.getSTAMPModelElements();
        if (!modelElements.isEmpty()) {
            for (Element element : modelElements) {
                if (EObjects.isAttachedTo((EditingDomain)this.domain, (EObject)element)) continue;
                this.append(this.createCreateChildCommand(element));
            }
        }
        this.AddInitializeCommand(diagramElement);
        return this.isEmpty() || super.prepare();
    }

    protected Command createCreateChildCommand(Element element) {
        NewChildDescriptorFactory factory = new NewChildDescriptorFactory();
        CommandParameter newChildDescriptor = (CommandParameter)factory.doSwitch((EObject)element);
        if (newChildDescriptor == null) {
            return UnexecutableCommand.INSTANCE;
        }
        if (newChildDescriptor.getOwner() == null && newChildDescriptor.getFeature() == null && newChildDescriptor.getValue() == null) {
            return IdentityCommand.INSTANCE;
        }
        Object owner = newChildDescriptor.getOwner();
        return CreateChildCommand.create((EditingDomain)this.domain, (Object)owner, (Object)newChildDescriptor, Collections.singleton(owner));
    }

    protected void AddInitializeCommand(STAMPDiagramElement diagramElement) {
        new AddInitializeCommandSwitch().doSwitch((EObject)diagramElement);
    }

    protected Facet getFacet() {
        ResourceSet resourceSet = this.domain.getResourceSet();
        Project project = ProjectManagerAdapter.getContainingProject((Notifier)resourceSet, (EObject)this.owner);
        return project != null ? project.getFacet(STAMPPlugin.FACET_SYMBOLIC_NAME) : null;
    }

    private CommandParameter getCommandParameter(NewChildDescriptorFactory newChildDescriptorFactory, EReference eReference, EObject eObject) {
        STAMPDiagram diagram = (STAMPDiagram)EObjects.getAncestor(STAMPDiagram.class, (EObject)this.owner);
        if (diagram instanceof STAMPControlStructureDiagram) {
            for (Element element : diagram.getSTAMPModelElements()) {
                if (!(element instanceof ControlStructure)) continue;
                return new CommandParameter((Object)element, (Object)eReference, (Object)eObject);
            }
        } else if (diagram instanceof STAMPControlLoopDiagram) {
            STPAAnalysis analysis = ((STAMPControlLoopDiagram)diagram).getControlLoop().getHintWordSet().getOwner();
            ControlStructure controlStructure = analysis.getControlStructures().stream().findFirst().orElseGet(() -> ((STPAAnalysis)analysis).createControlStructure());
            return new CommandParameter((Object)controlStructure, (Object)eReference, (Object)eObject);
        }
        return (CommandParameter)newChildDescriptorFactory.doSwitch(eObject);
    }

    protected class AddInitializeCommandSwitch
    extends STAMPNotationSwitch<Void> {
        protected AddInitializeCommandSwitch() {
        }

        public Void caseDiagramElement(DiagramElement object) {
            String sharedFontKey = "font";
            Project project = ProjectManagerAdapter.getRootProject((Notifier)InitializeSTAMPDiagramElementCommand.this.owner);
            InitializeSTAMPDiagramElementCommand.this.append((Command)new DeferringCommandWrapper(ApplyPreferenceStyleCommand.create((EditingDomain)InitializeSTAMPDiagramElementCommand.this.domain, (EObject)object, (StylePreferenceContainer)project, (String)"font")));
            return (Void)super.caseDiagramElement(object);
        }

        public Void caseSTAMPComponentShape(STAMPComponentShape object) {
            if (!object.isOmitted()) {
                STAMPLabel label = STAMPNotationFactory.eINSTANCE.createSTAMPLabel();
                EObject model = DiagramElements.getModelElement((DiagramElement)object);
                DiagramElements.setModelElement((DiagramElement)label, (EObject)model);
                InitializeSTAMPDiagramElementCommand.this.append(AddCommand.create((EditingDomain)InitializeSTAMPDiagramElementCommand.this.domain, (Object)object, (Object)STAMPNotationPackage.Literals.STAMP_DIAGRAM_ELEMENT__STAMP_OWNED_ELEMENT, (Object)label));
                InitializeSTAMPDiagramElementCommand.this.append(SetCommand.create((EditingDomain)InitializeSTAMPDiagramElementCommand.this.domain, (Object)model, (Object)STAMPPackage.Literals.COMPONENT__IS_ANALYSIS_TARGET, (Object)true));
                InitializeSTAMPDiagramElementCommand.this.append((Command)new SynchronizeLabelCommand(InitializeSTAMPDiagramElementCommand.this.domain, label));
                this.appendSetDefaultSizeIfAbsent(object, "component");
                String styleKey = "component";
                InitializeSTAMPDiagramElementCommand.this.append(ApplyPreferenceStyleCommand.create((EditingDomain)InitializeSTAMPDiagramElementCommand.this.domain, (EObject)object, (StylePreferenceContainer)InitializeSTAMPDiagramElementCommand.this.getFacet(), (String)"component"));
            }
            return (Void)super.caseSTAMPComponentShape(object);
        }

        public Void caseSTAMPShape(STAMPShape object) {
            EObject model = DiagramElements.getModelElement((DiagramElement)object);
            if (model.eClass() == STAMPPackage.Literals.NOTE) {
                STAMPLabel label = STAMPNotationFactory.eINSTANCE.createSTAMPLabel();
                InitializeSTAMPDiagramElementCommand.this.append(AddCommand.create((EditingDomain)InitializeSTAMPDiagramElementCommand.this.domain, (Object)object, (Object)STAMPNotationPackage.Literals.STAMP_DIAGRAM_ELEMENT__STAMP_OWNED_ELEMENT, (Object)label));
                InitializeSTAMPDiagramElementCommand.this.append(AddCommand.create((EditingDomain)InitializeSTAMPDiagramElementCommand.this.domain, (Object)label, (Object)STAMPNotationPackage.Literals.STAMP_DIAGRAM_ELEMENT__STAMP_MODEL_ELEMENT, (Collection)object.getSTAMPModelElements()));
                this.appendSetDefaultSizeIfAbsent(object, "note");
                String styleKey = "note";
                InitializeSTAMPDiagramElementCommand.this.append(ApplyPreferenceStyleCommand.create((EditingDomain)InitializeSTAMPDiagramElementCommand.this.domain, (EObject)object, (StylePreferenceContainer)InitializeSTAMPDiagramElementCommand.this.getFacet(), (String)"note"));
            }
            return (Void)super.caseSTAMPShape(object);
        }

        public Void caseSTAMPEdge(STAMPEdge object) {
            EObject modelElement = DiagramElements.getModelElement((DiagramElement)object);
            if (modelElement instanceof ControlLink) {
                String styleKey = "control_action";
                InitializeSTAMPDiagramElementCommand.this.append(ApplyPreferenceStyleCommand.create((EditingDomain)InitializeSTAMPDiagramElementCommand.this.domain, (EObject)object, (StylePreferenceContainer)InitializeSTAMPDiagramElementCommand.this.getFacet(), (String)"control_action"));
            } else if (modelElement instanceof FeedbackLink) {
                String styleKey = "feedback";
                InitializeSTAMPDiagramElementCommand.this.append(ApplyPreferenceStyleCommand.create((EditingDomain)InitializeSTAMPDiagramElementCommand.this.domain, (EObject)object, (StylePreferenceContainer)InitializeSTAMPDiagramElementCommand.this.getFacet(), (String)"feedback"));
            }
            return (Void)super.caseSTAMPEdge(object);
        }

        private void appendSetDefaultSizeIfAbsent(Object object, String kind) {
            Size size;
            String defaultHeightStr;
            String defaultWidthStr;
            if (!(object instanceof Shape)) {
                return;
            }
            Shape shape = (Shape)object;
            if (shape.getSize() != null) {
                return;
            }
            String defaultKey = "default_size." + kind;
            String widthKey = defaultKey + ".default_width";
            String heightKey = defaultKey + ".default_height";
            boolean useDefault = RuntimeGlobal.sysProp.getBooleanWithDefault(defaultKey + ".default_use");
            if (useDefault) {
                defaultWidthStr = RuntimeGlobal.sysProp.getStringWithDefault(widthKey);
                defaultHeightStr = RuntimeGlobal.sysProp.getStringWithDefault(heightKey);
            } else if ("note".equals(kind) || "component".equals(kind)) {
                defaultWidthStr = RuntimeGlobal.sysProp.getDefaultString(widthKey);
                defaultHeightStr = RuntimeGlobal.sysProp.getDefaultString(heightKey);
            } else {
                return;
            }
            try {
                double defaultWidth = Double.parseDouble(defaultWidthStr);
                double defaultHeight = Double.parseDouble(defaultHeightStr);
                size = NotationFactory.eINSTANCE.createSize(defaultWidth, defaultHeight);
            }
            catch (NumberFormatException e) {
                LOGGER.warn("The value of the default size is not numeric. : " + widthKey + " or " + heightKey);
                return;
            }
            InitializeSTAMPDiagramElementCommand.this.append(SetCommand.create((EditingDomain)InitializeSTAMPDiagramElementCommand.this.domain, (Object)object, (Object)NotationPackage.Literals.SHAPE__SIZE, (Object)size));
        }
    }

    protected class NewChildDescriptorFactory
    extends STAMPSwitch<CommandParameter> {
        protected NewChildDescriptorFactory() {
        }

        public CommandParameter caseComponent(Component object) {
            if (InitializeSTAMPDiagramElementCommand.this.owner instanceof STAMPComponentShape) {
                return new CommandParameter((Object)DiagramElements.getModelElement((DiagramElement)((STAMPComponentShape)InitializeSTAMPDiagramElementCommand.this.owner)), (Object)STAMPPackage.Literals.COMPONENT__NESTED_COMPONENT, (Object)object, InitializeSTAMPDiagramElementCommand.this.index);
            }
            return InitializeSTAMPDiagramElementCommand.this.getCommandParameter(this, STAMPPackage.Literals.CONTROL_STRUCTURE__COMPONENT, (EObject)object);
        }

        public CommandParameter caseLink(Link object) {
            return InitializeSTAMPDiagramElementCommand.this.getCommandParameter(this, STAMPPackage.Literals.CONTROL_STRUCTURE__LINK, (EObject)object);
        }

        public CommandParameter caseSignal(Signal object) {
            return new CommandParameter((Object)DiagramElements.getModelElement((DiagramElement)((STAMPEdge)InitializeSTAMPDiagramElementCommand.this.owner)), (Object)STAMPPackage.Literals.LINK__SIGNAL, (Object)object, InitializeSTAMPDiagramElementCommand.this.index);
        }

        public CommandParameter caseNote(Note object) {
            return InitializeSTAMPDiagramElementCommand.this.getCommandParameter(this, STAMPPackage.Literals.ELEMENT__OWNED_NOTE, (EObject)object);
        }

        public CommandParameter caseLinkEnd(LinkEnd object) {
            return InitializeSTAMPDiagramElementCommand.this.getCommandParameter(this, STAMPPackage.Literals.CONTROL_STRUCTURE__LINK_END, (EObject)object);
        }

        public CommandParameter caseNoteAnchor(NoteAnchor object) {
            return new CommandParameter(null, null, null);
        }
    }
}

