/*
 * Decompiled with CFR 0.152.
 */
package net.astah.common.i18n;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.function.Function;
import lombok.NonNull;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class OverridingResourceBundle
extends ResourceBundle {
    static Function<Locale, ResourceBundle> a;
    protected final ResourceBundle override;
    protected final String prefix;

    protected OverridingResourceBundle(@NonNull ResourceBundle resourceBundle, @NonNull ResourceBundle resourceBundle2) {
        this(resourceBundle, resourceBundle2, null);
        if (resourceBundle == null) {
            throw new NullPointerException("base");
        }
        if (resourceBundle2 == null) {
            throw new NullPointerException("override");
        }
    }

    protected OverridingResourceBundle(@NonNull ResourceBundle resourceBundle, @NonNull ResourceBundle resourceBundle2, String string) {
        if (resourceBundle == null) {
            throw new NullPointerException("base");
        }
        if (resourceBundle2 == null) {
            throw new NullPointerException("override");
        }
        this.override = resourceBundle2;
        this.prefix = string;
        this.setParent(resourceBundle);
    }

    public static void setDefaultSupplier(@NonNull Function<Locale, ResourceBundle> function) {
        if (function == null) {
            throw new NullPointerException("provider");
        }
        Preconditions.checkState((a == null ? 1 : 0) != 0, (Object)"defaultProvider has set");
        a = function;
    }

    public static ResourceBundle bundleFor(String string) {
        return OverridingResourceBundle.bundleFor(string, Locale.getDefault());
    }

    public static ResourceBundle bundleFor(String string, Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale);
        return OverridingResourceBundle.a(locale, resourceBundle, null);
    }

    public static ResourceBundle bundleFor(String string, Locale locale, ClassLoader classLoader) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale, classLoader);
        return OverridingResourceBundle.a(locale, resourceBundle, null);
    }

    public static ResourceBundle bundleFor(String string, Locale locale, ClassLoader classLoader, String string2) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale, classLoader);
        return OverridingResourceBundle.a(locale, resourceBundle, string2);
    }

    static ResourceBundle a(Locale locale, ResourceBundle resourceBundle, String string) {
        ResourceBundle resourceBundle2;
        Function<Locale, ResourceBundle> function = a;
        if (function != null && (resourceBundle2 = function.apply(locale)) != null) {
            return new OverridingResourceBundle(resourceBundle, resourceBundle2, string);
        }
        return resourceBundle;
    }

    @Override
    public String getBaseBundleName() {
        String string = this.parent.getBaseBundleName();
        if (string == null) {
            return null;
        }
        String string2 = this.override.getBaseBundleName();
        return string + " [with overrided by: " + string2 + "]";
    }

    @Override
    public Enumeration<String> getKeys() {
        return this.parent.getKeys();
    }

    @Override
    protected Object handleGetObject(String string) {
        Object object = this.parent.getObject(string);
        String string2 = this.qualifyKey(string);
        if (string2 != null && this.override.containsKey(string2)) {
            return this.override.getObject(string2);
        }
        if (this.override.containsKey(string)) {
            return this.override.getObject(string);
        }
        return object;
    }

    protected String qualifyKey(String string) {
        return this.prefix != null ? this.prefix + "." + string : null;
    }

    public static class Control
    extends ResourceBundle.Control {
        protected final String overrideName;
        protected final ClassLoader overrideLoader;

        public Control(@NonNull String string, @NonNull ClassLoader classLoader) {
            if (string == null) {
                throw new NullPointerException("overrideName");
            }
            if (classLoader == null) {
                throw new NullPointerException("overrideLoader");
            }
            this.overrideName = string;
            this.overrideLoader = classLoader;
        }

        @Override
        public ResourceBundle newBundle(String string, Locale locale, String string2, ClassLoader classLoader, boolean bl) throws IllegalAccessException, InstantiationException, IOException {
            ResourceBundle resourceBundle = super.newBundle(string, locale, string2, classLoader, bl);
            try {
                ResourceBundle resourceBundle2 = ResourceBundle.getBundle(this.overrideName, locale, this.overrideLoader, Control.getControl(FORMAT_DEFAULT));
                return new OverridingResourceBundle(resourceBundle, resourceBundle2);
            }
            catch (MissingResourceException missingResourceException) {
                return resourceBundle;
            }
        }
    }
}

