/*
 * Decompiled with CFR 0.152.
 */
package net.astah.common.eclipse;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class DOMConfigurationElement
implements IConfigurationElement {
    private final Element a;

    public DOMConfigurationElement(Element element) {
        Assert.isNotNull((Object)element, (String)"element");
        this.a = element;
    }

    protected Element getElement() {
        return this.a;
    }

    public int hashCode() {
        return this.a.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DOMConfigurationElement)) {
            return false;
        }
        DOMConfigurationElement dOMConfigurationElement = (DOMConfigurationElement)object;
        return this.a.equals(dOMConfigurationElement.a);
    }

    public String toString() {
        return this.a.toString();
    }

    public Object createExecutableExtension(String string) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public String getAttribute(String string) throws InvalidRegistryObjectException {
        if (!this.a.hasAttribute(string)) {
            return null;
        }
        return this.a.getAttribute(string);
    }

    public String getAttribute(String string, String string2) throws InvalidRegistryObjectException {
        return this.getAttribute(string);
    }

    public String getAttributeAsIs(String string) throws InvalidRegistryObjectException {
        return this.getAttribute(string);
    }

    public String[] getAttributeNames() throws InvalidRegistryObjectException {
        NamedNodeMap namedNodeMap = this.a.getAttributes();
        String[] stringArray = new String[namedNodeMap.getLength()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = namedNodeMap.item(i).getNodeName();
        }
        return stringArray;
    }

    public IConfigurationElement[] getChildren() throws InvalidRegistryObjectException {
        return this.a((Predicate<Element>)Predicates.alwaysTrue());
    }

    public IConfigurationElement[] getChildren(String string) throws InvalidRegistryObjectException {
        return this.a((Predicate<Element>)((Predicate)element -> string.equals(element.getNodeName())));
    }

    public IContributor getContributor() throws InvalidRegistryObjectException {
        throw new UnsupportedOperationException();
    }

    public IExtension getDeclaringExtension() throws InvalidRegistryObjectException {
        throw new UnsupportedOperationException();
    }

    public String getName() throws InvalidRegistryObjectException {
        return this.a.getLocalName();
    }

    public String getNamespace() throws InvalidRegistryObjectException {
        return this.getNamespaceIdentifier();
    }

    public String getNamespaceIdentifier() throws InvalidRegistryObjectException {
        return this.a.getNamespaceURI();
    }

    public Object getParent() throws InvalidRegistryObjectException {
        Node node = this.a.getParentNode();
        if (node.getNodeType() == 1) {
            return new DOMConfigurationElement((Element)node);
        }
        return null;
    }

    public String getValue() throws InvalidRegistryObjectException {
        NodeList nodeList = this.a.getChildNodes();
        StringBuilder stringBuilder = new StringBuilder();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            switch (node.getNodeType()) {
                case 3: 
                case 4: {
                    stringBuilder.append(((Text)node).getTextContent());
                }
            }
        }
        return stringBuilder.toString();
    }

    public String getValue(String string) throws InvalidRegistryObjectException {
        return this.getValue();
    }

    public String getValueAsIs() throws InvalidRegistryObjectException {
        return this.getValue();
    }

    public boolean isValid() {
        return true;
    }

    private IConfigurationElement[] a(Predicate<Element> predicate) {
        NodeList nodeList = this.a.getChildNodes();
        IConfigurationElement[] iConfigurationElementArray = new IConfigurationElement[nodeList.getLength()];
        int n = 0;
        for (int i = 0; i < iConfigurationElementArray.length; ++i) {
            Element element;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !predicate.apply((Object)(element = (Element)node))) continue;
            iConfigurationElementArray[n++] = new DOMConfigurationElement(element);
        }
        if (n < iConfigurationElementArray.length) {
            return Arrays.copyOf(iConfigurationElementArray, n);
        }
        return iConfigurationElementArray;
    }
}

