/*
 * Decompiled with CFR 0.152.
 */
package net.astah.common.collect;

import com.google.common.base.Equivalence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.BiFunction;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class MoreLists {
    public static <T> int[] differenceOf(List<T> list, List<T> list2) {
        return MoreLists.differenceOf(list, list2, Equivalence.equals());
    }

    public static <T> int[] differenceOf(List<T> list, List<T> list2, Equivalence<? super T> equivalence) {
        int n = list.size();
        int n2 = list2.size();
        int[] nArray = new int[n];
        int n3 = 0;
        int n4 = 0;
        block0: for (int i = 0; i < n; ++i) {
            T t = list.get(i);
            for (int j = n4; j < n2; ++j) {
                if (!equivalence.equivalent(list2.get(j), t)) continue;
                n4 = j + 1;
                continue block0;
            }
            nArray[n3++] = i;
        }
        return n3 == nArray.length ? nArray : Arrays.copyOf(nArray, n3);
    }

    public static <T> List<T> difference(List<T> list, List<T> list2) {
        return MoreLists.difference(list, list2, Equivalence.equals());
    }

    public static <T> List<T> difference(List<T> list, List<T> list2, Equivalence<? super T> equivalence) {
        int n = list.size();
        int n2 = list2.size();
        ArrayList<T> arrayList = new ArrayList<T>();
        int n3 = 0;
        block0: for (int i = 0; i < n; ++i) {
            T t = list.get(i);
            for (int j = n3; j < n2; ++j) {
                if (!equivalence.equivalent(list2.get(j), t)) continue;
                n3 = j + 1;
                continue block0;
            }
            arrayList.add(t);
        }
        return arrayList;
    }

    public static <T> List<T> intersect(List<T> list, List<T> list2) {
        return MoreLists.intersect(list, list2, Equivalence.equals());
    }

    public static <T> List<T> intersect(List<T> list, List<T> list2, Equivalence<? super T> equivalence) {
        int n = list.size();
        int n2 = list2.size();
        ArrayList<T> arrayList = new ArrayList<T>();
        int n3 = 0;
        block0: for (int i = 0; i < n; ++i) {
            T t = list.get(i);
            for (int j = n3; j < n2; ++j) {
                if (!equivalence.equivalent(list2.get(j), t)) continue;
                n3 = j + 1;
                arrayList.add(t);
                continue block0;
            }
        }
        return arrayList;
    }

    public static <T> List<T> getAll(List<T> list, int[] nArray) {
        if (nArray.length > 0) {
            ArrayList<T> arrayList = new ArrayList<T>(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                arrayList.add(list.get(nArray[i]));
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    public static <T> List<T> excludeAll(List<T> list, int[] nArray) {
        ArrayList<T> arrayList = new ArrayList<T>(list.size() - nArray.length);
        ListIterator<T> listIterator = list.listIterator();
        int n = 0;
        while (listIterator.hasNext()) {
            T t = listIterator.next();
            if (n < nArray.length && nArray[n] == listIterator.previousIndex()) {
                ++n;
                continue;
            }
            arrayList.add(t);
        }
        return arrayList;
    }

    public static <T, R> void synchronize(List<R> list, Iterable<? extends T> iterable, BiFunction<T, R, R> biFunction) {
        MoreLists.synchronize(list, iterable, biFunction, Equivalence.equals());
    }

    public static <T, R> void synchronize(List<R> list, Iterable<? extends T> iterable, BiFunction<T, R, R> biFunction, Equivalence<? super R> equivalence) {
        T t;
        Iterator<T> iterator = iterable.iterator();
        ListIterator<R> listIterator = list.listIterator();
        while (listIterator.hasNext() && iterator.hasNext()) {
            R r;
            t = iterator.next();
            R r2 = listIterator.next();
            if (equivalence.equivalent(r2, r = biFunction.apply(t, r2))) continue;
            listIterator.set(r);
        }
        while (iterator.hasNext()) {
            t = iterator.next();
            listIterator.add(biFunction.apply(t, null));
        }
        while (listIterator.hasNext()) {
            listIterator.next();
            listIterator.remove();
        }
    }
}

