/*
 * Decompiled with CFR 0.152.
 */
package net.astah.common.collect;

import java.util.LinkedHashMap;
import java.util.Map;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class LRUCacheMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = -5446864110584861772L;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    final int capacity;

    public LRUCacheMap(int n) {
        this(n, 16, 0.75f);
    }

    public LRUCacheMap(int n, int n2) {
        this(n, n2, 0.75f);
    }

    public LRUCacheMap(int n, int n2, float f) {
        super(Math.min(n, n2), f, true);
        if (n < 0) {
            throw new IllegalArgumentException("Illegal capacity: " + n);
        }
        this.capacity = n;
    }

    public LRUCacheMap(int n, Map<? extends K, ? extends V> map) {
        this(n);
        this.putAll(map);
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
        return this.size() > this.capacity;
    }
}

