/*
 * Decompiled with CFR 0.152.
 */
package net.astah.dd.dg.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.astah.dd.dc.Color;
import net.astah.dd.dc.DCFactory;
import net.astah.dd.dc.util.StyleResolver;
import net.astah.dd.dg.DGFactory;
import net.astah.dd.dg.DGPackage;
import net.astah.dd.dg.Fill;
import net.astah.dd.dg.GraphicalElement;
import net.astah.dd.dg.Style;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class DGStyleResolver
extends StyleResolver<GraphicalElement, Style> {
    public static final List<StyleResolver.Provider<GraphicalElement, Style>> DEFAULT_PROVIDERS = Collections.singletonList(new DefaultProvider());
    private static final DGStyleResolver a = new DGStyleResolver(new ArrayList<StyleResolver.Provider<GraphicalElement, Style>>(DEFAULT_PROVIDERS));

    public static DGStyleResolver getInstance(EObject eObject) {
        return a;
    }

    public DGStyleResolver() {
        this(new ArrayList<StyleResolver.Provider<GraphicalElement, Style>>(DEFAULT_PROVIDERS));
    }

    public DGStyleResolver(List<StyleResolver.Provider<GraphicalElement, Style>> list) {
        super(list);
    }

    public Fill resolveFill(GraphicalElement graphicalElement) {
        return ((Style)this.resolveStyle((EObject)graphicalElement, (EStructuralFeature)DGPackage.Literals.STYLE__FILL)).getFill();
    }

    public Color resolveFillColor(GraphicalElement graphicalElement) {
        return ((Style)this.resolveStyle((EObject)graphicalElement, (EStructuralFeature)DGPackage.Literals.STYLE__FILL_COLOR)).getFillColor();
    }

    public double resolveFillOpacity(GraphicalElement graphicalElement) {
        return ((Style)this.resolveStyle((EObject)graphicalElement, (EStructuralFeature)DGPackage.Literals.STYLE__FILL_OPACITY)).getFillOpacity();
    }

    public double resolveStrokeWidth(GraphicalElement graphicalElement) {
        return ((Style)this.resolveStyle((EObject)graphicalElement, (EStructuralFeature)DGPackage.Literals.STYLE__STROKE_WIDTH)).getStrokeWidth();
    }

    public double resolveStrokeOpacity(GraphicalElement graphicalElement) {
        return ((Style)this.resolveStyle((EObject)graphicalElement, (EStructuralFeature)DGPackage.Literals.STYLE__STROKE_OPACITY)).getStrokeOpacity();
    }

    public Color resolveStrokeColor(GraphicalElement graphicalElement) {
        return ((Style)this.resolveStyle((EObject)graphicalElement, (EStructuralFeature)DGPackage.Literals.STYLE__STROKE_COLOR)).getStrokeColor();
    }

    public EList<Double> resolveStrokeDashLengths(GraphicalElement graphicalElement) {
        return ((Style)this.resolveStyle((EObject)graphicalElement, (EStructuralFeature)DGPackage.Literals.STYLE__STROKE_DASH_LENGTH)).getStrokeDashLengths();
    }

    public double resolveFontSize(GraphicalElement graphicalElement) {
        return ((Style)this.resolveStyle((EObject)graphicalElement, (EStructuralFeature)DGPackage.Literals.STYLE__FONT_SIZE)).getFontSize();
    }

    public String resolveFontName(GraphicalElement graphicalElement) {
        return ((Style)this.resolveStyle((EObject)graphicalElement, (EStructuralFeature)DGPackage.Literals.STYLE__FONT_NAME)).getFontName();
    }

    public Color resolveFontColor(GraphicalElement graphicalElement) {
        return ((Style)this.resolveStyle((EObject)graphicalElement, (EStructuralFeature)DGPackage.Literals.STYLE__FONT_COLOR)).getFontColor();
    }

    public boolean resolveFontItalic(GraphicalElement graphicalElement) {
        return ((Style)this.resolveStyle((EObject)graphicalElement, (EStructuralFeature)DGPackage.Literals.STYLE__FONT_ITALIC)).isFontItalic();
    }

    public boolean resolveFontBold(GraphicalElement graphicalElement) {
        return ((Style)this.resolveStyle((EObject)graphicalElement, (EStructuralFeature)DGPackage.Literals.STYLE__FONT_BOLD)).isFontBold();
    }

    public boolean resolveFontUnderline(GraphicalElement graphicalElement) {
        return ((Style)this.resolveStyle((EObject)graphicalElement, (EStructuralFeature)DGPackage.Literals.STYLE__FONT_UNDERLINE)).isFontUnderline();
    }

    public boolean resolveFontStrikeThrough(GraphicalElement graphicalElement) {
        return ((Style)this.resolveStyle((EObject)graphicalElement, (EStructuralFeature)DGPackage.Literals.STYLE__FONT_STRIKE_THROUGH)).isFontStrikeThrough();
    }

    protected Style createDefaultStyle() {
        Style style = DGFactory.eINSTANCE.createStyle();
        style.setFillOpacity(1.0);
        style.setStrokeWidth(1.0);
        style.setStrokeOpacity(1.0);
        style.setStrokeColor(DCFactory.eINSTANCE.createColor(0, 0, 0));
        style.setFontSize(10.0);
        style.setFontName("Arial");
        style.setFontColor(DCFactory.eINSTANCE.createColor(0, 0, 0));
        style.setFontItalic(false);
        style.setFontBold(false);
        style.setFontUnderline(false);
        style.setFontStrikeThrough(false);
        return style;
    }

    protected static class DefaultProvider
    extends StyleResolver.CascadingProvider<GraphicalElement, Style> {
        protected DefaultProvider() {
        }

        protected GraphicalElement getOwningElement(GraphicalElement graphicalElement) {
            return graphicalElement.getGroup();
        }

        protected Style getLocalStyle(GraphicalElement graphicalElement, EStructuralFeature eStructuralFeature) {
            if (graphicalElement.eIsSet((EStructuralFeature)DGPackage.Literals.GRAPHICAL_ELEMENT__LOCAL_STYLE)) {
                for (Style style : graphicalElement.getLocalStyles()) {
                    if (!style.eIsSet(eStructuralFeature)) continue;
                    return style;
                }
            }
            return null;
        }

        protected Style getSharedStyle(GraphicalElement graphicalElement, EStructuralFeature eStructuralFeature) {
            if (graphicalElement.eIsSet((EStructuralFeature)DGPackage.Literals.GRAPHICAL_ELEMENT__SHARED_STYLE)) {
                for (Style style : graphicalElement.getSharedStyles()) {
                    if (!style.eIsSet(eStructuralFeature)) continue;
                    return style;
                }
            }
            return null;
        }
    }
}

