/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.mindmap.editor;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.astah.golf.control.Mode;
import net.astah.golf.draw.GNode;
import net.astah.notation.GraphicalShape;
import net.astah.notation.editor.IItemEditorFactory;
import net.astah.notation.editor.ItemEditorFactoryImpl;
import net.astah.notation.editor.graphics.GraphicalShapeViewElementFactory;
import net.astah.notation.mindmap.MMBoundaryShape;
import net.astah.notation.mindmap.MMBranchEdge;
import net.astah.notation.mindmap.MMDiagram;
import net.astah.notation.mindmap.MMGraphicalShape;
import net.astah.notation.mindmap.MMLinkEdge;
import net.astah.notation.mindmap.MMNotationPackage;
import net.astah.notation.mindmap.MMTopicShape;
import net.astah.notation.mindmap.editor.MMBoundaryShapeViewElement;
import net.astah.notation.mindmap.editor.MMBranchEdgeViewElement;
import net.astah.notation.mindmap.editor.MMDiagramViewElement;
import net.astah.notation.mindmap.editor.MMLinkEdgeViewElement;
import net.astah.notation.mindmap.editor.MMTopicShapeViewElement;
import net.astah.notation.mindmap.util.MMNotationAdapterFactory;
import net.astah.notation.mindmap.util.MMNotationSwitch;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Switch;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MMNotationEditorAdapterFactory
extends MMNotationAdapterFactory {
    private static final Logger a = LoggerFactory.getLogger(MMNotationEditorAdapterFactory.class);
    protected Collection<Object> supportedTypes = new HashSet<Object>();
    protected Adapter adapter;

    public MMNotationEditorAdapterFactory() {
        this.supportedTypes.add(IItemEditorFactory.class);
    }

    public Adapter createAdapter(Notifier notifier) {
        if (this.adapter == null) {
            this.adapter = new ItemEditorFactoryImpl((Switch)new CreateSwitch(), null, (Switch)new AssociateModeSwitch(), (Switch)new MMNotationSwitch(), (Switch)new ModeToolBarSwitch(), MMNotationPackage.eINSTANCE.getMMGraphicalShape());
        }
        return this.adapter;
    }

    public boolean isFactoryForType(Object object) {
        return this.supportedTypes.contains(object) || super.isFactoryForType(object);
    }

    protected void associate(Adapter adapter, Notifier notifier) {
    }

    protected static class ModeToolBarSwitch
    extends MMNotationSwitch<String> {
        protected ModeToolBarSwitch() {
        }

        public String caseMMDiagram(MMDiagram mMDiagram) {
            return "diagramview.modetoolbar.mindmap_modetoolbar";
        }
    }

    protected static class AssociateModeSwitch
    extends MMNotationSwitch<List<Mode>> {
        protected AssociateModeSwitch() {
        }

        public List<Mode> caseMMDiagram(MMDiagram mMDiagram) {
            ArrayList arrayList = Lists.newArrayList();
            try {
                arrayList.add((Mode)Class.forName("net.astah.jomt.jcontrol.mode.MoveMode").newInstance());
                arrayList.add((Mode)Class.forName("net.astah.jomt.jcontrol.mode.PluralMoveMode").newInstance());
                arrayList.add((Mode)Class.forName("net.astah.jomt.jcontrol.mode.DiagramPopupMode").newInstance());
                arrayList.add((Mode)Class.forName("net.astah.jomt.jcontrol.mode.DiagramZoomMode").newInstance());
                arrayList.add((Mode)Class.forName("net.astah.jomt.jcontrol.mode.ResizeMode").newInstance());
                arrayList.add((Mode)Class.forName("net.astah.jomt.jcontrol.mode.MoveFeatureMode").newInstance());
                arrayList.add((Mode)Class.forName("net.astah.jomt.jcontrol.mode.RelationMode").newInstance());
                arrayList.add((Mode)Class.forName("net.astah.jomt.jcontrol.mode.MindMapMode").newInstance());
                arrayList.add((Mode)Class.forName("net.astah.jomt.jcontrol.mode.MMDiagramDnDMode").newInstance());
            }
            catch (Exception exception) {
                a.warn("Failed to get mode for " + mMDiagram.getName(), (Throwable)exception);
            }
            return arrayList;
        }
    }

    protected static class CreateSwitch
    extends MMNotationSwitch<GNode> {
        protected CreateSwitch() {
        }

        public GNode caseMMDiagram(MMDiagram mMDiagram) {
            MMDiagramViewElement mMDiagramViewElement = new MMDiagramViewElement(mMDiagram);
            mMDiagramViewElement.setDomain(TransactionUtil.getEditingDomain((EObject)mMDiagram));
            mMDiagramViewElement.refresh(null, null);
            return mMDiagramViewElement;
        }

        public GNode caseMMTopicShape(MMTopicShape mMTopicShape) {
            return new MMTopicShapeViewElement(mMTopicShape);
        }

        public GNode caseMMBoundaryShape(MMBoundaryShape mMBoundaryShape) {
            return new MMBoundaryShapeViewElement(mMBoundaryShape);
        }

        public GNode caseMMBranchEdge(MMBranchEdge mMBranchEdge) {
            return new MMBranchEdgeViewElement(mMBranchEdge);
        }

        public GNode caseMMLinkEdge(MMLinkEdge mMLinkEdge) {
            return new MMLinkEdgeViewElement(mMLinkEdge);
        }

        public GNode caseMMGraphicalShape(MMGraphicalShape mMGraphicalShape) {
            return GraphicalShapeViewElementFactory.INSTANCE.createViewElement((GraphicalShape)mMGraphicalShape);
        }
    }
}

