/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.mindmap.editor;

import java.awt.Font;
import java.util.Collections;
import java.util.List;
import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.Point;
import net.astah.dd.di.DiagramElement;
import net.astah.golf.draw.GCurve;
import net.astah.golf.draw.GGeometry;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GNodeSelectionListener;
import net.astah.golf.draw.GPolygon;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.util.GolfUtilities;
import net.astah.golf.widget.CColor;
import net.astah.jomt.jutil.JomtWidgetFactory;
import net.astah.jomt.jviewElement.CJomtTextNode;
import net.astah.notation.editor.IViewElement;
import net.astah.notation.mindmap.MMLabel;
import net.astah.notation.mindmap.MMLinkEdge;
import net.astah.notation.mindmap.edit.layout.MMLinkEdgeOperations;
import net.astah.notation.mindmap.edit.layout.MMStyleSupport;
import net.astah.notation.mindmap.editor.MMEdgeViewElement;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;

public class MMLinkEdgeViewElement
extends MMEdgeViewElement<MMLinkEdge> {
    private static final byte a = 2;
    private static final byte b = 2;
    private static final byte c = 2;
    private static final byte d = 7;
    private static final byte e = 8;
    protected CJomtTextNode name;
    private GCurve f;
    private GPolygon g;
    private GPolygon h;

    public MMLinkEdgeViewElement(MMLinkEdge mMLinkEdge) {
        super(mMLinkEdge);
    }

    public void update(Notifier notifier, Object object) {
        this.update();
    }

    public void refresh(Notifier notifier, Object object) {
        this.init();
        super.refresh(notifier, object);
    }

    public void setSelected(boolean bl) {
        if (this.f != null) {
            this.f.setSelected(bl);
        }
        if (this.g != null) {
            this.g.setSelected(bl);
        }
        if (this.h != null) {
            this.h.setSelected(bl);
        }
        if (this.name != null) {
            this.name.setSelected(bl);
        }
        this.update();
    }

    public void update() {
        MMLinkEdge mMLinkEdge = (MMLinkEdge)this.getModel();
        MMLabel mMLabel = MMLinkEdgeOperations.getNameLabel((MMLinkEdge)mMLinkEdge);
        this.updateLabel(this.name, mMLabel);
        this.updateDepth();
        this.c();
        this.a();
        this.b();
    }

    private void a(GPolygon gPolygon, Pnt2d pnt2d, Pnt2d pnt2d2) {
        double d = pnt2d2.x - pnt2d.x;
        double d2 = pnt2d2.y - pnt2d.y;
        double d3 = Math.sqrt(d * d + d2 * d2) / 10.0;
        double d4 = d / d3;
        double d5 = d2 / d3;
        double d6 = 0.5;
        Pnt2d[] pnt2dArray = new Pnt2d[]{new Pnt2d(pnt2d.x, pnt2d.y), new Pnt2d(pnt2d.x + d4 + d6 * d5, pnt2d.y + d5 - d6 * d4), new Pnt2d(pnt2d.x + d4 - d6 * d5, pnt2d.y + d5 + d6 * d4), new Pnt2d(pnt2d.x, pnt2d.y)};
        gPolygon.setPoints(pnt2dArray);
    }

    private void a() {
        if (this.g == null) {
            return;
        }
        EList eList = ((MMLinkEdge)this.getModel()).getWaypoints();
        this.a(this.g, new Pnt2d(((Point)eList.get(3)).getX(), ((Point)eList.get(3)).getY()), new Pnt2d(((Point)eList.get(2)).getX(), ((Point)eList.get(2)).getY()));
    }

    private void b() {
        if (this.h == null) {
            return;
        }
        EList eList = ((MMLinkEdge)this.getModel()).getWaypoints();
        this.a(this.h, new Pnt2d(((Point)eList.get(0)).getX(), ((Point)eList.get(0)).getY()), new Pnt2d(((Point)eList.get(1)).getX(), ((Point)eList.get(1)).getY()));
    }

    private void c() {
        MMLinkEdge mMLinkEdge = (MMLinkEdge)this.getModel();
        String string = MMStyleSupport.getLineTypeWithAuto((DiagramElement)mMLinkEdge);
        byte by = 1;
        if (string.equals("line")) {
            by = 0;
        } else if (string.equals("dash2")) {
            by = 2;
        }
        if (this.f != null) {
            this.f.setRimPattern(by);
            this.f.setRimWidth(MMStyleSupport.getLineWidthWithAuto((DiagramElement)mMLinkEdge));
            EList eList = ((MMLinkEdge)this.getModel()).getWaypoints();
            this.f.setCurve(((Point)eList.get(0)).getX(), ((Point)eList.get(0)).getY(), ((Point)eList.get(1)).getX(), ((Point)eList.get(1)).getY(), ((Point)eList.get(2)).getX(), ((Point)eList.get(2)).getY(), ((Point)eList.get(3)).getX(), ((Point)eList.get(3)).getY());
        }
    }

    public void updateColor() {
        MMLinkEdge mMLinkEdge = (MMLinkEdge)this.getModel();
        CColor cColor = MMStyleSupport.getLineColorWithAuto((DiagramElement)mMLinkEdge);
        if (this.f != null) {
            this.f.setForegroundColor(cColor);
            this.f.setShadowColorNo((byte)7);
            this.f.setBackgroundNo((byte)2);
            this.f.setColorNo((byte)2);
            this.f.setKnobColorNo((byte)2);
        }
        if (this.name != null) {
            this.name.setColorNo((byte)2);
            this.name.setKnobColorNo((byte)2);
        }
        this.a(this.g, cColor);
        this.a(this.h, cColor);
    }

    private void a(GPolygon gPolygon, CColor cColor) {
        if (gPolygon == null) {
            return;
        }
        gPolygon.setForegroundColor(cColor);
        gPolygon.setBackgroundColor(cColor);
        gPolygon.setShadowColorNo((byte)7);
        gPolygon.setColorNo((byte)2);
        gPolygon.setKnobColorNo((byte)2);
    }

    public void updateSelectionType() {
        if (this.name != null) {
            this.name.setSelectionType((byte)1);
        }
        if (this.f != null) {
            this.f.setSelectionType((byte)3);
        }
        if (this.g != null) {
            this.g.setSelectionType((byte)3);
        }
        if (this.h != null) {
            this.h.setSelectionType((byte)3);
        }
    }

    public void updateDepth() {
        int n = this.getDepth();
        if (this.f != null) {
            this.f.setDepth(n - 1);
        }
        if (this.g != null) {
            this.g.setDepth(n);
        }
        if (this.h != null) {
            this.h.setDepth(n);
        }
        if (this.name != null) {
            this.name.setDepth(n - 3);
        }
    }

    protected void init() {
        this.j();
        this.d();
        this.e();
        this.f();
        this.updateColor();
        this.updateSelectionType();
        this.updateDepth();
    }

    private void d() {
        if (this.name != null && !this.k()) {
            this.removeNode((GNode)this.name);
            this.name = null;
        }
        if (this.name == null && this.k()) {
            int n = 0;
            n |= 0x40;
            n |= 4;
            MMLinkEdge mMLinkEdge = (MMLinkEdge)this.getModel();
            MMLabel mMLabel = MMLinkEdgeOperations.getNameLabel((MMLinkEdge)mMLinkEdge);
            this.name = JomtWidgetFactory.instance().createJomtTextAreaNode();
            this.name.setType(n |= 0x40000000);
            this.name.setAlpha(0.0f);
            this.name.setModel((Object)mMLabel);
            this.name.setWrapLine(true);
            this.name.setSelectionType((byte)1);
            this.name.addNodeSelectionListener((GNodeSelectionListener)this.f);
            this.f.addNodeSelectionListener((GNodeSelectionListener)this.name.body);
            this.addNode((GNode)this.name);
        }
    }

    private void e() {
        if (this.g != null && !this.h()) {
            this.removeNode((GNode)this.g);
            this.g = null;
        }
        if (this.g == null && this.h()) {
            this.g = this.g();
            this.addNode((GNode)this.g);
        }
    }

    private void f() {
        if (this.h != null && !this.i()) {
            this.removeNode((GNode)this.h);
            this.h = null;
        }
        if (this.h == null && this.i()) {
            this.h = this.g();
            this.addNode((GNode)this.h);
        }
    }

    private GPolygon g() {
        GPolygon gPolygon = new GPolygon();
        gPolygon.setFilled(true);
        gPolygon.setRimPatternScale(5);
        gPolygon.setRimPattern((byte)0);
        gPolygon.setModel((Object)this.getModel());
        int n = 0;
        n |= 1;
        gPolygon.setType(n |= 8);
        gPolygon.addNodeSelectionListener((GNodeSelectionListener)this);
        gPolygon.setSelectable(false);
        return gPolygon;
    }

    private boolean h() {
        if (!this.k()) {
            return false;
        }
        MMLinkEdge mMLinkEdge = (MMLinkEdge)this.getModel();
        String string = MMStyleSupport.getLineArrowTypeWithAuto((DiagramElement)mMLinkEdge);
        return "startarrow".equals(string) || "botharrow".equals(string);
    }

    private boolean i() {
        if (!this.k()) {
            return false;
        }
        MMLinkEdge mMLinkEdge = (MMLinkEdge)this.getModel();
        String string = MMStyleSupport.getLineArrowTypeWithAuto((DiagramElement)mMLinkEdge);
        return "endarrow".equals(string) || "botharrow".equals(string);
    }

    private void j() {
        MMLinkEdge mMLinkEdge = (MMLinkEdge)this.getModel();
        if (this.f != null && !this.k()) {
            this.removeNode((GNode)this.f);
            this.f = null;
        }
        if (this.f == null && this.k()) {
            this.f = new GCurve(true);
            this.f.setRimPatternScale(5);
            this.f.setModel((Object)mMLinkEdge);
            this.f.setControlLineColorNo((byte)8);
            int n = 0;
            n |= 1;
            this.f.setType(n |= 8);
            this.addNode((GNode)this.f);
            this.f.addNodeSelectionListener((GNodeSelectionListener)this.f);
            this.f.addNodeSelectionListener((GNodeSelectionListener)this);
        }
    }

    private boolean k() {
        MMLinkEdge mMLinkEdge = (MMLinkEdge)this.getModel();
        return mMLinkEdge.getSourceTopic() != null && mMLinkEdge.getTargetTopic() != null && mMLinkEdge.getSourceTopic().isShowWithFolded() && mMLinkEdge.getTargetTopic().isShowWithFolded();
    }

    protected void updateLabel(CJomtTextNode cJomtTextNode, MMLabel mMLabel) {
        if (cJomtTextNode == null || mMLabel == null) {
            return;
        }
        if (mMLabel == null || !mMLabel.isVisible() || mMLabel.getText() == null || mMLabel.getText().isEmpty()) {
            cJomtTextNode.setVisible(false);
            cJomtTextNode.setPickable(false);
            return;
        }
        cJomtTextNode.setVisible(true);
        cJomtTextNode.setPickable(true);
        cJomtTextNode.setString(mMLabel.getText());
        cJomtTextNode.setSelectedString(mMLabel.getText());
        cJomtTextNode.setFont(MMLinkEdgeOperations.getNameFont((MMLabel)mMLabel));
        cJomtTextNode.setFontColor(MMStyleSupport.getFontColorWithAuto((DiagramElement)mMLabel));
        Bounds bounds = mMLabel.getBounds();
        cJomtTextNode.setRect(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    public List<IViewElement> getViewElementsMovingTogether() {
        return Collections.singletonList(this);
    }

    public GNode createShapeMovingTogether() {
        Pnt2d[] pnt2dArray = this.f.getKnobPoints();
        GCurve gCurve = new GCurve(pnt2dArray[0].x, pnt2dArray[0].y, pnt2dArray[1].x, pnt2dArray[1].y, pnt2dArray[2].x, pnt2dArray[2].y, pnt2dArray[3].x, pnt2dArray[3].y);
        gCurve.setColorNo((byte)3);
        gCurve.setBackgroundNo((byte)0);
        gCurve.setRimWidth(this.f.getRimWidth());
        return gCurve;
    }

    protected GGeometry getBounds(Rectangle2d rectangle2d) {
        if (this.name != null && this.name.body != null) {
            rectangle2d.x = this.name.body.getX();
            rectangle2d.y = this.name.body.getY();
            rectangle2d.width = this.name.body.getWidth();
            rectangle2d.height = this.name.body.getHeight();
            return this.name.body;
        }
        return null;
    }

    public void setSelected() {
        for (GNode gNode : this.getChildren()) {
            if (!gNode.isVisible()) continue;
            gNode.setSelected(true);
        }
    }

    protected Pnt2d constrainSize(Pnt2d pnt2d, int n, Pnt2d pnt2d2) {
        Font font = MMLinkEdgeOperations.getNameFont((MMLabel)MMLinkEdgeOperations.getNameLabel((MMLinkEdge)((MMLinkEdge)this.getModel())));
        double d = GolfUtilities.computeStringWidth((Font)font, (String)"m");
        double d2 = GolfUtilities.computeStringHeight((Font)font, (String)"m");
        this.applyMinimalSize(pnt2d, d, d2);
        return pnt2d;
    }
}

