/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.mindmap.editor;

import java.awt.BasicStroke;
import java.util.List;
import net.astah.dd.dc.Point;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.provider.Geometries;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.golf.draw.GArrow;
import net.astah.golf.draw.GCurve;
import net.astah.golf.draw.GGeometry;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GNodeSelectionEvent;
import net.astah.golf.draw.GNodeSelectionListener;
import net.astah.golf.draw.GPolyline;
import net.astah.golf.draw.GSharpCurve;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.notation.mindmap.MMBranchEdge;
import net.astah.notation.mindmap.MMTopicShape;
import net.astah.notation.mindmap.edit.layout.MMStyleSupport;
import net.astah.notation.mindmap.editor.MMEdgeViewElement;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;

public class MMBranchEdgeViewElement
extends MMEdgeViewElement<MMBranchEdge> {
    private GArrow a;
    private GCurve b;
    private GArrow c;
    private GSharpCurve d;
    private static final byte e = 2;
    private static final byte f = 2;
    private static final byte g = 7;

    public MMBranchEdgeViewElement(MMBranchEdge mMBranchEdge) {
        super(mMBranchEdge);
    }

    public void update(Notifier notifier, Object object) {
        MMBranchEdge mMBranchEdge = (MMBranchEdge)this.getModel();
        MMTopicShape mMTopicShape = mMBranchEdge.getChild();
        if (mMTopicShape == null || mMBranchEdge.getOwningElement() == null) {
            return;
        }
        EList eList = mMBranchEdge.getWaypoints();
        if (mMBranchEdge.getOwningElement() == null || eList.isEmpty() || eList.size() < 2) {
            return;
        }
        this.updateDepth();
        this.init();
        this.updateLineTypeAndArrow();
    }

    protected void layout(List<Point> list) {
        super.layout(list);
        MMBranchEdge mMBranchEdge = (MMBranchEdge)this.getModel();
        MMTopicShape mMTopicShape = mMBranchEdge.getChild();
        if (mMTopicShape == null || mMBranchEdge.getOwningElement() == null) {
            return;
        }
        if (mMBranchEdge.getOwningElement() == null || list.isEmpty() || list.size() < 2) {
            return;
        }
        Pnt2d[] pnt2dArray = Geometries.toPnt2dArray(list);
        Pnt2d[] pnt2dArray2 = new Pnt2d[4];
        this.removeNode((GNode)this.a);
        this.removeNodeSelectionListener((GNodeSelectionListener)this.a);
        if (MMStyleSupport.getShapeWithAuto((DiagramElement)mMBranchEdge).equals("linear")) {
            this.c.setPoints(pnt2dArray);
            this.a = this.c;
            this.c.setRimWidth(MMStyleSupport.getLineWidthWithAuto((DiagramElement)mMTopicShape));
        } else if (MMStyleSupport.getShapeWithAuto((DiagramElement)mMBranchEdge).equals("bezier")) {
            pnt2dArray2[0] = pnt2dArray[0];
            pnt2dArray2[1] = new Pnt2d(mMBranchEdge.getSourceInclination().getX(), mMBranchEdge.getSourceInclination().getY());
            pnt2dArray2[2] = new Pnt2d(mMBranchEdge.getTargetInclination().getX(), mMBranchEdge.getTargetInclination().getY());
            pnt2dArray2[3] = pnt2dArray[1];
            this.b.setCurve(pnt2dArray2[0].x, pnt2dArray2[0].y, pnt2dArray2[1].x, pnt2dArray2[1].y, pnt2dArray2[2].x, pnt2dArray2[2].y, pnt2dArray2[3].x, pnt2dArray2[3].y);
            this.a = this.b;
            this.b.setRimWidth(MMStyleSupport.getLineWidthWithAuto((DiagramElement)mMTopicShape));
        } else if (MMStyleSupport.getShapeWithAuto((DiagramElement)mMBranchEdge).equals("sharpBezier") || MMStyleSupport.getShapeWithAuto((DiagramElement)mMBranchEdge).equals("sharpLinear")) {
            int n = MMStyleSupport.getLineWidthWithAuto((DiagramElement)mMBranchEdge);
            double d = (double)MMStyleSupport.getLineWidthWithAuto((DiagramElement)mMTopicShape) / 2.0;
            pnt2dArray2[0] = pnt2dArray[0];
            pnt2dArray2[1] = new Pnt2d(mMBranchEdge.getSourceInclination().getX(), mMBranchEdge.getSourceInclination().getY());
            pnt2dArray2[2] = new Pnt2d(mMBranchEdge.getTargetInclination().getX(), mMBranchEdge.getTargetInclination().getY());
            pnt2dArray2[3] = pnt2dArray[1];
            if (Math.abs(pnt2dArray[0].y - pnt2dArray[1].y) < (double)n) {
                this.d.setCurve(pnt2dArray2[0].x, pnt2dArray2[0].y, pnt2dArray2[1].x, pnt2dArray2[1].y, pnt2dArray2[2].x, pnt2dArray2[2].y - d, pnt2dArray2[3].x, pnt2dArray2[3].y - d);
                this.d.setCurve2(pnt2dArray2[0].x, pnt2dArray2[0].y + (double)n, pnt2dArray2[1].x, pnt2dArray2[1].y + (double)n, pnt2dArray2[2].x, pnt2dArray2[2].y + d, pnt2dArray2[3].x, pnt2dArray2[3].y + d);
            } else if (pnt2dArray[0].x < pnt2dArray[1].x) {
                if (pnt2dArray2[3].y > pnt2dArray2[0].y) {
                    d = -d;
                }
                this.d.setCurve2(pnt2dArray2[0].x - (double)n, pnt2dArray2[0].y, pnt2dArray2[1].x - (double)n, pnt2dArray2[1].y, pnt2dArray2[2].x, pnt2dArray2[2].y - d, pnt2dArray2[3].x, pnt2dArray2[3].y - d);
                this.d.setCurve(pnt2dArray2[0].x, pnt2dArray2[0].y, pnt2dArray2[1].x, pnt2dArray2[1].y, pnt2dArray2[2].x, pnt2dArray2[2].y + d, pnt2dArray2[3].x, pnt2dArray2[3].y + d);
            } else {
                if (pnt2dArray2[3].y < pnt2dArray2[0].y) {
                    d = -d;
                }
                this.d.setCurve(pnt2dArray2[0].x, pnt2dArray2[0].y, pnt2dArray2[1].x, pnt2dArray2[1].y, pnt2dArray2[2].x, pnt2dArray2[2].y - d, pnt2dArray2[3].x, pnt2dArray2[3].y - d);
                this.d.setCurve2(pnt2dArray2[0].x + (double)n, pnt2dArray2[0].y, pnt2dArray2[1].x + (double)n, pnt2dArray2[1].y, pnt2dArray2[2].x, pnt2dArray2[2].y + d, pnt2dArray2[3].x, pnt2dArray2[3].y + d);
            }
            this.a = this.d;
        }
        this.addNode((GNode)this.a, true);
        this.addNodeSelectionListener((GNodeSelectionListener)this.a);
        this.a.addNodeSelectionListener((GNodeSelectionListener)this);
        this.setSelectionType((byte)2);
        MMTopicShape mMTopicShape2 = mMBranchEdge.getParent();
        if (mMTopicShape2 != null) {
            this.a.setVisible(!mMTopicShape2.isParentFolded());
        }
        GGeometry.setGradationNo((byte)0);
    }

    protected List<Point> getWaypoints(MMBranchEdge mMBranchEdge, LayoutCalculator layoutCalculator) {
        return mMBranchEdge.getWaypoints();
    }

    public void refresh(Notifier notifier, Object object) {
        this.init();
        super.refresh(notifier, object);
    }

    public void setSelected(boolean bl) {
        if (!this.isSelectable()) {
            return;
        }
        if (this.isSelected() == bl) {
            return;
        }
        super.setSelected(bl);
        this.selectionChange(bl);
    }

    public void selectionChange(GNodeSelectionEvent gNodeSelectionEvent) {
        boolean bl = gNodeSelectionEvent.isSelected();
        if (this.isSelected() != bl) {
            this.setSelected(bl);
        }
    }

    public void init() {
        int n;
        MMBranchEdge mMBranchEdge = (MMBranchEdge)this.getModel();
        if (mMBranchEdge.getOwningElement() == null) {
            return;
        }
        Pnt2d[] pnt2dArray = new Pnt2d[4];
        EList eList = mMBranchEdge.getWaypoints();
        if (eList.isEmpty() || eList.size() < 2) {
            return;
        }
        Pnt2d[] pnt2dArray2 = new Pnt2d[eList.size()];
        for (n = 0; n < pnt2dArray2.length; ++n) {
            pnt2dArray2[n] = new Pnt2d(((Point)eList.get(n)).getX(), ((Point)eList.get(n)).getY());
        }
        if (this.c == null) {
            this.c = new GArrow(pnt2dArray2, 0, 0);
            n = 1;
            this.c.setType(n |= 0x100);
            this.c.setRimWidth(MMStyleSupport.getLineWidthWithAuto((DiagramElement)mMBranchEdge));
            this.c.setModel((Object)this.getModel());
            this.c.setRimmedPick(true);
            this.c.setSelectable(true);
            this.c.setPickable(true);
            this.c.addNodeSelectionListener((GNodeSelectionListener)this);
            this.c.setArrowHeadLength(6.0);
        }
        if (this.b == null) {
            pnt2dArray[0] = pnt2dArray2[0];
            pnt2dArray[1] = new Pnt2d(mMBranchEdge.getSourceInclination().getX(), mMBranchEdge.getSourceInclination().getY());
            pnt2dArray[2] = new Pnt2d(mMBranchEdge.getTargetInclination().getX(), mMBranchEdge.getTargetInclination().getY());
            pnt2dArray[3] = pnt2dArray2[1];
            this.b = new GCurve(pnt2dArray[0].x, pnt2dArray[0].y, pnt2dArray[1].x, pnt2dArray[1].y, pnt2dArray[2].x, pnt2dArray[2].y, pnt2dArray[3].x, pnt2dArray[3].y);
            n = 1;
            this.b.setType(n |= 0x100);
            this.b.setRimWidth(MMStyleSupport.getLineWidthWithAuto((DiagramElement)mMBranchEdge));
            this.b.setModel((Object)this.getModel());
            this.b.setRimmedPick(true);
            this.b.setSelectable(true);
            this.b.setPickable(true);
            this.b.addNodeSelectionListener((GNodeSelectionListener)this);
        }
        if (this.d == null) {
            n = MMStyleSupport.getLineWidthWithAuto((DiagramElement)mMBranchEdge);
            boolean bl = false;
            pnt2dArray[0] = pnt2dArray2[0];
            pnt2dArray[1] = new Pnt2d(mMBranchEdge.getSourceInclination().getX(), mMBranchEdge.getSourceInclination().getY());
            pnt2dArray[2] = new Pnt2d(mMBranchEdge.getTargetInclination().getX(), mMBranchEdge.getTargetInclination().getY());
            pnt2dArray[3] = pnt2dArray2[1];
            this.d = new GSharpCurve(pnt2dArray[0].x, pnt2dArray[0].y, pnt2dArray[1].x, pnt2dArray[1].y, pnt2dArray[2].x, pnt2dArray[2].y, pnt2dArray[3].x, pnt2dArray[3].y, pnt2dArray[0].x + (double)n, pnt2dArray[0].y, pnt2dArray[1].x + (double)n, pnt2dArray[1].y, pnt2dArray[2].x + (double)bl, pnt2dArray[2].y, pnt2dArray[3].x, pnt2dArray[3].y);
            int n2 = 1;
            this.d.setType(n2 |= 0x100);
            this.d.setRimWidth(MMStyleSupport.getLineWidthWithAuto((DiagramElement)mMBranchEdge));
            this.d.setModel((Object)this.getModel());
            this.d.setRimmedPick(true);
            this.d.setSelectable(true);
            this.d.setPickable(true);
            this.d.setFilled(true);
            this.d.addNodeSelectionListener((GNodeSelectionListener)this);
            this.d.setStroke(new BasicStroke(0.0f, 2, 0, 10.0f, null, 0.0f));
        }
        if (this.a != null) {
            this.removeNode((GNode)this.a);
            this.removeNodeSelectionListener((GNodeSelectionListener)this.a);
        }
        if (MMStyleSupport.getShapeWithAuto((DiagramElement)mMBranchEdge).equals("linear")) {
            this.a = this.c;
        } else if (MMStyleSupport.getShapeWithAuto((DiagramElement)mMBranchEdge).equals("bezier")) {
            this.a = this.b;
        } else if (MMStyleSupport.getShapeWithAuto((DiagramElement)mMBranchEdge).equals("sharpBezier") || MMStyleSupport.getShapeWithAuto((DiagramElement)mMBranchEdge).equals("sharpLinear")) {
            this.a = this.d;
        }
        this.addNode((GNode)this.a, true);
        this.addNodeSelectionListener((GNodeSelectionListener)this.a);
        this.a.addNodeSelectionListener((GNodeSelectionListener)this);
        this.setSelectionType((byte)2);
        this.updateColor();
        this.updateSelectionType();
    }

    protected int getNodeShift(MMBranchEdge mMBranchEdge) {
        if (mMBranchEdge.getParent().isTop()) {
            return 0;
        }
        return -this.getRealWidth(mMBranchEdge) / 2 + 1;
    }

    public int getRealWidth(MMBranchEdge mMBranchEdge) {
        int n = MMStyleSupport.getLineWidthWithAuto((DiagramElement)mMBranchEdge);
        return n < 1 ? 1 : n;
    }

    public void updateLineTypeAndArrow() {
        MMBranchEdge mMBranchEdge = (MMBranchEdge)this.getModel();
        this.c.setType(0, MMStyleSupport.getLineStartArrowInt((DiagramElement)mMBranchEdge));
        this.c.setType(1, MMStyleSupport.getLineEndArrowInt((DiagramElement)mMBranchEdge));
    }

    public void updateColor() {
        MMBranchEdge mMBranchEdge = (MMBranchEdge)this.getModel();
        this.a.setKnobColorNo((byte)2);
        this.a.setColorNo((byte)2);
        this.a.setShadowColorNo((byte)7);
        this.a.setBackgroundColor(MMStyleSupport.getLineColorWithAuto((DiagramElement)mMBranchEdge));
        this.a.setForegroundColor(MMStyleSupport.getLineColorWithAuto((DiagramElement)mMBranchEdge));
    }

    public void updateSelectionType() {
        this.a.setSelectionType((byte)3);
    }

    public void updateDepth() {
        int n = this.getDepth();
        this.a.setDepth(n - 1);
    }

    public boolean intersect(Rectangle2d rectangle2d) {
        if (rectangle2d.isEmpty()) {
            return true;
        }
        if (this.a == null) {
            return false;
        }
        return this.a.intersect(rectangle2d);
    }

    public GNode createShapeMovingTogether() {
        GPolyline gPolyline = new GPolyline();
        gPolyline.setColorNo((byte)4);
        gPolyline.setBackgroundNo((byte)0);
        gPolyline.setRimWidth(2);
        return gPolyline;
    }
}

