/*
 * Decompiled with CFR 0.152.
 */
package net.astah.ocl.uml.delegate;

import java.util.Map;
import net.astah.ocl.uml.delegate.a;
import net.astah.ocl.uml.delegate.b;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.common.internal.delegate.OCLDelegateException;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.uml.OCL;
import org.eclipse.ocl.uml.UMLEnvironmentFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class OCLValidationDelegate
implements EValidator.ValidationDelegate {
    private static final Logger b = LoggerFactory.getLogger(OCLValidationDelegate.class);
    public static final String OCL_DELEGATE_URI = "http://astah.net/1.0.0/UML/OCL";
    static final URI a = URI.createURI((String)"pathmap://UML_METAMODELS/UML.metamodel.uml");
    public static final OCLValidationDelegate INSTANCE = new OCLValidationDelegate();

    public boolean validate(EClass eClass, EObject eObject, Map<Object, Object> map, EOperation eOperation, String string) {
        b.debug("Validating OCL invariant {} to {}", (Object)UML2Util.getMessageSubstitution(map, (Object)eOperation), (Object)UML2Util.getMessageSubstitution(map, (Object)eObject));
        String string2 = eOperation.getName();
        return this.doValidate(eClass, eObject, map, string2, string);
    }

    public boolean validate(EClass eClass, EObject eObject, Map<Object, Object> map, String string, String string2) {
        return this.doValidate(eClass, eObject, map, string, string2);
    }

    public boolean validate(EDataType eDataType, Object object, Map<Object, Object> map, String string, String string2) {
        throw new UnsupportedOperationException("OCL(UML) doesn't support EDataType");
    }

    protected boolean doValidate(EClass eClass, EObject eObject, Map<Object, Object> map, String string, String string2) {
        Classifier classifier = this.getClassifier(eClass, eObject);
        if (classifier != null) {
            Constraint constraint = classifier.getOwnedRule(string);
            ResourceSet resourceSet = this.a(eObject);
            if (constraint != null) {
                OCL oCL = net.astah.ocl.uml.delegate.a.a(resourceSet).a();
                org.eclipse.ocl.uml.OCLExpression oCLExpression = this.getQuery(oCL, map, constraint);
                if (oCLExpression != null) {
                    return this.check(oCL, map, eObject, constraint, oCLExpression);
                }
            } else if (string2 != null) {
                b.warn("Immediate expression is not supported: {}", (Object)string2);
            }
        }
        return true;
    }

    protected Classifier getClassifier(EClass eClass, EObject eObject) {
        if (eClass.getEPackage() == UMLPackage.eINSTANCE) {
            URI uRI;
            EObject eObject2;
            ResourceSet resourceSet;
            Resource resource = eObject.eResource();
            if (resource != null && (resourceSet = resource.getResourceSet()) != null && (eObject2 = resourceSet.getEObject(uRI = a.appendFragment(eClass.getName()), true)) instanceof Classifier) {
                return (Classifier)eObject2;
            }
            return null;
        }
        return UMLUtil.getStereotype((EObject)eObject);
    }

    protected org.eclipse.ocl.uml.OCLExpression getQuery(OCL oCL, Map<Object, Object> map, Constraint constraint) {
        ValueSpecification valueSpecification = constraint.getSpecification();
        if (valueSpecification instanceof OpaqueExpression) {
            OpaqueExpression opaqueExpression = (OpaqueExpression)valueSpecification;
            return net.astah.ocl.uml.delegate.b.a(opaqueExpression).a(oCL, map);
        }
        return null;
    }

    protected boolean check(OCL oCL, Map<Object, Object> map, Object object, Constraint constraint, org.eclipse.ocl.uml.OCLExpression oCLExpression) {
        b.trace("Evaluating OCL query {} to {}", (Object)oCLExpression, (Object)UML2Util.getMessageSubstitution(map, (Object)object));
        OCLStandardLibrary oCLStandardLibrary = oCL.getEnvironment().getOCLStandardLibrary();
        if (oCLExpression.getType() != oCLStandardLibrary.getBoolean()) {
            String string = NLS.bind((String)OCLMessages.ValidationConstraintIsNotBoolean_ERROR_, (Object)UML2Util.getMessageSubstitution(map, (Object)constraint));
            b.warn(string);
            throw new OCLDelegateException(string);
        }
        Object object2 = oCL.evaluate(object, (OCLExpression)oCLExpression);
        if (oCL.isInvalid(object2)) {
            String string = NLS.bind((String)OCLMessages.ValidationResultIsInvalid_ERROR_, (Object)UML2Util.getMessageSubstitution(map, (Object)constraint));
            b.warn(string);
            throw new OCLDelegateException(string);
        }
        if (object2 == null) {
            String string = NLS.bind((String)OCLMessages.ValidationResultIsNull_ERROR_, (Object)UML2Util.getMessageSubstitution(map, (Object)constraint));
            b.warn(string);
            throw new OCLDelegateException(string);
        }
        if (!(object2 instanceof Boolean)) {
            String string = NLS.bind((String)OCLMessages.ValidationResultIsNotBoolean_ERROR_, (Object)UML2Util.getMessageSubstitution(map, (Object)constraint));
            b.warn(string);
            throw new OCLDelegateException(string);
        }
        return Boolean.TRUE.equals(object2);
    }

    private ResourceSet a(EObject eObject) {
        Resource resource = eObject.eResource();
        return resource != null ? resource.getResourceSet() : null;
    }

    static {
        Environment.Registry.INSTANCE.registerEnvironment((Environment)new UMLEnvironmentFactory().createEnvironment());
        EValidator.ValidationDelegate.Registry.INSTANCE.put((Object)OCL_DELEGATE_URI, (Object)INSTANCE);
    }
}

