/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.validation.util;

import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.ValidationEvent;

public class ConstraintStatusSet
extends AbstractSet<IConstraintStatus> {
    protected final Multimap<Object, IConstraintStatus> statusMap = LinkedHashMultimap.create();

    @Override
    public Iterator<IConstraintStatus> iterator() {
        return this.statusMap.values().iterator();
    }

    @Override
    public int size() {
        return this.statusMap.size();
    }

    @Override
    public boolean add(IConstraintStatus iConstraintStatus) {
        return this.statusMap.put((Object)iConstraintStatus.getTarget(), (Object)iConstraintStatus);
    }

    @Override
    public boolean remove(Object object) {
        if (object instanceof IConstraintStatus) {
            IConstraintStatus iConstraintStatus = (IConstraintStatus)object;
            return this.statusMap.remove((Object)iConstraintStatus.getTarget(), (Object)iConstraintStatus);
        }
        return false;
    }

    @Override
    public void clear() {
        this.statusMap.clear();
    }

    public boolean mergeValidationResults(ValidationEvent validationEvent) {
        Collection collection = validationEvent.getValidationTargets();
        List list = validationEvent.getValidationResults();
        if (validationEvent.getEvaluationMode() == EvaluationMode.BATCH) {
            return this.mergeBatchResults(collection, list);
        }
        if (validationEvent.getEvaluationMode() == EvaluationMode.LIVE) {
            return this.mergeLiveResults(collection, list);
        }
        return false;
    }

    public boolean mergeBatchResults(Collection<?> collection, Collection<IConstraintStatus> collection2) {
        boolean bl = this.removeBatchObsoletes(collection);
        return Iterables.addAll((Collection)this, this.severityFilter(collection2, 8)) | bl;
    }

    public boolean mergeLiveResults(Collection<?> collection, Collection<IConstraintStatus> collection2) {
        boolean bl = this.removeLiveObsoletes(collection);
        return Iterables.addAll((Collection)this, this.severityFilter(collection2, 4)) | bl;
    }

    protected boolean removeBatchObsoletes(Collection<?> collection) {
        boolean bl = false;
        Iterator iterator = this.statusMap.values().iterator();
        block0: while (iterator.hasNext()) {
            IConstraintStatus iConstraintStatus = (IConstraintStatus)iterator.next();
            EObject eObject = iConstraintStatus.getTarget();
            for (int n = 0; n < 100000 && eObject != null; eObject = eObject.eContainer(), ++n) {
                if (!collection.contains(eObject)) continue;
                iterator.remove();
                bl = true;
                continue block0;
            }
        }
        return bl;
    }

    protected boolean removeLiveObsoletes(Collection<?> collection) {
        boolean bl = false;
        for (Object obj : collection) {
            EObject eObject;
            Notification notification;
            Object object;
            if (!(obj instanceof Notification) || !((object = (notification = (Notification)obj).getNotifier()) instanceof EObject) || notification.isTouch() || !this.statusMap.containsKey((Object)(eObject = (EObject)object))) continue;
            Collection collection2 = this.statusMap.get((Object)eObject);
            bl |= collection2.removeIf(iConstraintStatus -> this.matchLiveStatus((IConstraintStatus)iConstraintStatus, notification));
        }
        return bl;
    }

    protected boolean matchLiveStatus(IConstraintStatus iConstraintStatus, Notification notification) {
        IConstraintDescriptor iConstraintDescriptor = iConstraintStatus.getConstraint().getDescriptor();
        return iConstraintDescriptor.isLive() && iConstraintDescriptor.targetsEvent(notification);
    }

    protected <T extends IConstraintStatus> Iterable<T> severityFilter(Iterable<T> iterable, int n) {
        return Iterables.filter(iterable, iConstraintStatus -> iConstraintStatus.getSeverity() < n);
    }
}

