/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.validation.java.impl;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.astah.emf.validation.java.JavaConstraintMessages;
import net.astah.emf.validation.java.annotation.Constraint;
import net.astah.emf.validation.java.annotation.ConstraintTarget;
import net.astah.emf.validation.java.annotation.EvaluationModeType;
import net.astah.emf.validation.java.impl.a;
import net.astah.emf.validation.java.impl.b;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.model.ConstraintSeverity;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public abstract class JavaConstraintProvider {
    private static final Logger a = LoggerFactory.getLogger(JavaConstraintProvider.class);

    public void createConstraints(Collection<IModelConstraint> collection, Set<Category> set, Object object) {
        a.debug("Creating constraints of {}", object.getClass());
        Category[] categoryArray = set.toArray(new Category[set.size()]);
        for (Method method : object.getClass().getMethods()) {
            if (!this.isConstraintMethod(method)) continue;
            a a2 = new a(this, method);
            a.debug("Registering the constraint descriptor: {}", (Object)a2);
            for (Category category : categoryArray) {
                a2.addCategory(category);
            }
            collection.add((IModelConstraint)new b(a2, object));
        }
    }

    protected abstract String getPluginId();

    protected abstract List<EPackage> getEPackages();

    protected abstract String getString(String var1);

    protected boolean isConstraintMethod(Method method) {
        if (!method.isAnnotationPresent(Constraint.class)) {
            return false;
        }
        if (!IStatus.class.isAssignableFrom(method.getReturnType())) {
            return false;
        }
        for (Class<?> clazz : method.getParameterTypes()) {
            if (!clazz.isPrimitive()) continue;
            return false;
        }
        return true;
    }

    protected IStatus validate(a a2, Object object, Object[] objectArray) {
        try {
            Method method = a2.b();
            assert (this.isConstraintMethod(method)) : "must be constraint method";
            a.debug("Invoking the constraint method: {}", (Object)method);
            return (IStatus)method.invoke(object, objectArray);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            throw new WrappedException(exception.getMessage(), exception);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new WrappedException(throwable.getMessage(), (Exception)throwable);
        }
    }

    protected String resolveName(Method method) {
        return this.a(method, constraint -> Strings.emptyToNull((String)constraint.name()), "");
    }

    protected String resolveId(Method method) {
        return this.a(method, constraint -> Strings.emptyToNull((String)constraint.id()), "");
    }

    protected String resolveDescription(Method method) {
        return this.a(method, constraint -> Strings.emptyToNull((String)constraint.description()), "");
    }

    protected ConstraintSeverity resolveSeverity(Method method) {
        return this.a(method, constraint -> JavaConstraintProvider.a(ConstraintSeverity.NULL, constraint.severity()), ConstraintSeverity.NULL);
    }

    protected Integer resolveStatusCode(Method method) {
        return this.a(method, constraint -> constraint.statusCode(), 0);
    }

    protected EvaluationModeType resolveEvaluationMode(Method method) {
        return this.a(method, constraint -> JavaConstraintProvider.a(EvaluationModeType.NULL, constraint.evaluationMode()), EvaluationModeType.NULL);
    }

    protected String resolveMessage(Method method) {
        String string = this.a(method, constraint -> Strings.emptyToNull((String)constraint.message()), "");
        if (string.startsWith("%")) {
            return this.getString(string.substring(1));
        }
        return string;
    }

    protected EClass resolveEClass(Method method, ConstraintTarget constraintTarget) {
        int n = constraintTarget.eClass();
        String string = constraintTarget.className();
        if (n >= 0) {
            return this.resolveEClassById(n);
        }
        if (string.length() > 0) {
            return this.resolveEClassByName(string);
        }
        Class<?> clazz = this.resolveTargetType(method, constraintTarget);
        if (clazz != null) {
            return this.resolveEClassByType(clazz);
        }
        return null;
    }

    protected EClass resolveEClassById(int n) {
        EClassifier eClassifier;
        List<EPackage> list = this.getEPackages();
        Assert.isTrue((list.size() == 1 ? 1 : 0) != 0, (String)JavaConstraintMessages.java_provider_package_many);
        EPackage ePackage = list.get(0);
        EList eList = ePackage.getEClassifiers();
        if (n >= 0 && n < eList.size() && (eClassifier = (EClassifier)eList.get(n)) instanceof EClass) {
            return (EClass)eClassifier;
        }
        throw new IllegalArgumentException(NLS.bind((String)JavaConstraintMessages.java_provider_eclass_id_not_exist, (Object)n, (Object)ePackage.getNsURI()));
    }

    protected EClass resolveEClassByName(String string) {
        List<EPackage> list = this.getEPackages();
        for (EPackage ePackage : list) {
            EClassifier eClassifier = ePackage.getEClassifier(string);
            if (!(eClassifier instanceof EClass)) continue;
            return (EClass)eClassifier;
        }
        throw new IllegalArgumentException(NLS.bind((String)JavaConstraintMessages.java_provider_eclass_name_not_exist, (Object)string, JavaConstraintProvider.a(list)));
    }

    protected EClass resolveEClassByType(Class<?> clazz) {
        List<EPackage> list = this.getEPackages();
        for (EPackage ePackage2 : list) {
            for (EClassifier eClassifier : ePackage2.getEClassifiers()) {
                if (!(eClassifier instanceof EClass) || clazz != eClassifier.getInstanceClass()) continue;
                return (EClass)eClassifier;
            }
        }
        throw new IllegalArgumentException(NLS.bind((String)JavaConstraintMessages.java_provider_eclass_not_exist, clazz, list.stream().map(ePackage -> "{" + ePackage.getNsURI() + "}").collect(Collectors.toList())));
    }

    protected Class<?> resolveTargetType(Method method, ConstraintTarget constraintTarget) {
        Class<?> clazz = constraintTarget.type();
        if (clazz != Object.class) {
            return clazz;
        }
        for (Class<?> clazz2 : method.getParameterTypes()) {
            if (!EObject.class.isAssignableFrom(clazz2)) continue;
            return clazz2;
        }
        return null;
    }

    private <R> R a(Method method, Function<Constraint, R> function, R r) {
        return this.a(method, Constraint.class, function, r);
    }

    private <T extends Annotation, R> R a(Method method, Class<T> clazz, Function<T, R> function, R r) {
        R r2;
        Object object;
        Object object2;
        Object object3 = method.getAnnotation(clazz);
        if (object3 != null && (object2 = function.apply(object3)) != null) {
            return object2;
        }
        object3 = method.getDeclaringClass();
        object2 = ((Class)object3).getAnnotation(clazz);
        if (object2 != null && (object = function.apply(object2)) != null) {
            return object;
        }
        object2 = ((Class)object3).getPackage();
        object = ((Package)object2).getAnnotation(clazz);
        if (object != null && (r2 = function.apply(object)) != null) {
            return r2;
        }
        return r;
    }

    private static <T> T a(T t, T t2) {
        return Objects.equal(t, t2) ? null : (T)t2;
    }

    private static List<String> a(List<EPackage> list) {
        return list.stream().map(ePackage -> "{" + ePackage.getNsURI() + "}").collect(Collectors.toList());
    }
}

