/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.validation.java;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.astah.emf.validation.java.AbstractJavaConstraintProvider;
import net.astah.emf.validation.java.JavaConstraintMessages;
import net.astah.emf.validation.java.impl.JavaConstraintProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.validation.internal.EMFModelValidationPlugin;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.model.CategoryManager;
import org.eclipse.emf.validation.service.ConstraintExistsException;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlJavaConstraintProvider
extends AbstractJavaConstraintProvider {
    private static Logger b = LoggerFactory.getLogger(XmlJavaConstraintProvider.class);
    private static final String c = "category";
    private static final String d = "path";
    final JavaConstraintProvider a = this.createDelegate();
    private final List<EPackage> e = new ArrayList<EPackage>();
    private Bundle f;

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) throws CoreException {
        super.setInitializationData(iConfigurationElement, string, object);
        this.f = this.getBundle(iConfigurationElement);
        Set<Category> set = this.getCategories(iConfigurationElement);
        for (String string2 : this.getNamespaceUris()) {
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(string2);
            if (ePackage != null) {
                this.e.add(ePackage);
                continue;
            }
            b.warn(JavaConstraintMessages.java_provider_package_not_exist, (Object)string2);
        }
        try {
            this.createConstraints(set, (Object)this);
        }
        catch (ConstraintExistsException constraintExistsException) {
            throw new CoreException((IStatus)new Status(4, EMFModelValidationPlugin.getPluginId(), constraintExistsException.getMessage(), (Throwable)constraintExistsException));
        }
    }

    protected Set<Category> getCategories(IConfigurationElement iConfigurationElement) {
        HashSet<Category> hashSet = new HashSet<Category>();
        for (IConfigurationElement iConfigurationElement2 : iConfigurationElement.getChildren(c)) {
            String string = iConfigurationElement2.getAttribute(d);
            if (Strings.isNullOrEmpty((String)string)) continue;
            hashSet.add(CategoryManager.getInstance().getCategory(string));
        }
        return hashSet;
    }

    @Override
    protected JavaConstraintProvider createDelegate() {
        return new Delegate();
    }

    protected Bundle getBundle(IConfigurationElement iConfigurationElement) {
        IContributor iContributor = iConfigurationElement.getContributor();
        if (iContributor instanceof RegistryContributor) {
            long l = Long.parseLong(((RegistryContributor)iContributor).getActualId());
            return FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext().getBundle(l);
        }
        return Platform.getBundle((String)iContributor.getName());
    }

    protected List<EPackage> getEPackages() {
        return this.e;
    }

    protected String getPluginId() {
        return this.f.getSymbolicName();
    }

    protected String getString(String string) {
        return Platform.getResourceString((Bundle)this.f, (String)string);
    }

    protected class Delegate
    extends JavaConstraintProvider {
        protected Delegate() {
        }

        @Override
        protected List<EPackage> getEPackages() {
            return XmlJavaConstraintProvider.this.getEPackages();
        }

        @Override
        protected String getPluginId() {
            return XmlJavaConstraintProvider.this.getPluginId();
        }

        @Override
        protected String getString(String string) {
            return XmlJavaConstraintProvider.this.getString(string);
        }
    }
}

