/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.validation;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import net.astah.emf.edit.job.TransactionalJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.IValidator;

public class ValidationJob
extends TransactionalJob {
    protected final IValidator<EObject> validator;
    protected final Iterable<? extends EObject> eObjects;
    protected IStatus validationResult;

    public ValidationJob(TransactionalEditingDomain transactionalEditingDomain, IValidator<EObject> iValidator, Iterable<? extends EObject> iterable) {
        super(transactionalEditingDomain, "Model Validation Job");
        this.validator = Objects.requireNonNull(iValidator, "validator");
        this.eObjects = Objects.requireNonNull(iterable, "eObjects");
    }

    public IValidator<EObject> getValidator() {
        return this.validator;
    }

    public Iterable<? extends EObject> geteObjects() {
        return this.eObjects;
    }

    public IStatus getValidationResult() {
        return this.validationResult;
    }

    protected IStatus run(IProgressMonitor iProgressMonitor) {
        try {
            this.runExclusive(() -> this.validate(iProgressMonitor));
            return Status.OK_STATUS;
        }
        catch (InterruptedException | CancellationException exception) {
            return Status.CANCEL_STATUS;
        }
    }

    protected void validate(IProgressMonitor iProgressMonitor) {
        Collection<? extends EObject> collection = this.a();
        if (this.validator instanceof IBatchValidator) {
            this.validationResult = ((IBatchValidator)this.validator).validate(collection, iProgressMonitor);
        } else {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor);
            subMonitor.beginTask(this.getName(), 1);
            this.validationResult = this.validator.validate(collection);
            subMonitor.done();
        }
    }

    private Collection<? extends EObject> a() {
        if (this.eObjects instanceof Collection) {
            return (Collection)this.eObjects;
        }
        return Lists.newArrayList(this.eObjects);
    }
}

