/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.validation;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.astah.common.eclipse.DOMConfigurationElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.validation.internal.modeled.ModeledConstraintProvider;
import org.eclipse.emf.validation.internal.modeled.model.validation.Category;
import org.eclipse.emf.validation.internal.modeled.model.validation.ConstraintProvider;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.IModelConstraintProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class ModeledExtensionConstraintProvider<CP extends IModelConstraintProvider & IExecutableExtension>
extends ModeledConstraintProvider {
    private static Logger a = LoggerFactory.getLogger(ModeledExtensionConstraintProvider.class);
    protected final CP delegate = this.createConstraintProvider();

    public void setConstraintProviderModel(ConstraintProvider constraintProvider) {
        super.setConstraintProviderModel(constraintProvider);
        DOMConfigurationElement dOMConfigurationElement = this.createConfigurationElement();
        try {
            ((IExecutableExtension)this.delegate).setInitializationData((IConfigurationElement)dOMConfigurationElement, "", null);
        }
        catch (CoreException coreException) {
            a.error("Failed to initialize constraints", (Throwable)coreException);
        }
    }

    public Collection<IModelConstraint> getLiveConstraints(Notification notification, Collection<IModelConstraint> collection) {
        return this.delegate.getLiveConstraints(notification, collection);
    }

    public Collection<IModelConstraint> getBatchConstraints(EObject eObject, Collection<IModelConstraint> collection) {
        return this.delegate.getBatchConstraints(eObject, collection);
    }

    protected abstract CP createConstraintProvider();

    protected String getNamespaceURI() {
        return null;
    }

    protected Collection<EPackage> getEPackages() {
        return Collections.emptySet();
    }

    protected Document createConfiguration() {
        ConstraintProvider constraintProvider = this.getModel();
        String string = constraintProvider.getPluginId();
        Document document = this.createDocument();
        Element element = document.createElementNS(string, "constraintProvider");
        document.appendChild(element);
        String string2 = this.getNamespaceURI();
        if (!Strings.isNullOrEmpty((String)string2)) {
            element.setAttribute("namespaceUri", string2);
        }
        for (EPackage ePackage : this.getEPackages()) {
            Element element2 = document.createElement("package");
            element2.setAttribute("namespaceUri", ePackage.getNsURI());
            element.appendChild(element2);
        }
        for (EPackage ePackage : constraintProvider.getConstraints()) {
            for (Category category : ePackage.getCategories()) {
                Element element3 = document.createElement("category");
                element3.setAttribute("path", category.getPath());
                element.appendChild(element3);
            }
        }
        return document;
    }

    protected Document createDocument() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            return documentBuilderFactory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalStateException(parserConfigurationException);
        }
    }

    protected DOMConfigurationElement createConfigurationElement() {
        Document document = this.createConfiguration();
        return new DOMConfigurationElement(document.getDocumentElement());
    }
}

