/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.mindmap.edit.layout;

import java.awt.Color;
import java.awt.Font;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.golf.model.IStyleMapOwner;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.golf.widget.CColor;
import net.astah.golf.widget.GolfWidgetFactory;
import net.astah.jmodel.StyleSupport;
import net.astah.jomt.jutil.FontManager;
import net.astah.jomt.jutil.JFont;
import net.astah.jomt.jutil.JomtFontUtilities;
import net.astah.notation.mindmap.MMBoundaryShape;
import net.astah.notation.mindmap.MMBranchEdge;
import net.astah.notation.mindmap.MMDiagram;
import net.astah.notation.mindmap.MMLinkEdge;
import net.astah.notation.mindmap.MMTopicShape;
import net.astah.notation.mindmap.edit.layout.MMStyleMapOwner;
import net.astah.notation.mindmap.edit.layout.MindMapUtilties;
import org.eclipse.emf.common.util.EList;

public class MMStyleSupport
extends StyleSupport {
    public static final String MODEL_NAME_TOPIC = "topic.";
    public static final String MODEL_NAME_EDGE = "edge.";
    public static final String MODEL_NAME_LINK = "link.";
    public static final String MODEL_NAME_BOUNDARY = "boundary.";
    public static final String STYLE_FILL_COLOR = "fill.color";
    public static final String STYLE_FILL_PATTERN = "fill.pattern";
    public static final String STYLE_FILL = "fill";
    public static final String STYLE_FONT = "font";
    public static final String STYLE_MERGEIN_TOP = "margin.top";
    public static final String STYLE_MERGEIN_BOTTOM = "margin.bottom";
    public static final String STYLE_MERGEIN_LEFT = "margin.left";
    public static final String STYLE_MERGEIN_RIGHT = "margin.right";
    public static final String STYLE_PREFERRED_WIDTH = "preferred_width";
    public static final String STYLE_SUBTOPIC_ALIGNMENT = "subtopic.alignment";
    public static final String STYLE_SUBTOPIC_GROWTH_DIR = "subtopic.growth_direction";
    public static final String CONNECTION_TYPE_SPREAD = "spread";
    public static final String CONNECTION_TYPE_BIND = "bind";
    public static final String GROWTH_DIR_LEFT_AND_RIGHT = "left_and_right";
    public static final String GROWTH_DIR_RIGHT = "right";
    public static final String GROWTH_DIR_TOP = "top";
    public static final String GROWTH_DIR_BOTTOM = "bottom";
    public static final String GROWTH_DIR_ONE = "none";
    public static final String IMAGE_STYLE_TOP = "top";
    public static final String IMAGE_STYLE_BOTTOM = "bottom";
    public static final String IMAGE_STYLE_LEFT = "left";
    public static final String IMAGE_STYLE_RIGHT = "right";
    public static final String TEXT_VERTICAL_ALIGNMENT_TOP = "top";
    public static final String TEXT_VERTICAL_ALIGNMENT_CENTER = "center";
    public static final String TEXT_VERTICAL_ALIGNMENT_BOTTOM = "bottom";
    public static final String TEXT_HORIZONTAL_ALIGNMENT_LEFT = "left";
    public static final String TEXT_HORIZONTAL_ALIGNMENT_CENTER = "center";
    public static final String TEXT_HORIZONTAL_ALIGNMENT_RIGHT = "right";
    public static final String FILL_ON = "true";
    public static final String FILL_OFF = "false";
    public static final String SUBTOPIC_ALIGNMENT_VER = "vertical";
    public static final String SUBTOPIC_ALIGNMENT_CURVED = "curved";
    public static final String SUBTOPIC_ALIGNMENT_ANGLED = "angled";
    public static final String SUBTOPIC_ALIGNMENT_INCLINED = "inclined";
    public static final String SUBTOPIC_ALIGNMENT_DECLINED = "declined";
    public static final String SUBTOPIC_GROWTH_DIR_ANGLED = "up";
    public static final String SUBTOPIC_GROWTH_DIR_INCLINED = "down";
    public static final String SUBTOPIC_GROWTH_DIR_DECLINED = "center";
    public static final String STYLE_BEZIER = "bezier";
    public static final String STYLE_LINEAR = "linear";
    public static final String STYLE_SHARP_BEZIER = "sharpBezier";
    public static final String STYLE_SHARP_LINEAR = "sharpLinear";
    public static final String STYLE_CLOUD = "cloud";
    public static final String STYLE_STRAIGHT_LINE = "straightLine";
    public static final String STYLE_ROUNDED_LINE = "roundedLine";
    private static String a = "Dialog";
    private static String b = "PLAIN";
    private static int c = 12;

    public static void setLineColorInheritance(Diagram diagram, String string) {
        MMStyleSupport.setValueForMindMapWithSetChanged(diagram, "line.color.inheritance", string);
    }

    public static String getShapeWithAuto(DiagramElement diagramElement) {
        return MMStyleSupport.getValueStringWithAuto(diagramElement, "shape");
    }

    public static void setChangedForInheritColorOption(DiagramElement diagramElement) {
        if (diagramElement instanceof MMTopicShape || diagramElement instanceof MMBranchEdge) {
            if (diagramElement instanceof MMBranchEdge) {
                diagramElement = ((MMBranchEdge)diagramElement).getParent();
            }
            if (diagramElement instanceof MMTopicShape) {
                EList eList = ((MMTopicShape)diagramElement).getChildren();
                for (MMTopicShape mMTopicShape : eList) {
                    MMBranchEdge mMBranchEdge;
                    if (MMStyleSupport.getLineColor((DiagramElement)mMTopicShape) == null) {
                        // empty if block
                    }
                    if (MMStyleSupport.getLineColor((DiagramElement)(mMBranchEdge = mMTopicShape.getBranch())) != null) continue;
                }
            }
        }
    }

    public static CColor getLineColor(DiagramElement diagramElement) {
        return MMStyleSupport.getValueCColor(diagramElement, "line.color");
    }

    public static CColor getLineColorWithAuto(DiagramElement diagramElement) {
        return MMStyleSupport.c(diagramElement, "line.color");
    }

    public static double getSourceInclinationRatioWithAuto(DiagramElement diagramElement) {
        return MMStyleSupport.getValueDoubleWithAuto(diagramElement, "control_point1.ratio");
    }

    public static double getTargetInclinationRatioWithAuto(DiagramElement diagramElement) {
        return MMStyleSupport.getValueDoubleWithAuto(diagramElement, "control_point2.ratio");
    }

    public static CColor getBodyColorWithAuto(DiagramElement diagramElement) {
        return MMStyleSupport.c(diagramElement, STYLE_FILL_COLOR);
    }

    public static double getSpaceHorizontalWithAuto(DiagramElement diagramElement) {
        return MMStyleSupport.getValueDoubleWithAuto(diagramElement, "space.horizontal");
    }

    public static double getIconPaddingWithAuto(DiagramElement diagramElement) {
        return MMStyleSupport.getValueDoubleWithAuto(diagramElement, "icon.padding");
    }

    public static double getSpaceVerticalWithAuto(DiagramElement diagramElement) {
        return MMStyleSupport.getValueDoubleWithAuto(diagramElement, "space.vertical");
    }

    public static CColor getFontColorWithAuto(DiagramElement diagramElement) {
        return MMStyleSupport.c(diagramElement, "font.color");
    }

    public static String getConnectionTypeWithAuto(DiagramElement diagramElement) {
        return MMStyleSupport.getValueStringWithAuto(diagramElement, "connection_type");
    }

    public static String getGrowthDirectionWithAuto(DiagramElement diagramElement) {
        boolean bl = RuntimeGlobal.sysProp.getBooleanWithDefault("mindmap.add_topic_same_side");
        if (bl) {
            return "right";
        }
        return MMStyleSupport.getValueStringWithAuto(diagramElement, "growth_direction");
    }

    public static String getImageStyleWithAuto(DiagramElement diagramElement) {
        return MMStyleSupport.getValueStringWithAuto(diagramElement, "image.style");
    }

    public static String getTextVerticalAlignmentWithAuto(DiagramElement diagramElement) {
        return MMStyleSupport.getValueStringWithAuto(diagramElement, "text.vertical.alignment");
    }

    public static String getTextHorizontalAlignmentWithAuto(DiagramElement diagramElement) {
        return MMStyleSupport.getValueStringWithAuto(diagramElement, "text.horizontal.alignment");
    }

    public static void setValueForMindMapWithSetChanged(Diagram diagram, String string, String string2) {
        MMStyleSupport.addStyleMap((DiagramElement)diagram, (String)string, (String)string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Color a(DiagramElement diagramElement, String string) {
        int n;
        if (diagramElement.getOwningElement() == null) {
            return null;
        }
        int n2 = MindMapUtilties.getModelTemplateSize(diagramElement);
        String string2 = null;
        if (diagramElement instanceof MMTopicShape) {
            n = ((MMTopicShape)diagramElement).getOutlineLevel();
            if (n < n2 || n == n2) {
                string2 = MODEL_NAME_TOPIC + string + "." + n;
            } else {
                CColor cColor = MMStyleSupport.getValueCColor(diagramElement, string);
                if (cColor != null) return cColor.transferToAWTColor();
                string2 = MODEL_NAME_TOPIC + string + "." + n2;
            }
        } else if (diagramElement instanceof MMBranchEdge) {
            n = ((MMBranchEdge)diagramElement).getChild().getOutlineLevel();
            if (n < n2 || n == n2) {
                string2 = MODEL_NAME_EDGE + string + "." + n;
            } else {
                CColor cColor = MMStyleSupport.getValueCColor(diagramElement, string);
                if (cColor != null) return cColor.transferToAWTColor();
                string2 = MODEL_NAME_EDGE + string + "." + n2;
            }
        } else if (diagramElement instanceof MMBoundaryShape) {
            string2 = MODEL_NAME_BOUNDARY + string;
        } else if (diagramElement instanceof MMLinkEdge) {
            string2 = MODEL_NAME_LINK + string;
        }
        String string3 = MMStyleMapOwner.getStyleMapFromKey(diagramElement.getOwningElement(), string2);
        if (string3 != null) return MMStyleSupport.getColor((String)string3);
        return null;
    }

    private static Color b(DiagramElement diagramElement, String string) {
        String string2 = MindMapUtilties.getMindMapProperty().getSelectedTemplate() + "." + MMStyleMapOwner.getStyleKeyForDiagram(diagramElement, string);
        String string3 = MindMapUtilties.getMindMapProperty().getDefaultString(string2);
        if (string3 == null) {
            return null;
        }
        return MMStyleSupport.getColor((String)string3);
    }

    public static boolean isShowBoundary(MMTopicShape mMTopicShape) {
        if (mMTopicShape.getBoundary() != null) {
            return mMTopicShape.getBoundary().isVisible();
        }
        return false;
    }

    public static void showBoundary(MMTopicShape mMTopicShape, boolean bl) {
        if (mMTopicShape.getBoundary() != null) {
            mMTopicShape.getBoundary().setVisible(bl);
        }
    }

    private static CColor c(DiagramElement diagramElement, String string) {
        CColor cColor = MMStyleSupport.getValueCColor(diagramElement, string);
        if (cColor == null) {
            Color color;
            if (string.equals("line.color") && (diagramElement instanceof MMTopicShape && !((MMTopicShape)diagramElement).isTop() || diagramElement instanceof MMBranchEdge)) {
                boolean bl = MMStyleSupport.getLineColorInheritance((Diagram)diagramElement.getOwningElement());
                if (!(diagramElement instanceof MMBranchEdge && ((MMBranchEdge)diagramElement).getParent().isTop() || !bl)) {
                    return MMStyleSupport.d(diagramElement, string);
                }
            }
            if ((color = MMStyleSupport.a(diagramElement, string)) == null) {
                return GolfWidgetFactory.instance().createCColor(MMStyleSupport.b(diagramElement, string));
            }
            return GolfWidgetFactory.instance().createCColor(color);
        }
        return cColor;
    }

    private static CColor d(DiagramElement diagramElement, String string) {
        MMTopicShape mMTopicShape;
        MMBranchEdge mMBranchEdge = null;
        if (diagramElement instanceof MMTopicShape) {
            mMTopicShape = (MMTopicShape)diagramElement;
            if (mMTopicShape.isTop()) {
                return MMStyleSupport.c(diagramElement, string);
            }
            mMBranchEdge = mMTopicShape.getBranch();
        } else if (diagramElement instanceof MMBranchEdge && ((MMTopicShape)(mMBranchEdge = (mMTopicShape = (MMBranchEdge)diagramElement).getParent())).isTop()) {
            return MMStyleSupport.c(diagramElement, string);
        }
        mMTopicShape = MMStyleSupport.getValueCColor(mMBranchEdge, string);
        if (mMTopicShape != null) {
            return mMTopicShape;
        }
        return MMStyleSupport.d((DiagramElement)mMBranchEdge, string);
    }

    public static void setUpEarlyMindMapTopicFont(IStyleMapOwner iStyleMapOwner) {
        iStyleMapOwner.addStyleMap("topic.font.name.0", a);
        iStyleMapOwner.addStyleMap("topic.font.style.0", b);
        iStyleMapOwner.addStyleMap("topic.font.size.0", String.valueOf(c));
        iStyleMapOwner.addStyleMap("topic.font.name.1", a);
        iStyleMapOwner.addStyleMap("topic.font.style.1", b);
        iStyleMapOwner.addStyleMap("topic.font.size.1", String.valueOf(c));
        iStyleMapOwner.addStyleMap("topic.font.name.2", a);
        iStyleMapOwner.addStyleMap("topic.font.style.2", b);
        iStyleMapOwner.addStyleMap("topic.font.size.2", String.valueOf(c));
        iStyleMapOwner.addStyleMap("use_custom_color", FILL_OFF);
        iStyleMapOwner.addStyleMap("line.color.inheritance", FILL_ON);
    }

    public static void setUpEarlyMindMapTopicFont(DiagramElement diagramElement) {
        MMStyleSupport.addStyleMap((DiagramElement)diagramElement, (String)"topic.font.name.0", (String)a);
        MMStyleSupport.addStyleMap((DiagramElement)diagramElement, (String)"topic.font.style.0", (String)b);
        MMStyleSupport.addStyleMap((DiagramElement)diagramElement, (String)"topic.font.size.0", (String)String.valueOf(c));
        MMStyleSupport.addStyleMap((DiagramElement)diagramElement, (String)"topic.font.name.1", (String)a);
        MMStyleSupport.addStyleMap((DiagramElement)diagramElement, (String)"topic.font.style.1", (String)b);
        MMStyleSupport.addStyleMap((DiagramElement)diagramElement, (String)"topic.font.size.1", (String)String.valueOf(c));
        MMStyleSupport.addStyleMap((DiagramElement)diagramElement, (String)"topic.font.name.2", (String)a);
        MMStyleSupport.addStyleMap((DiagramElement)diagramElement, (String)"topic.font.style.2", (String)b);
        MMStyleSupport.addStyleMap((DiagramElement)diagramElement, (String)"topic.font.size.2", (String)String.valueOf(c));
        MMStyleSupport.addStyleMap((DiagramElement)diagramElement, (String)"use_custom_color", (String)FILL_OFF);
        MMStyleSupport.addStyleMap((DiagramElement)diagramElement, (String)"line.color.inheritance", (String)FILL_ON);
    }

    public static Font getFont(DiagramElement diagramElement) {
        JFont jFont = MMStyleSupport.getJFontWithAuto(diagramElement);
        Font font = FontManager.getFontFromJFontWithCash((JFont)jFont);
        return font;
    }

    public static JFont getJFontWithAuto(DiagramElement diagramElement) {
        int n;
        String string;
        JFont jFont = JomtFontUtilities.getProjectJFont();
        String string2 = MMStyleSupport.getValueStringWithAuto(diagramElement, "font.name");
        if (string2 == null) {
            string2 = jFont.getFontName();
        }
        if ((string = MMStyleSupport.getValueStringWithAuto(diagramElement, "font.style")) == null) {
            string = jFont.getFontStyle();
        }
        if (MMStyleMapOwner.isBindedByUMLNotation(diagramElement)) {
            string = "PLAIN";
        }
        if ((n = MMStyleSupport.getValueIntWithAuto(diagramElement, "font.size")) == -1) {
            n = jFont.getFontSize();
        }
        boolean bl = MMStyleSupport.getValueBoolean(diagramElement, "font.underlined");
        boolean bl2 = MMStyleSupport.getValueBoolean(diagramElement, "font.struckthrough");
        return new JFont(string2, string, n, bl, bl2);
    }

    public static String getValueStringWithAuto(DiagramElement diagramElement, String string) {
        if (diagramElement == null) {
            return null;
        }
        return MMStyleMapOwner.getValueStringWithAuto(diagramElement, string);
    }

    public static boolean getValueBoolean(DiagramElement diagramElement, String string) {
        if (diagramElement == null) {
            return false;
        }
        String string2 = MMStyleMapOwner.getStyleMapFromKey(diagramElement, string);
        if (string2 == null) {
            return false;
        }
        return Boolean.valueOf(string2);
    }

    public static int getValueIntWithAuto(DiagramElement diagramElement, String string) {
        String string2 = MMStyleSupport.getValueStringWithAuto(diagramElement, string);
        if (string2 != null) {
            return Integer.valueOf(string2);
        }
        return -1;
    }

    public static int getLineWidthWithAuto(DiagramElement diagramElement) {
        return MMStyleSupport.getValueIntWithAuto(diagramElement, "line.width");
    }

    protected static double getValueDoubleWithAuto(DiagramElement diagramElement, String string) {
        String string2 = MMStyleSupport.getValueStringWithAuto(diagramElement, string);
        if (string2 != null) {
            return Double.valueOf(string2);
        }
        return -1.0;
    }

    public static boolean getLineColorInheritance(Diagram diagram) {
        return MMStyleSupport.getValueBoolean((DiagramElement)diagram, "line.color.inheritance");
    }

    public static CColor getFontColor(DiagramElement diagramElement) {
        return MMStyleSupport.getValueCColor(diagramElement, "font.color");
    }

    public static CColor getValueCColor(DiagramElement diagramElement, String string) {
        String string2 = MMStyleMapOwner.getStyleMapFromKey(diagramElement, string);
        if (string2 == null) {
            return null;
        }
        return GolfWidgetFactory.instance().createCColor(MMStyleSupport.getColor((String)string2));
    }

    public static float getBodyColorAlphaWithAuto(DiagramElement diagramElement) {
        return MMStyleSupport.getValueFloatWithAuto(diagramElement, "fill.color.alpha");
    }

    public static float getValueFloatWithAuto(DiagramElement diagramElement, String string) {
        String string2 = MMStyleSupport.getValueStringWithAuto(diagramElement, string);
        if (string2 != null) {
            return Float.valueOf(string2).floatValue();
        }
        return 1.0f;
    }

    public static CColor getBodyColor(DiagramElement diagramElement) {
        return MMStyleSupport.getValueCColor(diagramElement, STYLE_FILL_COLOR);
    }

    public static int getLineStartArrowInt(DiagramElement diagramElement) {
        String string = MMStyleSupport.getLineArrowStyle(diagramElement);
        if (string == null) {
            return 0;
        }
        if (string.equals("noarrow")) {
            return 0;
        }
        if (string.equals("endarrow")) {
            return 0;
        }
        if (string.equals("startarrow")) {
            return 1;
        }
        if (string.equals("botharrow")) {
            return 1;
        }
        return 0;
    }

    public static String getLineArrowStyle(DiagramElement diagramElement) {
        return MMStyleSupport.getValueString(diagramElement, "line.arrow.type");
    }

    public static double getValueDouble(DiagramElement diagramElement, String string) {
        String string2 = null;
        string2 = MMStyleSupport.getStyleMapFromKey((DiagramElement)diagramElement, (String)string);
        if (string2 == null) {
            return -1.0;
        }
        return Double.valueOf(string2);
    }

    public static float getValueFloat(DiagramElement diagramElement, String string) {
        String string2 = null;
        string2 = MMStyleSupport.getStyleMapFromKey((DiagramElement)diagramElement, (String)string);
        if (string2 == null) {
            return -1.0f;
        }
        return Float.valueOf(string2).floatValue();
    }

    public static String getValueString(DiagramElement diagramElement, String string) {
        if (diagramElement == null) {
            return null;
        }
        return MMStyleSupport.getStyleMapFromKey((DiagramElement)diagramElement, (String)string);
    }

    public static int getValueInteger(DiagramElement diagramElement, String string) {
        if (diagramElement == null) {
            return -1;
        }
        String string2 = null;
        string2 = MMStyleSupport.getStyleMapFromKey((DiagramElement)diagramElement, (String)string);
        if (string2 == null) {
            return -1;
        }
        return Integer.valueOf(string2);
    }

    public static int getLineEndArrowInt(DiagramElement diagramElement) {
        String string = MMStyleSupport.getLineArrowStyle(diagramElement);
        if (string == null) {
            return 0;
        }
        if (string.equals("noarrow")) {
            return 0;
        }
        if (string.equals("botharrow")) {
            return 1;
        }
        if (string.equals("endarrow")) {
            return 1;
        }
        if (string.equals("startarrow")) {
            return 0;
        }
        return 0;
    }

    public static void setLineColor(DiagramElement diagramElement, CColor cColor) {
        MMStyleSupport.setValueCColor(diagramElement, cColor, "line.color");
        if (diagramElement instanceof MMTopicShape && ((MMTopicShape)diagramElement).isRoot()) {
            return;
        }
        boolean bl = MMStyleSupport.getLineColorInheritance((Diagram)((MMDiagram)diagramElement.getOwningElement()));
        if (bl) {
            MMStyleSupport.setChangedForInheritColorOption(diagramElement);
        }
    }

    public static void setValueCColor(DiagramElement diagramElement, CColor cColor, String string) {
        if (cColor == null) {
            return;
        }
        MMStyleSupport.setValueWithSetChanged(diagramElement, string, cColor.toString());
    }

    public static void setValueWithSetChanged(DiagramElement diagramElement, String string, String string2) {
        MMStyleSupport.addStyleMap((DiagramElement)diagramElement, (String)string, (String)string2);
    }

    public static void removeLineColor(DiagramElement diagramElement) {
        MMStyleSupport.removeStyleMap((DiagramElement)diagramElement, (String)"line.color");
        if (diagramElement instanceof MMTopicShape && ((MMTopicShape)diagramElement).isRoot()) {
            return;
        }
        boolean bl = MMStyleSupport.getLineColorInheritance((Diagram)diagramElement.getOwningElement());
        if (bl) {
            MMStyleSupport.setChangedForInheritColorOption(diagramElement);
        }
    }

    public static String getRectTypeWithAuto(DiagramElement diagramElement) {
        if (diagramElement == null) {
            return null;
        }
        return MMStyleSupport.getValueStringWithAuto(diagramElement, "rect.type");
    }

    public static String getLineTypeWithAuto(DiagramElement diagramElement) {
        if (diagramElement == null) {
            return null;
        }
        return MMStyleSupport.getValueStringWithAuto(diagramElement, "line.type");
    }

    public static String getLineArrowTypeWithAuto(DiagramElement diagramElement) {
        if (diagramElement == null) {
            return null;
        }
        return MMStyleSupport.getValueStringWithAuto(diagramElement, "line.arrow.type");
    }

    public static void setBodyColor(DiagramElement diagramElement, CColor cColor) {
        MMStyleSupport.setValueCColor(diagramElement, cColor, STYLE_FILL_COLOR);
    }

    public static void setFilledColor(DiagramElement diagramElement, boolean bl) {
        MMStyleSupport.setValueWithSetChanged(diagramElement, "isfilled.color", String.valueOf(bl));
    }

    public static void setFontColor(DiagramElement diagramElement, CColor cColor) {
        MMStyleSupport.setValueCColor(diagramElement, cColor, "font.color");
    }

    public static void setJFont(DiagramElement diagramElement, JFont jFont) {
        String string = jFont.getFontName();
        String string2 = jFont.getFontStyle();
        String string3 = String.valueOf(jFont.getFontSize());
        String string4 = String.valueOf(jFont.isUnderlined());
        String string5 = String.valueOf(jFont.isStruckthrough());
        MMStyleSupport.setValueWithSetChanged(diagramElement, "font.name", string);
        MMStyleSupport.setValueWithSetChanged(diagramElement, "font.style", string2);
        MMStyleSupport.setValueWithSetChanged(diagramElement, "font.size", string3);
        MMStyleSupport.setValueWithSetChanged(diagramElement, "font.underlined", string4);
        MMStyleSupport.setValueWithSetChanged(diagramElement, "font.struckthrough", string5);
    }
}

