/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.mindmap.edit.layout;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.golf.model.ProjectModel;
import net.astah.golf.util.GolfUtilities;
import net.astah.golf.util.ResourceBundleList;
import net.astah.golf.widget.CColor;
import net.astah.jomt.jutil.FontManager;
import net.astah.jomt.jutil.JFont;
import net.astah.jomt.jutil.JomtFontUtilities;
import net.astah.notation.edit.layout.DiagramElementOperations;
import net.astah.notation.mindmap.MMBoundaryShape;
import net.astah.notation.mindmap.MMBranchEdge;
import net.astah.notation.mindmap.MMLabel;
import net.astah.notation.mindmap.MMLinkEdge;
import net.astah.notation.mindmap.MMTopicShape;
import net.astah.notation.mindmap.edit.layout.MMStyleSupport;
import net.astah.notation.mindmap.edit.layout.MMStyleSupportAccessor;
import net.astah.notation.mindmap.edit.layout.MindMapUtilties;

public class MMStyleMapOwner {
    private static final String a = "1";

    public static Map<String, String> getStyleMap(DiagramElement diagramElement) {
        return MMStyleSupport.getStyleMap((DiagramElement)diagramElement, (boolean)false);
    }

    public static void setStyleMap(DiagramElement diagramElement, Map<String, String> map) {
        MMStyleSupport.setStyleMap((DiagramElement)diagramElement, map);
    }

    public static boolean isBindedByUMLNotation(DiagramElement diagramElement) {
        return false;
    }

    public static ProjectModel getProject(DiagramElement diagramElement) {
        return (ProjectModel)MMStyleSupportAccessor.getProject(diagramElement);
    }

    public static Map<String, String> getAllStylesWithAuto(DiagramElement diagramElement) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : MMStyleMapOwner.getAllStyleKeys(diagramElement)) {
            String string2 = MMStyleMapOwner.getStyleForCopy(diagramElement, string);
            if (string2 == null) continue;
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    protected static List<String> getAllStyleKeys(DiagramElement diagramElement) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < MMStyleSupport.styles.length; ++i) {
            String string = MMStyleSupport.styles[i];
            if (!MMStyleMapOwner.isSupportedStyleKey(diagramElement, string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    protected static String getStyleForCopy(DiagramElement diagramElement, String string) {
        if (diagramElement instanceof MMTopicShape) {
            if (string.equals("line.color")) {
                Color color = MMStyleSupport.getLineColorWithAuto(diagramElement).transferToAWTColor();
                return GolfUtilities.convertColorToHex((Color)color);
            }
            if (string.equals("fill.color")) {
                return MMStyleSupport.getValueString(diagramElement, string);
            }
            String string2 = MMStyleMapOwner.getValueStringWithAuto(diagramElement, string);
            if (string.equals("isfilled.color") && string2 == null) {
                return String.valueOf(false);
            }
            return string2;
        }
        return MMStyleMapOwner.getValueStringWithAuto(diagramElement, string);
    }

    public static String getStyleMapFromKey(DiagramElement diagramElement, String string) {
        return MMStyleSupport.getStyleMapFromKey((DiagramElement)diagramElement, (String)string);
    }

    public static void addStyleMap(DiagramElement diagramElement, String string, String string2) {
        MMStyleSupport.addStyleMap((DiagramElement)diagramElement, (String)string, (String)string2);
    }

    public static void removeStyleMap(DiagramElement diagramElement, String string) {
        MMStyleSupport.removeStyleMap((DiagramElement)diagramElement, (String)string);
    }

    public static void clearStyleMap(DiagramElement diagramElement) {
        MMStyleSupport.clearStyleMap((DiagramElement)diagramElement);
    }

    public static boolean isSupportedStyleKey(DiagramElement diagramElement, String string) {
        if (diagramElement instanceof MMTopicShape) {
            return string.equals("line.width") || string.equals("shape") || string.equals("font.name") || string.equals("font.size") || string.equals("font.color") || string.equals("font.struckthrough") || string.equals("font.style") || string.equals("font.underlined") || string.equals("font") || string.equals("fill.color") || string.equals("line.color");
        }
        if (diagramElement instanceof MMBoundaryShape) {
            return string.equals("line.width") || string.equals("shape") || string.equals("fill.color") || string.equals("line.color");
        }
        if (diagramElement instanceof MMBranchEdge) {
            return string.equals("line.width") || string.equals("shape") || string.equals("line.color");
        }
        if (diagramElement instanceof MMLinkEdge) {
            return string.equals("line.width") || string.equals("line.type") || string.equals("line.arrow.type") || string.equals("line.color");
        }
        if (diagramElement instanceof MMLabel && diagramElement.getOwningElement() != null && diagramElement.getOwningElement() instanceof MMLinkEdge && string.equals("font.color")) {
            return true;
        }
        String string2 = MMStyleMapOwner.getStyleMapFromKey(diagramElement, string);
        return string2 != null;
    }

    public static String getValueStringWithAuto(DiagramElement diagramElement, String string) {
        return MMStyleSupportAccessor.getValueStringWithAuto(diagramElement, string);
    }

    public static String getStyleKeyForDiagram(DiagramElement diagramElement, String string) {
        if (diagramElement instanceof Diagram) {
            return null;
        }
        if (diagramElement instanceof MMTopicShape) {
            int n = MindMapUtilties.getModelTemplateSize(diagramElement);
            StringBuilder stringBuilder = new StringBuilder("topic.").append(string).append(".").append(Math.min(((MMTopicShape)diagramElement).getOutlineLevel(), n));
            return stringBuilder.toString();
        }
        if (diagramElement instanceof MMBranchEdge) {
            int n = MindMapUtilties.getModelTemplateSize(diagramElement);
            StringBuilder stringBuilder = new StringBuilder("edge.").append(string).append(".").append(Math.min(MMStyleMapOwner.getTopicIndex((MMBranchEdge)diagramElement), n));
            return stringBuilder.toString();
        }
        if (diagramElement instanceof MMBoundaryShape) {
            StringBuilder stringBuilder = new StringBuilder("boundary.").append(string);
            return stringBuilder.toString();
        }
        if (diagramElement instanceof MMLinkEdge) {
            return "link." + string;
        }
        if (diagramElement instanceof MMLabel) {
            return "rect." + string;
        }
        return string;
    }

    public static int getTopicIndex(MMBranchEdge mMBranchEdge) {
        if (mMBranchEdge.getParent() == null) {
            return 1;
        }
        return mMBranchEdge.getParent().getOutlineLevel() + 1;
    }

    public static String getStyleKeyForProject(DiagramElement diagramElement, String string) {
        if (diagramElement instanceof MMTopicShape) {
            // empty if block
        }
        return string;
    }

    public static String getStyleKeyForSystem(DiagramElement diagramElement, String string) {
        if (diagramElement instanceof MMTopicShape || diagramElement instanceof MMBranchEdge || diagramElement instanceof MMBoundaryShape) {
            return MindMapUtilties.getMindMapProperty().getSelectedTemplate() + "." + MMStyleMapOwner.getStyleKeyForDiagram(diagramElement, string);
        }
        return string;
    }

    public static String getDefaultStyleFromDiagram(DiagramElement diagramElement, String string) {
        Diagram diagram = DiagramElementOperations.getDiagram((DiagramElement)diagramElement);
        if (diagram != null) {
            return MMStyleMapOwner.getStyleMapFromKey((DiagramElement)diagram, MMStyleMapOwner.getStyleKeyForDiagram(diagramElement, string));
        }
        return null;
    }

    public static String getDefaultStyleFromProject(DiagramElement diagramElement, ProjectModel projectModel, String string) {
        if (projectModel != null) {
            return projectModel.getStyleMapFromKey(MMStyleMapOwner.getStyleKeyForProject(diagramElement, string));
        }
        return null;
    }

    public static String getDefaultStyleFromSystem(DiagramElement diagramElement, String string) {
        if (diagramElement instanceof Diagram) {
            return MMStyleMapOwner.a(diagramElement, string);
        }
        if (diagramElement instanceof MMTopicShape || diagramElement instanceof MMBranchEdge || diagramElement instanceof MMBoundaryShape) {
            return MindMapUtilties.getMindMapProperty().getDefaultString(MMStyleMapOwner.getStyleKeyForSystem(diagramElement, string));
        }
        if (diagramElement instanceof MMLabel) {
            if (string.equals("line.width")) {
                return a;
            }
            if (string.equals("line.type")) {
                return "line";
            }
            if (string.equals("line.color")) {
                return "#000000";
            }
            if (string.equals("fill.color")) {
                return "#FFFFFF";
            }
            if (string.equals("rect.type")) {
                return null;
            }
            return MMStyleMapOwner.a(diagramElement, string);
        }
        return string;
    }

    private static String a(DiagramElement diagramElement, String string) {
        if (string.equals("font.name")) {
            return MMStyleMapOwner.a(string);
        }
        if (string.equals("font.style")) {
            return MMStyleMapOwner.a(string);
        }
        if (string.equals("font.size")) {
            return MMStyleMapOwner.a(string);
        }
        ResourceBundleList resourceBundleList = MMStyleSupportAccessor.getSystemResource();
        if (resourceBundleList == null) {
            return null;
        }
        try {
            return resourceBundleList.getString(MMStyleMapOwner.getStyleKeyForSystem(diagramElement, string));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String a(String string) {
        JFont jFont = JomtFontUtilities.getDefaultJFont();
        if (string.equals("font.name")) {
            return jFont.getFontName();
        }
        if (string.equals("font.style")) {
            return jFont.getFontStyle();
        }
        if (string.equals("font.size")) {
            return String.valueOf(jFont.getFontSize());
        }
        return null;
    }

    public static void setStyles(DiagramElement diagramElement, Map<String, String> map) {
        if (map == null) {
            return;
        }
        for (String string : map.keySet()) {
            String string2;
            if (!MMStyleMapOwner.isSupportedStyle(diagramElement, string, string2 = map.get(string))) continue;
            MMStyleMapOwner.addStyleMap(diagramElement, string, string2);
        }
    }

    protected static boolean isSupportedStyle(DiagramElement diagramElement, String string, String string2) {
        if (diagramElement instanceof MMTopicShape) {
            if (string.equals("shape")) {
                String[] stringArray = new String[]{"line", "rounded_rectangle"};
                MMTopicShape mMTopicShape = (MMTopicShape)diagramElement;
                if (mMTopicShape.isTop()) {
                    stringArray = new String[]{"rounded_rectangle"};
                }
                return Arrays.asList(stringArray).contains(string2);
            }
        } else if (diagramElement instanceof MMBranchEdge && string.equals("shape")) {
            String[] stringArray = new String[]{"bezier", "linear", "sharpBezier", "sharpLinear"};
            return Arrays.asList(stringArray).contains(string2);
        }
        return MMStyleMapOwner.isSupportedStyleKey(diagramElement, string);
    }

    public static Font getFont(DiagramElement diagramElement) {
        JFont jFont = MMStyleSupport.getJFontWithAuto(diagramElement);
        Font font = FontManager.getFontFromJFontWithCash((JFont)jFont);
        return font;
    }

    public static void setBodyColor(DiagramElement diagramElement, CColor cColor) {
        if (cColor == null) {
            return;
        }
        CColor cColor2 = MMStyleSupport.getBodyColorWithAuto(diagramElement);
        if (cColor2 == null) {
            MMStyleSupport.setBodyColor(diagramElement, cColor);
        } else {
            if (cColor.equals(cColor2)) {
                return;
            }
            MMStyleSupport.setBodyColor(diagramElement, cColor);
        }
    }

    public static void setNameFontColor(DiagramElement diagramElement, CColor cColor) {
        if (MMStyleMapOwner.isSupportedStyleKey(diagramElement, "font.color")) {
            MMStyleSupport.setFontColor(diagramElement, cColor);
        }
    }
}

