/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.mindmap.edit.layout;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.Style;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.jmodel.StyleMap;
import net.astah.notation.edit.layout.DILayoutManager;
import net.astah.notation.mindmap.MMDiagram;
import net.astah.notation.mindmap.edit.layout.MMDiagramLayoutSwitch;
import net.astah.notation.mindmap.edit.layout.MMTopicSymmetryRelocater;
import net.astah.notation.mindmap.edit.layout.MMTreeChildrenSwitch;
import net.astah.notation.mindmap.edit.layout.MMZOrderComparator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TriggerCommandTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MMDiagramLayoutManager
extends DILayoutManager<MMDiagram> {
    private static Logger a = LoggerFactory.getLogger(MMDiagramLayoutManager.class);
    private static final MMTreeChildrenSwitch b = new MMTreeChildrenSwitch();
    private static final int c = 10;

    public MMDiagramLayoutManager() {
        super(MMDiagram.class);
    }

    public Command processAll(EditingDomain editingDomain, MMDiagram mMDiagram) {
        ArrayList arrayList = Lists.newArrayList((Iterator)mMDiagram.eAllContents());
        return new LayoutCommand((TransactionalEditingDomain)editingDomain, mMDiagram, arrayList);
    }

    public Command process(EditingDomain editingDomain, MMDiagram mMDiagram, Collection<?> collection, List<Notification> list) {
        this.propagateStyleChange(editingDomain, mMDiagram, list);
        InternalTransactionalEditingDomain internalTransactionalEditingDomain = (InternalTransactionalEditingDomain)editingDomain;
        if (this.a((Transaction)internalTransactionalEditingDomain.getActiveTransaction()) > 10) {
            return null;
        }
        return new LayoutCommand((TransactionalEditingDomain)internalTransactionalEditingDomain, mMDiagram, collection);
    }

    protected void propagateStyleChange(EditingDomain editingDomain, MMDiagram mMDiagram, List<Notification> list) {
        Set set = Sets.newIdentityHashSet();
        for (Notification notification : list) {
            EObject eObject = this.getStyleChangedElement(notification);
            if (!EcoreUtil.isAncestor((EObject)mMDiagram, (EObject)eObject) || !set.add(eObject)) continue;
            this.redirectStyleChange(mMDiagram, eObject, notification);
        }
    }

    protected EObject getStyleChangedElement(Notification notification) {
        EObject eObject;
        Object object = notification.getNotifier();
        if (object instanceof Style) {
            return ((Style)object).eContainer();
        }
        if (object instanceof DiagramElement) {
            switch (notification.getFeatureID(DiagramElement.class)) {
                case 6: 
                case 7: {
                    return (DiagramElement)object;
                }
            }
        } else if (object instanceof Map.Entry && object instanceof EObject && (eObject = ((EObject)object).eContainer()) instanceof StyleMap) {
            return eObject.eContainer();
        }
        return null;
    }

    protected void redirectStyleChange(MMDiagram mMDiagram, EObject eObject, Notification notification) {
        b.visit(eObject, mMDiagramElement -> {
            AdapterFactory adapterFactory = ItemProviders.getAdapterFactory((EObject)eObject);
            if (adapterFactory instanceof IChangeNotifier) {
                IChangeNotifier iChangeNotifier = (IChangeNotifier)adapterFactory;
                ViewerNotification viewerNotification = new ViewerNotification(notification, mMDiagramElement, false, true);
                a.debug("Propagating style change: {}", mMDiagramElement);
                iChangeNotifier.fireNotifyChanged((Notification)viewerNotification);
            }
        });
    }

    private int a(Transaction transaction) {
        Transaction transaction2;
        int n = 0;
        if (transaction instanceof TriggerCommandTransaction) {
            transaction2 = ((TriggerCommandTransaction)transaction).getCommand();
            n += this.a((Command)transaction2);
        }
        if ((transaction2 = transaction.getParent()) != null) {
            n += this.a(transaction2);
        }
        return n;
    }

    private int a(Command command) {
        if (command instanceof LayoutCommand) {
            return 1;
        }
        int n = 0;
        if (command instanceof CompoundCommand) {
            for (Command command2 : ((CompoundCommand)command).getCommandList()) {
                n += this.a(command2);
            }
        }
        return n;
    }

    protected static class LayoutCommand
    extends RecordingCommand {
        protected MMDiagram diagram;
        protected Collection<?> collection;

        public LayoutCommand(TransactionalEditingDomain transactionalEditingDomain, MMDiagram mMDiagram, Collection<?> collection) {
            super(transactionalEditingDomain, "LayoutCommand");
            this.diagram = mMDiagram;
            this.collection = collection;
        }

        protected void doExecute() {
            try {
                ECollections.sort((EList)this.diagram.getMMOwnedElements(), (Comparator)MMZOrderComparator.INSTANCE);
                MMDiagramLayoutSwitch mMDiagramLayoutSwitch = new MMDiagramLayoutSwitch();
                Iterables.filter(this.collection, EObject.class).forEach(arg_0 -> ((MMDiagramLayoutSwitch)mMDiagramLayoutSwitch).doSwitch(arg_0));
                new MMTopicSymmetryRelocater(this.diagram).startLayout();
            }
            catch (Throwable throwable) {
                a.error("error has occurred", throwable);
            }
        }
    }
}

