/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.mindmap.compare;

import com.google.common.base.MoreObjects;
import java.util.IdentityHashMap;
import net.astah.dd.di.DIPackage;
import net.astah.emf.common.ecore.EObjects;
import net.astah.emf.compare.diagram.extensions.DiagramChange;
import net.astah.emf.compare.diagram.extensions.ExtensionsFactory;
import net.astah.notation.compare.NotationDiagramPostProcessor;
import net.astah.notation.mindmap.MMDiagram;
import net.astah.notation.mindmap.MMNotationPackage;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class MMNotationDiagramPostProcessor
extends NotationDiagramPostProcessor {
    public void postDiff(Comparison comparison, Monitor monitor) {
        for (Diff diff : comparison.getDifferences()) {
            if (!this.isDerivedChange(comparison, diff)) continue;
            EcoreUtil.remove((EObject)diff);
        }
    }

    public void postComparison(Comparison comparison, Monitor monitor) {
        super.postComparison(comparison, monitor);
        IdentityHashMap<Match, DiagramChange> identityHashMap = new IdentityHashMap<Match, DiagramChange>();
        for (Diff diff : comparison.getDifferences()) {
            Match match = this.getDiagramMatch(comparison, diff);
            if (match == null) continue;
            DiagramChange diagramChange = identityHashMap.computeIfAbsent(match, match2 -> this.createDiagramChange(comparison, match, diff));
            diagramChange.getRefinedBy().add((Object)diff);
        }
    }

    protected Match getDiagramMatch(Comparison comparison, Diff diff) {
        EObject eObject;
        if (diff.getKind() != DifferenceKind.CHANGE) {
            eObject = MatchUtil.getContainer((Comparison)comparison, (Diff)diff);
        } else {
            Match match = diff.getMatch();
            eObject = (EObject)MoreObjects.firstNonNull((Object)match.getLeft(), (Object)match.getRight());
        }
        return comparison.getMatch(EObjects.getAncestor((EClass)MMNotationPackage.Literals.MM_DIAGRAM, (EObject)eObject));
    }

    protected DiagramChange createDiagramChange(Comparison comparison, Match match, Diff diff) {
        DiagramChange diagramChange = ExtensionsFactory.eINSTANCE.createDiagramChange();
        diagramChange.setKind(DifferenceKind.CHANGE);
        diagramChange.setDiagramElement(comparison.isThreeWay() ? match.getOrigin() : match.getLeft());
        diagramChange.setSemanticDiff(diff);
        match.getDifferences().add((Object)diagramChange);
        return diagramChange;
    }

    protected boolean isDerivedChange(Comparison comparison, Diff diff) {
        EObject eObject;
        ReferenceChange referenceChange;
        EReference eReference;
        return diff instanceof ReferenceChange && (eReference = (referenceChange = (ReferenceChange)diff).getReference()) == DIPackage.Literals.EDGE__WAYPOINT && (eObject = MatchUtil.getContainer((Comparison)comparison, (Diff)referenceChange)).eClass() == MMNotationPackage.Literals.MM_BRANCH_EDGE;
    }

    protected EReference getDiagramParentReference(EObject eObject) {
        if (eObject instanceof MMDiagram) {
            return MMNotationPackage.Literals.MM_DIAGRAM__PARENT;
        }
        return null;
    }
}

