/*
 * Decompiled with CFR 0.152.
 */
package net.astah.dd.dc.util;

import java.util.List;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public abstract class StyleResolver<E extends EObject, S extends EObject> {
    protected final List<Provider<E, S>> providers;
    protected S defaultStyle = this.createDefaultStyle();

    protected StyleResolver(List<Provider<E, S>> list) {
        this.providers = Objects.requireNonNull(list, "providers");
    }

    public Object resolveStyleValue(E e, EStructuralFeature eStructuralFeature) {
        return this.resolveStyle(e, eStructuralFeature).eGet(eStructuralFeature);
    }

    public <T> T resolveStyleValue(E e, EStructuralFeature eStructuralFeature, Class<T> clazz) {
        return this.resolveStyleValue(e, eStructuralFeature, clazz, null);
    }

    public <T> T resolveStyleValue(E e, EStructuralFeature eStructuralFeature, Class<T> clazz, T t) {
        Object object = this.resolveStyle(e, eStructuralFeature).eGet(eStructuralFeature);
        return clazz.isInstance(object) ? clazz.cast(object) : t;
    }

    protected S resolveStyle(E e, EStructuralFeature eStructuralFeature) {
        for (Provider<E, S> provider : this.providers) {
            S s = provider.getStyle(e, eStructuralFeature);
            if (s == null) continue;
            return s;
        }
        return this.defaultStyle;
    }

    protected abstract S createDefaultStyle();

    protected static abstract class CascadingProvider<E extends EObject, S extends EObject>
    implements Provider<E, S> {
        protected CascadingProvider() {
        }

        @Override
        public S getStyle(E e, EStructuralFeature eStructuralFeature) {
            for (int i = 0; e != null && i < 100000; ++i) {
                S s = this.getLocalStyle(e, eStructuralFeature);
                if (s != null) {
                    return s;
                }
                S s2 = this.getSharedStyle(e, eStructuralFeature);
                if (s2 != null) {
                    return s2;
                }
                e = this.getOwningElement(e);
            }
            return null;
        }

        protected abstract E getOwningElement(E var1);

        protected abstract S getLocalStyle(E var1, EStructuralFeature var2);

        protected abstract S getSharedStyle(E var1, EStructuralFeature var2);
    }

    public static interface Provider<E extends EObject, S extends EObject> {
        public S getStyle(E var1, EStructuralFeature var2);
    }
}

