/*
 * Decompiled with CFR 0.152.
 */
package net.astah.dd.dc.util;

import java.util.Map;
import net.astah.dd.dc.AlignmentKind;
import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.Color;
import net.astah.dd.dc.DCPackage;
import net.astah.dd.dc.Dimension;
import net.astah.dd.dc.KnownColor;
import net.astah.dd.dc.Point;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class DCValidator
extends EObjectValidator {
    public static final DCValidator INSTANCE = new DCValidator();
    public static final String DIAGNOSTIC_SOURCE = "net.astah.dd.dc";
    public static final int COLOR__VALID_RGB = 1;
    public static final int DIMENSION__NON_NEGATIVE_DIMENSION = 2;
    public static final int BOUNDS__NON_NEGATIVE_SIZE = 3;
    private static final int a = 3;
    protected static final int DIAGNOSTIC_CODE_COUNT = 3;

    protected EPackage getEPackage() {
        return DCPackage.eINSTANCE;
    }

    protected boolean validate(int n, Object object, DiagnosticChain diagnosticChain, Map<Object, Object> map) {
        switch (n) {
            case 0: {
                return this.validateColor((Color)object, diagnosticChain, map);
            }
            case 1: {
                return this.validatePoint((Point)object, diagnosticChain, map);
            }
            case 2: {
                return this.validateDimension((Dimension)object, diagnosticChain, map);
            }
            case 3: {
                return this.validateBounds((Bounds)object, diagnosticChain, map);
            }
            case 4: {
                return this.validateAlignmentKind((AlignmentKind)((Object)object), diagnosticChain, map);
            }
            case 5: {
                return this.validateKnownColor((KnownColor)((Object)object), diagnosticChain, map);
            }
        }
        return true;
    }

    public boolean validateColor(Color color, DiagnosticChain diagnosticChain, Map<Object, Object> map) {
        if (!this.validate_NoCircularContainment((EObject)color, diagnosticChain, map)) {
            return false;
        }
        boolean bl = this.validate_EveryMultiplicityConforms((EObject)color, diagnosticChain, map);
        if (bl || diagnosticChain != null) {
            bl &= this.validate_EveryDataValueConforms((EObject)color, diagnosticChain, map);
        }
        if (bl || diagnosticChain != null) {
            bl &= this.validate_EveryReferenceIsContained((EObject)color, diagnosticChain, map);
        }
        if (bl || diagnosticChain != null) {
            bl &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)color, diagnosticChain, map);
        }
        if (bl || diagnosticChain != null) {
            bl &= this.validate_EveryProxyResolves((EObject)color, diagnosticChain, map);
        }
        if (bl || diagnosticChain != null) {
            bl &= this.validate_UniqueID((EObject)color, diagnosticChain, map);
        }
        if (bl || diagnosticChain != null) {
            bl &= this.validate_EveryKeyUnique((EObject)color, diagnosticChain, map);
        }
        if (bl || diagnosticChain != null) {
            bl &= this.validate_EveryMapEntryUnique((EObject)color, diagnosticChain, map);
        }
        if (bl || diagnosticChain != null) {
            bl &= this.validateColor_validateValidRgb(color, diagnosticChain, map);
        }
        return bl;
    }

    public boolean validateColor_validateValidRgb(Color color, DiagnosticChain diagnosticChain, Map<Object, Object> map) {
        return color.validateValidRgb(diagnosticChain, map);
    }

    public boolean validatePoint(Point point, DiagnosticChain diagnosticChain, Map<Object, Object> map) {
        return this.validate_EveryDefaultConstraint((EObject)point, diagnosticChain, map);
    }

    public boolean validateDimension(Dimension dimension, DiagnosticChain diagnosticChain, Map<Object, Object> map) {
        if (!this.validate_NoCircularContainment((EObject)dimension, diagnosticChain, map)) {
            return false;
        }
        boolean bl = this.validate_EveryMultiplicityConforms((EObject)dimension, diagnosticChain, map);
        if (bl || diagnosticChain != null) {
            bl &= this.validate_EveryDataValueConforms((EObject)dimension, diagnosticChain, map);
        }
        if (bl || diagnosticChain != null) {
            bl &= this.validate_EveryReferenceIsContained((EObject)dimension, diagnosticChain, map);
        }
        if (bl || diagnosticChain != null) {
            bl &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)dimension, diagnosticChain, map);
        }
        if (bl || diagnosticChain != null) {
            bl &= this.validate_EveryProxyResolves((EObject)dimension, diagnosticChain, map);
        }
        if (bl || diagnosticChain != null) {
            bl &= this.validate_UniqueID((EObject)dimension, diagnosticChain, map);
        }
        if (bl || diagnosticChain != null) {
            bl &= this.validate_EveryKeyUnique((EObject)dimension, diagnosticChain, map);
        }
        if (bl || diagnosticChain != null) {
            bl &= this.validate_EveryMapEntryUnique((EObject)dimension, diagnosticChain, map);
        }
        if (bl || diagnosticChain != null) {
            bl &= this.validateDimension_validateNonNegativeDimension(dimension, diagnosticChain, map);
        }
        return bl;
    }

    public boolean validateDimension_validateNonNegativeDimension(Dimension dimension, DiagnosticChain diagnosticChain, Map<Object, Object> map) {
        return dimension.validateNonNegativeDimension(diagnosticChain, map);
    }

    public boolean validateBounds(Bounds bounds, DiagnosticChain diagnosticChain, Map<Object, Object> map) {
        if (!this.validate_NoCircularContainment((EObject)bounds, diagnosticChain, map)) {
            return false;
        }
        boolean bl = this.validate_EveryMultiplicityConforms((EObject)bounds, diagnosticChain, map);
        if (bl || diagnosticChain != null) {
            bl &= this.validate_EveryDataValueConforms((EObject)bounds, diagnosticChain, map);
        }
        if (bl || diagnosticChain != null) {
            bl &= this.validate_EveryReferenceIsContained((EObject)bounds, diagnosticChain, map);
        }
        if (bl || diagnosticChain != null) {
            bl &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)bounds, diagnosticChain, map);
        }
        if (bl || diagnosticChain != null) {
            bl &= this.validate_EveryProxyResolves((EObject)bounds, diagnosticChain, map);
        }
        if (bl || diagnosticChain != null) {
            bl &= this.validate_UniqueID((EObject)bounds, diagnosticChain, map);
        }
        if (bl || diagnosticChain != null) {
            bl &= this.validate_EveryKeyUnique((EObject)bounds, diagnosticChain, map);
        }
        if (bl || diagnosticChain != null) {
            bl &= this.validate_EveryMapEntryUnique((EObject)bounds, diagnosticChain, map);
        }
        if (bl || diagnosticChain != null) {
            bl &= this.validateBounds_validateNonNegativeSize(bounds, diagnosticChain, map);
        }
        return bl;
    }

    public boolean validateBounds_validateNonNegativeSize(Bounds bounds, DiagnosticChain diagnosticChain, Map<Object, Object> map) {
        return bounds.validateNonNegativeSize(diagnosticChain, map);
    }

    public boolean validateAlignmentKind(AlignmentKind alignmentKind, DiagnosticChain diagnosticChain, Map<Object, Object> map) {
        return true;
    }

    public boolean validateKnownColor(KnownColor knownColor, DiagnosticChain diagnosticChain, Map<Object, Object> map) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

