/*
 * Decompiled with CFR 0.152.
 */
package net.astah.dd.dc.util;

import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.DCFactory;
import net.astah.dd.dc.Dimension;
import net.astah.dd.dc.Point;
import net.astah.emf.common.ecore.DataTypes;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class DCUtil {
    public static boolean isEmpty(Bounds bounds) {
        if (bounds == null) {
            return true;
        }
        return bounds.getWidth() <= 0.0 || bounds.getHeight() <= 0.0;
    }

    public static boolean contains(Bounds bounds, Point point) {
        if (point == null) {
            return false;
        }
        return DCUtil.contains(bounds, point.getX(), point.getY());
    }

    public static boolean contains(Bounds bounds, double d, double d2) {
        if (bounds == null) {
            return false;
        }
        double d3 = bounds.getX();
        double d4 = bounds.getY();
        return d >= d3 && d2 >= d4 && d < d3 + bounds.getWidth() && d2 < d4 + bounds.getHeight();
    }

    public static double getMinX(Bounds bounds) {
        return bounds.getX();
    }

    public static double getMinY(Bounds bounds) {
        return bounds.getY();
    }

    public static double getMaxX(Bounds bounds) {
        return bounds.getX() + bounds.getWidth();
    }

    public static double getMaxY(Bounds bounds) {
        return bounds.getY() + bounds.getHeight();
    }

    public static double getCenterX(Bounds bounds) {
        return bounds.getX() + bounds.getWidth() / 2.0;
    }

    public static double getCenterY(Bounds bounds) {
        return bounds.getY() + bounds.getHeight() / 2.0;
    }

    public static Point moveTo(Point point, double d, double d2) {
        Point point2 = DCUtil.a(point, d, d2);
        return (Point)DataTypes.eChange((EObject)point, (EObject)point2);
    }

    public static Bounds moveTo(Bounds bounds, Point point) {
        return DCUtil.moveTo(bounds, point.getX(), point.getY());
    }

    public static Bounds moveTo(Bounds bounds, double d, double d2) {
        double d3 = bounds.getWidth();
        double d4 = bounds.getHeight();
        Bounds bounds2 = DCUtil.a(bounds, d, d2, d3, d4);
        return (Bounds)DataTypes.eChange((EObject)bounds, (EObject)bounds2);
    }

    public static Dimension resizeTo(Dimension dimension, double d, double d2) {
        Dimension dimension2 = DCUtil.a(dimension, d, d2);
        return (Dimension)DataTypes.eChange((EObject)dimension, (EObject)dimension2);
    }

    public static Bounds resizeTo(Bounds bounds, Dimension dimension) {
        return DCUtil.resizeTo(bounds, dimension.getWidth(), dimension.getHeight());
    }

    public static Bounds resizeTo(Bounds bounds, double d, double d2) {
        double d3 = bounds.getX();
        double d4 = bounds.getY();
        Bounds bounds2 = DCUtil.a(bounds, d3, d4, d, d2);
        return (Bounds)DataTypes.eChange((EObject)bounds, (EObject)bounds2);
    }

    public static double distance(Point point, Point point2) {
        double d = point2.getX() - point.getX();
        double d2 = point2.getY() - point.getY();
        return Math.sqrt(d * d + d2 * d2);
    }

    public static Point interpolate(Point point, Point point2, double d) {
        return DCFactory.eINSTANCE.createPoint((1.0 - d) * point.getX() + d * point2.getX(), (1.0 - d) * point.getY() + d * point2.getY());
    }

    public static Bounds add(Bounds bounds, Bounds bounds2) {
        double d = Math.min(DCUtil.getMinX(bounds), DCUtil.getMinX(bounds2));
        double d2 = Math.max(DCUtil.getMaxX(bounds), DCUtil.getMaxX(bounds2));
        double d3 = Math.min(DCUtil.getMinY(bounds), DCUtil.getMinY(bounds2));
        double d4 = Math.max(DCUtil.getMaxY(bounds), DCUtil.getMaxY(bounds2));
        return DCUtil.a(bounds, d, d3, d2 - d, d4 - d3);
    }

    static Bounds a(Bounds bounds, double d, double d2, double d3, double d4) {
        Bounds bounds2 = (Bounds)EcoreUtil.create((EClass)bounds.eClass());
        bounds2.setX(d);
        bounds2.setY(d2);
        bounds2.setWidth(d3);
        bounds2.setHeight(d4);
        return bounds2;
    }

    static Point a(Point point, double d, double d2) {
        Point point2 = (Point)EcoreUtil.create((EClass)point.eClass());
        point2.setX(d);
        point2.setY(d2);
        return point2;
    }

    static Dimension a(Dimension dimension, double d, double d2) {
        Dimension dimension2 = (Dimension)EcoreUtil.create((EClass)dimension.eClass());
        dimension2.setWidth(d);
        dimension2.setHeight(d2);
        return dimension2;
    }
}

