/*
 * Decompiled with CFR 0.152.
 */
package net.astah.dd.dc.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import net.astah.dd.dc.DCPackage;
import net.astah.dd.dc.Dimension;
import net.astah.emf.common.ecore.impl.ExtendedEObjectImpl;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class DimensionImpl
extends ExtendedEObjectImpl.Container
implements Dimension {
    protected static final double WIDTH_EDEFAULT = 0.0;
    protected double width = 0.0;
    protected static final double HEIGHT_EDEFAULT = 0.0;
    protected double height = 0.0;

    protected DimensionImpl() {
    }

    protected DimensionImpl(double d, double d2) {
        this.width = d;
        this.height = d2;
    }

    protected EClass eStaticClass() {
        return DCPackage.Literals.DIMENSION;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(double d) {
        this.validateChangeable(0, this.width, d);
        this.width = d;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(double d) {
        this.validateChangeable(1, this.height, d);
        this.height = d;
    }

    @Override
    public boolean validateNonNegativeDimension(DiagnosticChain diagnosticChain, Map<Object, Object> map) {
        if (!DimensionImpl.non_negative_dimension(this)) {
            if (diagnosticChain != null) {
                diagnosticChain.add((Diagnostic)new BasicDiagnostic(4, "net.astah.dd.dc", 2, EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[]{"non_negative_dimension", EObjectValidator.getObjectLabel((EObject)this, map)}), new Object[]{this}));
            }
            return false;
        }
        return true;
    }

    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 0: {
                return this.getWidth();
            }
            case 1: {
                return this.getHeight();
            }
        }
        return super.eGet(n, bl, bl2);
    }

    public void eSet(int n, Object object) {
        switch (n) {
            case 0: {
                this.setWidth((Double)object);
                return;
            }
            case 1: {
                this.setHeight((Double)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    public void eUnset(int n) {
        switch (n) {
            case 0: {
                this.setWidth(0.0);
                return;
            }
            case 1: {
                this.setHeight(0.0);
                return;
            }
        }
        super.eUnset(n);
    }

    public boolean eIsSet(int n) {
        switch (n) {
            case 0: {
                return this.width != 0.0;
            }
            case 1: {
                return this.height != 0.0;
            }
        }
        return super.eIsSet(n);
    }

    public Object eInvoke(int n, EList<?> eList) throws InvocationTargetException {
        switch (n) {
            case 0: {
                return this.validateNonNegativeDimension((DiagnosticChain)eList.get(0), (Map)eList.get(1));
            }
        }
        return super.eInvoke(n, eList);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" (width: ");
        stringBuffer.append(this.width);
        stringBuffer.append(", height: ");
        stringBuffer.append(this.height);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public boolean eIsDataType() {
        return true;
    }

    public boolean eEquals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Dimension)) {
            return false;
        }
        Dimension dimension = (Dimension)object;
        if (this.width != dimension.getWidth()) {
            return false;
        }
        return this.height == dimension.getHeight();
    }

    public int eHashCode() {
        long l = Double.doubleToLongBits(this.width);
        l = l * 31L + Double.doubleToLongBits(this.height);
        return (int)l ^ (int)(l >> 32);
    }

    public <T extends EObject> T eEquivalentOf(T t) {
        assert (t.eClass() == this.eClass());
        if (this.eIsChangeable()) {
            Dimension dimension = (Dimension)t;
            this.setWidth(dimension.getWidth());
            this.setHeight(dimension.getHeight());
            return (T)this;
        }
        if (this.eEquals(t)) {
            return (T)this;
        }
        return t;
    }

    public static Dimension createDimensionFromString(String string) {
        int n = string.indexOf(44);
        if (n > 0) {
            try {
                double d = Double.parseDouble(string.substring(0, n));
                double d2 = Double.parseDouble(string.substring(n + 1));
                return new DimensionImpl(d, d2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String convertDimensionToString(Dimension dimension) {
        return dimension.getWidth() + "," + dimension.getHeight();
    }

    public static boolean non_negative_dimension(Dimension dimension) {
        return dimension.getWidth() >= 0.0 && dimension.getHeight() >= 0.0;
    }
}

