/*
 * Decompiled with CFR 0.152.
 */
package net.astah.dd.dc.impl;

import net.astah.dd.dc.AlignmentKind;
import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.Color;
import net.astah.dd.dc.DCFactory;
import net.astah.dd.dc.DCPackage;
import net.astah.dd.dc.Dimension;
import net.astah.dd.dc.KnownColor;
import net.astah.dd.dc.Point;
import net.astah.dd.dc.impl.BoundsImpl;
import net.astah.dd.dc.impl.ColorImpl;
import net.astah.dd.dc.impl.DimensionImpl;
import net.astah.dd.dc.impl.KnownColors;
import net.astah.dd.dc.impl.PointImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class DCFactoryImpl
extends EFactoryImpl
implements DCFactory {
    public static DCFactory init() {
        try {
            DCFactory dCFactory = (DCFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.omg.org/spec/DD/20131001/DC");
            if (dCFactory != null) {
                return dCFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new DCFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createColor();
            }
            case 1: {
                return this.createPoint();
            }
            case 2: {
                return this.createDimension();
            }
            case 3: {
                return this.createBounds();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String string) {
        switch (eDataType.getClassifierID()) {
            case 4: {
                return this.createAlignmentKindFromString(eDataType, string);
            }
            case 5: {
                return this.createKnownColorFromString(eDataType, string);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object object) {
        switch (eDataType.getClassifierID()) {
            case 4: {
                return this.convertAlignmentKindToString(eDataType, object);
            }
            case 5: {
                return this.convertKnownColorToString(eDataType, object);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Color createColor() {
        ColorImpl colorImpl = new ColorImpl();
        return colorImpl;
    }

    @Override
    public Color createColor(Color color) {
        return new ColorImpl(color.getRed(), color.getGreen(), color.getBlue());
    }

    @Override
    public Color createColor(int n) {
        return new ColorImpl(n);
    }

    @Override
    public Color createColor(int n, int n2, int n3) {
        return new ColorImpl(n, n2, n3);
    }

    @Override
    public Point createPoint() {
        PointImpl pointImpl = new PointImpl();
        return pointImpl;
    }

    @Override
    public Point createPoint(Point point) {
        return new PointImpl(point.getX(), point.getY());
    }

    @Override
    public Point createPoint(double d, double d2) {
        return new PointImpl(d, d2);
    }

    @Override
    public Dimension createDimension() {
        DimensionImpl dimensionImpl = new DimensionImpl();
        return dimensionImpl;
    }

    @Override
    public Dimension createDimension(Dimension dimension) {
        return new DimensionImpl(dimension.getWidth(), dimension.getHeight());
    }

    @Override
    public Dimension createDimension(double d, double d2) {
        return new DimensionImpl(d, d2);
    }

    @Override
    public Bounds createBounds() {
        BoundsImpl boundsImpl = new BoundsImpl();
        return boundsImpl;
    }

    @Override
    public Bounds createBounds(Bounds bounds) {
        return new BoundsImpl(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    @Override
    public Bounds createBounds(double d, double d2, double d3, double d4) {
        return new BoundsImpl(d, d2, d3, d4);
    }

    public AlignmentKind createAlignmentKindFromString(EDataType eDataType, String string) {
        AlignmentKind alignmentKind = AlignmentKind.get(string);
        if (alignmentKind == null) {
            throw new IllegalArgumentException("The value '" + string + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return alignmentKind;
    }

    public String convertAlignmentKindToString(EDataType eDataType, Object object) {
        return object == null ? null : object.toString();
    }

    @Override
    public KnownColor getKnownColor(Color color) {
        KnownColor knownColor = KnownColors.a(color);
        if (knownColor != null) {
            return knownColor;
        }
        throw new IllegalArgumentException("The Color '" + color + "' is not valid");
    }

    public KnownColor createKnownColorFromString(EDataType eDataType, String string) {
        KnownColor knownColor = KnownColor.get(string);
        if (knownColor == null) {
            throw new IllegalArgumentException("The value '" + string + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return knownColor;
    }

    public String convertKnownColorToString(EDataType eDataType, Object object) {
        return object == null ? null : object.toString();
    }

    @Override
    public Color getColor(KnownColor knownColor) {
        Color color = KnownColors.a(knownColor);
        if (color != null) {
            return new ColorImpl(color);
        }
        throw new IllegalArgumentException("The KnownColor '" + (Object)((Object)knownColor) + "' is not valid");
    }

    @Override
    public DCPackage getDCPackage() {
        return (DCPackage)this.getEPackage();
    }

    @Deprecated
    public static DCPackage getPackage() {
        return DCPackage.eINSTANCE;
    }
}

