/*
 * Decompiled with CFR 0.152.
 */
package net.astah.dd.dc.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import net.astah.dd.dc.Color;
import net.astah.dd.dc.DCPackage;
import net.astah.dd.dc.impl.KnownColors;
import net.astah.emf.common.ecore.impl.ExtendedEObjectImpl;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class ColorImpl
extends ExtendedEObjectImpl.Container
implements Color {
    protected static final int RED_EDEFAULT = 0;
    protected int red = 0;
    protected static final int GREEN_EDEFAULT = 0;
    protected int green = 0;
    protected static final int BLUE_EDEFAULT = 0;
    protected int blue = 0;

    protected ColorImpl() {
    }

    protected ColorImpl(int n) {
        this.red = n >>> 16 & 0xFF;
        this.green = n >>> 8 & 0xFF;
        this.blue = n & 0xFF;
    }

    protected ColorImpl(int n, int n2, int n3) {
        this.red = n;
        this.green = n2;
        this.blue = n3;
    }

    protected ColorImpl(Color color) {
        this(color.getRed(), color.getGreen(), color.getBlue());
    }

    protected EClass eStaticClass() {
        return DCPackage.Literals.COLOR;
    }

    @Override
    public int getRed() {
        return this.red;
    }

    @Override
    public void setRed(int n) {
        this.validateChangeable(0, this.red, n);
        this.red = n;
    }

    @Override
    public int getGreen() {
        return this.green;
    }

    @Override
    public void setGreen(int n) {
        this.validateChangeable(1, this.green, n);
        this.green = n;
    }

    @Override
    public int getBlue() {
        return this.blue;
    }

    @Override
    public void setBlue(int n) {
        this.validateChangeable(2, this.blue, n);
        this.blue = n;
    }

    @Override
    public boolean validateValidRgb(DiagnosticChain diagnosticChain, Map<Object, Object> map) {
        if (!ColorImpl.valid_rgb(this)) {
            if (diagnosticChain != null) {
                diagnosticChain.add((Diagnostic)new BasicDiagnostic(4, "net.astah.dd.dc", 1, EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[]{"valid_rgb", EObjectValidator.getObjectLabel((EObject)this, map)}), new Object[]{this}));
            }
            return false;
        }
        return true;
    }

    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 0: {
                return this.getRed();
            }
            case 1: {
                return this.getGreen();
            }
            case 2: {
                return this.getBlue();
            }
        }
        return super.eGet(n, bl, bl2);
    }

    public void eSet(int n, Object object) {
        switch (n) {
            case 0: {
                this.setRed((Integer)object);
                return;
            }
            case 1: {
                this.setGreen((Integer)object);
                return;
            }
            case 2: {
                this.setBlue((Integer)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    public void eUnset(int n) {
        switch (n) {
            case 0: {
                this.setRed(0);
                return;
            }
            case 1: {
                this.setGreen(0);
                return;
            }
            case 2: {
                this.setBlue(0);
                return;
            }
        }
        super.eUnset(n);
    }

    public boolean eIsSet(int n) {
        switch (n) {
            case 0: {
                return this.red != 0;
            }
            case 1: {
                return this.green != 0;
            }
            case 2: {
                return this.blue != 0;
            }
        }
        return super.eIsSet(n);
    }

    public Object eInvoke(int n, EList<?> eList) throws InvocationTargetException {
        switch (n) {
            case 0: {
                return this.validateValidRgb((DiagnosticChain)eList.get(0), (Map)eList.get(1));
            }
        }
        return super.eInvoke(n, eList);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" (red: ");
        stringBuffer.append(this.red);
        stringBuffer.append(", green: ");
        stringBuffer.append(this.green);
        stringBuffer.append(", blue: ");
        stringBuffer.append(this.blue);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public boolean eIsDataType() {
        return true;
    }

    public boolean eEquals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Color)) {
            return false;
        }
        Color color = (Color)object;
        if (this.red != color.getRed()) {
            return false;
        }
        if (this.green != color.getGreen()) {
            return false;
        }
        return this.blue == color.getBlue();
    }

    public int eHashCode() {
        return ColorImpl.colorValue(this.red, this.green, this.blue);
    }

    public <T extends EObject> T eEquivalentOf(T t) {
        assert (t.eClass() == this.eClass());
        if (this.eIsChangeable()) {
            Color color = (Color)t;
            this.setRed(color.getRed());
            this.setGreen(color.getGreen());
            this.setBlue(color.getBlue());
            return (T)this;
        }
        if (this.eEquals(t)) {
            return (T)this;
        }
        return t;
    }

    public static Color createColorFromString(String string) {
        try {
            return new ColorImpl(Integer.decode(string));
        }
        catch (NumberFormatException numberFormatException) {
            return KnownColors.a(KnownColors.a(string));
        }
    }

    public static String convertColorToString(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        char[] cArray = new char[]{'#', Character.forDigit(n >>> 4 & 0xF, 16), Character.forDigit(n >>> 0 & 0xF, 16), Character.forDigit(n2 >>> 4 & 0xF, 16), Character.forDigit(n2 >>> 0 & 0xF, 16), Character.forDigit(n3 >>> 4 & 0xF, 16), Character.forDigit(n3 >>> 0 & 0xF, 16)};
        return new String(cArray);
    }

    public static int colorValue(Color color) {
        return ColorImpl.colorValue(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static int colorValue(int n, int n2, int n3) {
        return (n & 0xFF) << 16 | (n2 & 0xFF) << 8 | n3 & 0xFF;
    }

    public static boolean valid_rgb(Color color) {
        return ((color.getRed() | color.getGreen() | color.getBlue()) & 0xFFFFFF00) == 0;
    }
}

