/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.resource;

import java.util.Map;
import net.astah.dd.dg.DGPackage;
import net.astah.dd.dg.Marker;
import net.astah.dd.dg.Style;
import net.astah.notation.NotationPlugin;
import net.astah.notation.resource.NotationResourceFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class NotationResources {
    public static void init(ResourceSet resourceSet) {
        NotationResources.initLocalRegistries(resourceSet);
        NotationResources.initGlobalRegistries();
    }

    public static void initLocalRegistries(ResourceSet resourceSet) {
        NotationResources.initURIConverterURIMap(resourceSet.getURIConverter().getURIMap());
        NotationResources.initResourceFactoryRegistry(resourceSet.getResourceFactoryRegistry());
    }

    public static void initGlobalRegistries() {
        NotationResources.initURIConverterURIMap(URIConverter.URI_MAP);
        NotationResources.initResourceFactoryRegistry(Resource.Factory.Registry.INSTANCE);
    }

    public static Map<URI, URI> initURIConverterURIMap(Map<URI, URI> map) {
        URI uRI = URI.createURI((String)NotationPlugin.INSTANCE.getBaseURL().toString());
        map.put(URI.createURI((String)"pathmap://NOTATION_LIBRARIES/"), URI.createURI((String)"model/libraries/").resolve(uRI));
        return map;
    }

    public static void initResourceFactoryRegistry(Resource.Factory.Registry registry) {
        registry.getExtensionToFactoryMap().put("notation", NotationResourceFactory.INSTANCE);
    }

    public static URI getLibraryStyleURI(String string) {
        return URI.createURI((String)"pathmap://NOTATION_LIBRARIES/Styles.notation").appendFragment(string);
    }

    public static Style getLibraryStyle(EObject eObject, String string) {
        return (Style)NotationResources.a(eObject, string, DGPackage.Literals.STYLE);
    }

    public static Marker getLibraryMarker(EObject eObject, String string) {
        return (Marker)NotationResources.a(eObject, string, DGPackage.Literals.MARKER);
    }

    public static boolean isLibraryFragment(Object object, String string) {
        return object instanceof EObject && NotationResources.isLibraryFragment((EObject)object, string);
    }

    public static boolean isLibraryFragment(EObject eObject, String string) {
        URI uRI = EcoreUtil.getURI((EObject)eObject);
        return uRI.hasFragment() && uRI.fragment().equals(string) && uRI.trimFragment().toString().equals("pathmap://NOTATION_LIBRARIES/Styles.notation");
    }

    static EObject a(EObject eObject, String string, EClass eClass) {
        InternalEObject internalEObject = (InternalEObject)EcoreUtil.create((EClass)eClass);
        internalEObject.eSetProxyURI(NotationResources.getLibraryStyleURI(string));
        return EcoreUtil.resolve((EObject)internalEObject, (EObject)eObject);
    }
}

