/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.impl;

import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.Point;
import net.astah.notation.AnchorConstraint;
import net.astah.notation.Curve;
import net.astah.notation.GraphicalShape;
import net.astah.notation.ImageShape;
import net.astah.notation.Line;
import net.astah.notation.LineConstraint;
import net.astah.notation.Location;
import net.astah.notation.LocationConstraint;
import net.astah.notation.NotationFactory;
import net.astah.notation.NotationPackage;
import net.astah.notation.RatioAnchor;
import net.astah.notation.RightAngleCurve;
import net.astah.notation.RightAngleLine;
import net.astah.notation.Size;
import net.astah.notation.SizeConstraint;
import net.astah.notation.Style;
import net.astah.notation.Vector;
import net.astah.notation.impl.AnchorConstraintImpl;
import net.astah.notation.impl.CurveImpl;
import net.astah.notation.impl.GraphicalShapeImpl;
import net.astah.notation.impl.ImageShapeImpl;
import net.astah.notation.impl.LineConstraintImpl;
import net.astah.notation.impl.LineImpl;
import net.astah.notation.impl.LocationConstraintImpl;
import net.astah.notation.impl.LocationImpl;
import net.astah.notation.impl.RatioAnchorImpl;
import net.astah.notation.impl.RightAngleCurveImpl;
import net.astah.notation.impl.RightAngleLineImpl;
import net.astah.notation.impl.SizeConstraintImpl;
import net.astah.notation.impl.SizeImpl;
import net.astah.notation.impl.StyleImpl;
import net.astah.notation.impl.VectorImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class NotationFactoryImpl
extends EFactoryImpl
implements NotationFactory {
    public static NotationFactory init() {
        try {
            NotationFactory notationFactory = (NotationFactory)EPackage.Registry.INSTANCE.getEFactory("http://astah.net/notation/1.0.0/Notation");
            if (notationFactory != null) {
                return notationFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new NotationFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 1: {
                return this.createStyle();
            }
            case 3: {
                return this.createLocationConstraint();
            }
            case 4: {
                return this.createSizeConstraint();
            }
            case 6: {
                return this.createAnchorConstraint();
            }
            case 7: {
                return this.createLineConstraint();
            }
            case 11: {
                return this.createImageShape();
            }
            case 12: {
                return this.createGraphicalShape();
            }
            case 13: {
                return this.createVector();
            }
            case 14: {
                return this.createLocation();
            }
            case 15: {
                return this.createSize();
            }
            case 16: {
                return this.createRatioAnchor();
            }
            case 17: {
                return this.createLine();
            }
            case 18: {
                return this.createRightAngleLine();
            }
            case 19: {
                return this.createCurve();
            }
            case 20: {
                return this.createRightAngleCurve();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    @Override
    public Style createStyle() {
        StyleImpl styleImpl = new StyleImpl();
        return styleImpl;
    }

    @Override
    public LocationConstraint createLocationConstraint() {
        LocationConstraintImpl locationConstraintImpl = new LocationConstraintImpl();
        return locationConstraintImpl;
    }

    @Override
    public SizeConstraint createSizeConstraint() {
        SizeConstraintImpl sizeConstraintImpl = new SizeConstraintImpl();
        return sizeConstraintImpl;
    }

    @Override
    public AnchorConstraint createAnchorConstraint() {
        AnchorConstraintImpl anchorConstraintImpl = new AnchorConstraintImpl();
        return anchorConstraintImpl;
    }

    @Override
    public LineConstraint createLineConstraint() {
        LineConstraintImpl lineConstraintImpl = new LineConstraintImpl();
        return lineConstraintImpl;
    }

    @Override
    public ImageShape createImageShape() {
        ImageShapeImpl imageShapeImpl = new ImageShapeImpl();
        return imageShapeImpl;
    }

    @Override
    public GraphicalShape createGraphicalShape() {
        GraphicalShapeImpl graphicalShapeImpl = new GraphicalShapeImpl();
        return graphicalShapeImpl;
    }

    @Override
    public Vector createVector() {
        VectorImpl vectorImpl = new VectorImpl();
        return vectorImpl;
    }

    @Override
    public Vector createVector(double d, double d2) {
        return new VectorImpl(d, d2);
    }

    @Override
    public Location createLocation() {
        LocationImpl locationImpl = new LocationImpl();
        return locationImpl;
    }

    @Override
    public Location createLocation(double d, double d2) {
        return new LocationImpl(d, d2);
    }

    @Override
    public Size createSize() {
        SizeImpl sizeImpl = new SizeImpl();
        return sizeImpl;
    }

    @Override
    public Size createSize(double d, double d2) {
        return new SizeImpl(d, d2);
    }

    @Override
    public RatioAnchor createRatioAnchor() {
        RatioAnchorImpl ratioAnchorImpl = new RatioAnchorImpl();
        return ratioAnchorImpl;
    }

    @Override
    public Line createLine() {
        LineImpl lineImpl = new LineImpl();
        return lineImpl;
    }

    @Override
    public RightAngleLine createRightAngleLine() {
        RightAngleLineImpl rightAngleLineImpl = new RightAngleLineImpl();
        return rightAngleLineImpl;
    }

    @Override
    public Curve createCurve() {
        CurveImpl curveImpl = new CurveImpl();
        return curveImpl;
    }

    @Override
    public RightAngleCurve createRightAngleCurve() {
        RightAngleCurveImpl rightAngleCurveImpl = new RightAngleCurveImpl();
        return rightAngleCurveImpl;
    }

    @Override
    public RatioAnchor createRatioAnchor(double d, double d2) {
        return new RatioAnchorImpl(d, d2);
    }

    @Override
    public RatioAnchor createRatioAnchor(Bounds bounds, Point point) {
        double d = (point.getX() - bounds.getX()) / bounds.getWidth();
        double d2 = (point.getY() - bounds.getY()) / bounds.getHeight();
        return new RatioAnchorImpl(d, d2);
    }

    @Override
    public NotationPackage getNotationPackage() {
        return (NotationPackage)this.getEPackage();
    }

    @Deprecated
    public static NotationPackage getPackage() {
        return NotationPackage.eINSTANCE;
    }
}

