/*
 * Decompiled with CFR 0.152.
 */
package net.astah.ui.view.property;

import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import net.astah.golf.view.swing.ActivatableCellEditor;
import net.astah.golf.view.swing.FlexiblePropertyCellEditor;
import net.astah.golf.view.swing.IPropertyDescriptor;
import net.astah.golf.view.swing.IPropertySource;
import net.astah.golf.view.swing.IPropertySourceProvider;
import net.astah.golf.view.swing.MultilineTextPropertyCellEditor;
import net.astah.golf.view.swing.PropertyCellEditor;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class PropertyEditor
implements FocusListener,
Observer,
CellEditorListener {
    protected final IPropertySourceProvider propertySourceProvider;
    protected final IPropertySource propertySource;
    protected final IPropertyDescriptor propertyDescriptor;
    protected final PropertyCellEditor cellEditor;
    protected final Component component;

    public PropertyEditor(IPropertySourceProvider iPropertySourceProvider, IPropertySource iPropertySource, IPropertyDescriptor iPropertyDescriptor) {
        this.propertySourceProvider = iPropertySourceProvider;
        this.propertySource = iPropertySource;
        this.propertyDescriptor = iPropertyDescriptor;
        this.cellEditor = iPropertyDescriptor.createPropertyEditor();
        this.cellEditor.addCellEditorListener((CellEditorListener)this);
        if (this.cellEditor instanceof FlexiblePropertyCellEditor) {
            ((FlexiblePropertyCellEditor)this.cellEditor).setFlexible(true);
        }
        this.component = this.cellEditor.getPropertyCellEditorComponent(null, this.getEditableValue());
        this.a(this.component);
    }

    public void addMouseListener(MouseListener mouseListener) {
        if (this.cellEditor instanceof ActivatableCellEditor) {
            ((ActivatableCellEditor)this.cellEditor).addMouseListener(mouseListener);
        }
    }

    public Component getComponent() {
        return this.component;
    }

    public int getRows() {
        if (this.cellEditor instanceof MultilineTextPropertyCellEditor) {
            return ((MultilineTextPropertyCellEditor)this.cellEditor).getRows();
        }
        return -1;
    }

    public void setRows(int n) {
        if (this.cellEditor instanceof MultilineTextPropertyCellEditor) {
            ((MultilineTextPropertyCellEditor)this.cellEditor).setRows(n);
        }
    }

    public int getColumns() {
        if (this.cellEditor instanceof MultilineTextPropertyCellEditor) {
            return ((MultilineTextPropertyCellEditor)this.cellEditor).getColumns();
        }
        return -1;
    }

    public void setColumns(int n) {
        if (this.cellEditor instanceof MultilineTextPropertyCellEditor) {
            ((MultilineTextPropertyCellEditor)this.cellEditor).setColumns(n);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object instanceof Component && this.a(this.component, (Component)object)) {
            SwingUtilities.invokeLater(() -> {
                Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (component == null || !this.a(this.component, component)) {
                    this.cellEditor.stopCellEditing();
                }
            });
        }
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        this.commit();
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
        this.commit();
    }

    @Override
    public void update(Observable observable, Object object) {
        this.update();
    }

    public void update() {
        this.cellEditor.setCellEditorValue(this.getEditableValue());
    }

    public void commit() {
        if (AdapterFactoryEditingDomain.getEditingDomainFor((Object)this.propertySource.getEditableValue()) != null) {
            Object object = this.cellEditor.getCellEditorValue();
            this.propertySource.setPropertyValue(this.propertyDescriptor.getId(), object);
        }
    }

    protected Object getEditableValue() {
        Object object = this.propertySource.getPropertyValue(this.propertyDescriptor.getId());
        IPropertySource iPropertySource = this.propertySourceProvider.getPropertySource(object);
        if (iPropertySource == null) {
            return null;
        }
        return iPropertySource.getEditableValue();
    }

    boolean a(Component component, Component component2) {
        while (component2 != null) {
            if (component2 == component) {
                return true;
            }
            component2 = component2.getParent();
        }
        return false;
    }

    void a(Component component) {
        if (component.isFocusable()) {
            component.addFocusListener(this);
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int j = 0; j < container.getComponentCount(); ++j) {
                this.a(container.getComponent(j));
            }
        }
    }
}

