/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.provider;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.astah.emf.edit.command.SupersetMoveCommand;
import net.astah.stpa.stamp.Element;
import net.astah.stpa.stamp.Note;
import net.astah.stpa.stamp.STAMPPackage;
import net.astah.stpa.stamp.UCAAnalysis;
import net.astah.stpa.stamp.UCAAnalysisResult;
import net.astah.stpa.stamp.UnsafeControlAction;
import net.astah.stpa.stamp.notation.STAMPNotationPackage;
import net.astah.stpa.stamp.notation.UCATable;
import net.astah.stpa.stamp.provider.ElementItemProvider;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.uml2.common.edit.command.SubsetAddCommand;
import org.eclipse.uml2.common.edit.command.SubsetSupersetReplaceCommand;
import org.eclipse.uml2.common.edit.command.SubsetSupersetSetCommand;
import org.eclipse.uml2.common.edit.command.SupersetRemoveCommand;
import org.eclipse.uml2.common.util.UML2Util;

public class UCAAnalysisResultItemProvider
extends ElementItemProvider {
    public UCAAnalysisResultItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addResultElementPropertyDescriptor(object);
            this.addUnsafeControlActionPropertyDescriptor(object);
            this.addControlActionPropertyDescriptor(object);
            this.addGuideWordPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addResultElementPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_UCAAnalysisResult_resultElement_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_UCAAnalysisResult_resultElement_feature", "_UI_UCAAnalysisResult_type"), (EStructuralFeature)STAMPPackage.Literals.UCA_ANALYSIS_RESULT__RESULT_ELEMENT, true, false, true, null, null, null));
    }

    protected void addUnsafeControlActionPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_UCAAnalysisResult_unsafeControlAction_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_UCAAnalysisResult_unsafeControlAction_feature", "_UI_UCAAnalysisResult_type"), (EStructuralFeature)STAMPPackage.Literals.UCA_ANALYSIS_RESULT__UNSAFE_CONTROL_ACTION, true, false, true, null, null, null));
    }

    protected void addControlActionPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_UCAAnalysisResult_controlAction_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_UCAAnalysisResult_controlAction_feature", "_UI_UCAAnalysisResult_type"), (EStructuralFeature)STAMPPackage.Literals.UCA_ANALYSIS_RESULT__CONTROL_ACTION, true, false, true, null, null, null));
    }

    protected void addGuideWordPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_UCAAnalysisResult_guideWord_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_UCAAnalysisResult_guideWord_feature", "_UI_UCAAnalysisResult_type"), (EStructuralFeature)STAMPPackage.Literals.UCA_ANALYSIS_RESULT__GUIDE_WORD, true, false, true, null, null, null));
    }

    @Override
    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/UCAAnalysisResult"));
    }

    @Override
    protected boolean shouldComposeCreationImage() {
        return true;
    }

    @Override
    public String getText(Object object) {
        return this.getString("_UI_UCAAnalysisResult_type");
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(UCAAnalysisResult.class)) {
            case 2: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    protected Command createAddCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection, int index) {
        if (feature == STAMPPackage.Literals.UCA_ANALYSIS_RESULT__UNSAFE_CONTROL_ACTION) {
            return new SubsetAddCommand(domain, owner, feature, new EStructuralFeature[]{STAMPPackage.Literals.UCA_ANALYSIS_RESULT__RESULT_ELEMENT}, collection, index);
        }
        if (feature == STAMPPackage.Literals.ELEMENT__OWNED_NOTE) {
            return new SubsetAddCommand(domain, owner, feature, new EStructuralFeature[]{STAMPPackage.Literals.UCA_ANALYSIS_RESULT__RESULT_ELEMENT}, collection, index);
        }
        return super.createAddCommand(domain, owner, feature, collection, index);
    }

    protected Command createRemoveCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection) {
        if (feature == STAMPPackage.Literals.UCA_ANALYSIS_RESULT__RESULT_ELEMENT) {
            return new SupersetRemoveCommand(domain, owner, feature, new EStructuralFeature[]{STAMPPackage.Literals.UCA_ANALYSIS_RESULT__UNSAFE_CONTROL_ACTION, STAMPPackage.Literals.ELEMENT__OWNED_NOTE}, collection);
        }
        return super.createRemoveCommand(domain, owner, feature, collection);
    }

    protected Command createReplaceCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value, Collection<?> collection) {
        if (feature == STAMPPackage.Literals.UCA_ANALYSIS_RESULT__UNSAFE_CONTROL_ACTION) {
            return new SubsetSupersetReplaceCommand(domain, owner, feature, new EStructuralFeature[]{STAMPPackage.Literals.UCA_ANALYSIS_RESULT__RESULT_ELEMENT}, null, value, collection);
        }
        if (feature == STAMPPackage.Literals.ELEMENT__OWNED_NOTE) {
            return new SubsetSupersetReplaceCommand(domain, owner, feature, new EStructuralFeature[]{STAMPPackage.Literals.UCA_ANALYSIS_RESULT__RESULT_ELEMENT}, null, value, collection);
        }
        if (feature == STAMPPackage.Literals.UCA_ANALYSIS_RESULT__RESULT_ELEMENT) {
            return new SubsetSupersetReplaceCommand(domain, owner, feature, null, new EStructuralFeature[]{STAMPPackage.Literals.UCA_ANALYSIS_RESULT__UNSAFE_CONTROL_ACTION, STAMPPackage.Literals.ELEMENT__OWNED_NOTE}, value, collection);
        }
        return super.createReplaceCommand(domain, owner, feature, value, collection);
    }

    protected Command createSetCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value) {
        if (feature == STAMPPackage.Literals.UCA_ANALYSIS_RESULT__UNSAFE_CONTROL_ACTION) {
            return new SubsetSupersetSetCommand(domain, owner, feature, new EStructuralFeature[]{STAMPPackage.Literals.UCA_ANALYSIS_RESULT__RESULT_ELEMENT}, null, value);
        }
        if (feature == STAMPPackage.Literals.ELEMENT__OWNED_NOTE) {
            return new SubsetSupersetSetCommand(domain, owner, feature, new EStructuralFeature[]{STAMPPackage.Literals.UCA_ANALYSIS_RESULT__RESULT_ELEMENT}, null, value);
        }
        if (feature == STAMPPackage.Literals.UCA_ANALYSIS_RESULT__RESULT_ELEMENT) {
            return new SubsetSupersetSetCommand(domain, owner, feature, null, new EStructuralFeature[]{STAMPPackage.Literals.UCA_ANALYSIS_RESULT__UNSAFE_CONTROL_ACTION, STAMPPackage.Literals.ELEMENT__OWNED_NOTE}, value);
        }
        return super.createSetCommand(domain, owner, feature, value);
    }

    protected Command createMoveCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value, int index) {
        if (feature == STAMPPackage.Literals.UCA_ANALYSIS_RESULT__RESULT_ELEMENT) {
            return new SupersetMoveCommand(domain, owner, feature, new EStructuralFeature[]{STAMPPackage.Literals.UCA_ANALYSIS_RESULT__UNSAFE_CONTROL_ACTION, STAMPPackage.Literals.ELEMENT__OWNED_NOTE}, value, index);
        }
        return super.createMoveCommand(domain, owner, feature, value, index);
    }

    public void collectSharedComposites(EditingDomain domain, Object object, Collection<Object> collection) {
        UCAAnalysisResult owner = (UCAAnalysisResult)object;
        collection.addAll((Collection<Object>)owner.getUnsafeControlActions());
    }

    public Collection<?> getIntentionDomains(Object object) {
        EObject eContainer = ((EObject)object).eContainer();
        if (eContainer instanceof UCAAnalysis) {
            return UML2Util.getNonNavigableInverseReferences((EObject)eContainer).stream().filter(setting -> {
                EStructuralFeature feature = setting.getEStructuralFeature();
                if (feature != STAMPNotationPackage.Literals.UCA_TABLE__ANALYSIS) {
                    return false;
                }
                UCATable table = (UCATable)setting.getEObject();
                return table.getResults().contains(object);
            }).map(EStructuralFeature.Setting::getEObject).collect(Collectors.toList());
        }
        return Collections.emptySet();
    }

    @Override
    public String getTableCellText(Object object) {
        StringBuffer ucaText = new StringBuffer();
        for (Element element : ((UCAAnalysisResult)object).getResultElements()) {
            if (element instanceof UnsafeControlAction) {
                UnsafeControlAction uca = (UnsafeControlAction)element;
                ucaText.append("(" + uca.getId() + ") ");
                ucaText.append(uca.getDescription());
                if (!uca.getViolatingSafetyConstraints().isEmpty()) {
                    ucaText.append("\n");
                    uca.getViolatingSafetyConstraints().forEach(sc -> ucaText.append("[" + sc.getId() + "]"));
                }
                ucaText.append("\n");
                continue;
            }
            if (!(element instanceof Note)) continue;
            ucaText.append(((Note)element).getBody() + "\n");
        }
        return ucaText.toString();
    }
}

