/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.edit.sequencer;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import net.astah.emf.common.ecore.EComparators;
import net.astah.emf.common.notify.EFeaturePath;
import net.astah.emf.edit.sequencer.AttributeSequencer;
import net.astah.emf.edit.sequencer.IdReorganizer;
import net.astah.emf.edit.sequencer.IdSequencer;
import net.astah.emf.edit.sequencer.IdSequencerRegistryImpl;
import net.astah.emf.edit.sequencer.PatternSequencer;
import net.astah.emf.edit.sequencer.ReferenceIndexSequencer;
import net.astah.stpa.stamp.STAMPPackage;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class IdReorganizerListener
extends ResourceSetListenerImpl {
    protected final Map<TransactionalEditingDomain, IdReorganizer> reorganizers = Collections.synchronizedMap(new WeakHashMap());

    public boolean isPrecommitOnly() {
        return true;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        TransactionalEditingDomain domain = event.getEditingDomain();
        IdReorganizer reorganizer = this.reorganizers.get(domain);
        if (reorganizer != null) {
            List notifications = event.getNotifications();
            return reorganizer.createCommand((EditingDomain)domain, (Iterable)notifications);
        }
        return null;
    }

    public void setTarget(TransactionalEditingDomain domain) {
        super.setTarget(domain);
        this.reorganizers.computeIfAbsent(domain, key -> this.createReorganizer());
    }

    public void unsetTarget(TransactionalEditingDomain domain) {
        super.unsetTarget(domain);
        IdReorganizer reorganizer = this.reorganizers.remove(domain);
        if (reorganizer != null) {
            reorganizer.dispose();
        }
    }

    protected IdReorganizer createReorganizer() {
        IdSequencerRegistryImpl registry = new IdSequencerRegistryImpl();
        registry.put((Object)STAMPPackage.Literals.PRECONDITION, (Object)new PatternSequencer(STAMPPackage.Literals.IDENTIFIED_ELEMENT__ID, (IdSequencer)ReferenceIndexSequencer.build((EFeaturePath)EFeaturePath.build((EStructuralFeature)STAMPPackage.Literals.STPA_ANALYSIS__PRECONDITION), (int)1), Pattern.compile(".*-(\\d+)")));
        registry.put((Object)STAMPPackage.Literals.ACCIDENT, (Object)ReferenceIndexSequencer.build((EFeaturePath)EFeaturePath.build((EStructuralFeature)STAMPPackage.Literals.STPA_ANALYSIS__ACCIDENT), (int)1));
        registry.put((Object)STAMPPackage.Literals.HAZARD, (Object)ReferenceIndexSequencer.build((EFeaturePath)EFeaturePath.builder().add((EStructuralFeature)STAMPPackage.Literals.STPA_ANALYSIS__ACCIDENT).add((EStructuralFeature)STAMPPackage.Literals.ACCIDENT__HAZARD).create(), (int)1));
        registry.put((Object)STAMPPackage.Literals.SAFETY_CONSTRAINT, (Object)ReferenceIndexSequencer.build((EFeaturePath)EFeaturePath.builder().add((EStructuralFeature)STAMPPackage.Literals.STPA_ANALYSIS__ACCIDENT).add((EStructuralFeature)STAMPPackage.Literals.ACCIDENT__HAZARD).add((EStructuralFeature)STAMPPackage.Literals.HAZARD__SAFETY_CONSTRAINT).create(), (int)1));
        registry.put((Object)STAMPPackage.Literals.CONTROL_ACTION, (Object)ReferenceIndexSequencer.build((EFeaturePath)EFeaturePath.build((EStructuralFeature)STAMPPackage.Literals.UCA_ANALYSIS__CONTROL_ACTION), (int)1));
        registry.put((Object)STAMPPackage.Literals.UCA_GUIDE_WORD, (Object)new AttributeSequencer(STAMPPackage.Literals.UCA_GUIDE_WORD__UCA_ID_POSTFIX));
        registry.put((Object)STAMPPackage.Literals.UNSAFE_CONTROL_ACTION, (Object)ReferenceIndexSequencer.build((EFeaturePath)EFeaturePath.build((EStructuralFeature)STAMPPackage.Literals.UCA_ANALYSIS_RESULT__UNSAFE_CONTROL_ACTION), (int)1));
        registry.put((Object)STAMPPackage.Literals.COUNTERMEASURE, (Object)ReferenceIndexSequencer.build((EFeaturePath)EFeaturePath.builder().add((EStructuralFeature)STAMPPackage.Literals.STPA_ANALYSIS__HAZARD_CAUSAL_FACTOR).add((EStructuralFeature)STAMPPackage.Literals.HAZARD_CAUSAL_FACTOR__COUNTERMEASURE).create(), (int)1));
        registry.put((Object)STAMPPackage.Literals.HAZARD_CAUSAL_FACTOR, (Object)ReferenceIndexSequencer.builder((EFeaturePath)EFeaturePath.builder().addInverse(STAMPPackage.Literals.HAZARD_CAUSAL_FACTOR__UNSAFE_CONTROL_ACTION).create()).extraPaths(EFeaturePath.build((EStructuralFeature)STAMPPackage.Literals.STPA_ANALYSIS__HAZARD_CAUSAL_FACTOR)).comparator(EComparators.eObjectPath()).offset(1).create());
        IdReorganizer reorganizer = new IdReorganizer();
        reorganizer.addFormat(registry.createFormat("{0}", STAMPPackage.Literals.PRECONDITION, STAMPPackage.Literals.IDENTIFIED_ELEMENT__ID, new EFeaturePath[0]));
        reorganizer.addFormat(registry.createFormat("A{0}", STAMPPackage.Literals.ACCIDENT, STAMPPackage.Literals.IDENTIFIED_ELEMENT__ID, new EFeaturePath[0]));
        reorganizer.addFormat(registry.createFormat("H{0}", STAMPPackage.Literals.HAZARD, STAMPPackage.Literals.IDENTIFIED_ELEMENT__ID, new EFeaturePath[0]));
        reorganizer.addFormat(registry.createFormat("SC{0}", STAMPPackage.Literals.SAFETY_CONSTRAINT, STAMPPackage.Literals.IDENTIFIED_ELEMENT__ID, new EFeaturePath[0]));
        reorganizer.addFormat(registry.createFormat("UCA{1}-{2}-{0}", STAMPPackage.Literals.UNSAFE_CONTROL_ACTION, STAMPPackage.Literals.IDENTIFIED_ELEMENT__ID, new EFeaturePath[]{EFeaturePath.builder().add((EStructuralFeature)STAMPPackage.Literals.UNSAFE_CONTROL_ACTION__CONTROL_ACTION).addInverse(STAMPPackage.Literals.UCA_ANALYSIS__CONTROL_ACTION).create(), EFeaturePath.builder().addInverse(STAMPPackage.Literals.UCA_ANALYSIS_RESULT__UNSAFE_CONTROL_ACTION).add((EStructuralFeature)STAMPPackage.Literals.UCA_ANALYSIS_RESULT__GUIDE_WORD).add((EStructuralFeature)STAMPPackage.Literals.UCA_GUIDE_WORD__UCA_ID_POSTFIX).create()}));
        reorganizer.addFormat(registry.createFormat("M{0}", STAMPPackage.Literals.COUNTERMEASURE, STAMPPackage.Literals.IDENTIFIED_ELEMENT__ID, new EFeaturePath[0]));
        reorganizer.addFormat(registry.createFormat("HCF{1}-{2}-{3}-{0}", STAMPPackage.Literals.HAZARD_CAUSAL_FACTOR, STAMPPackage.Literals.IDENTIFIED_ELEMENT__ID, new EFeaturePath[]{EFeaturePath.builder().add((EStructuralFeature)STAMPPackage.Literals.HAZARD_CAUSAL_FACTOR__UNSAFE_CONTROL_ACTION).add((EStructuralFeature)STAMPPackage.Literals.UNSAFE_CONTROL_ACTION__CONTROL_ACTION).addInverse(STAMPPackage.Literals.UCA_ANALYSIS__CONTROL_ACTION).create(), EFeaturePath.builder().add((EStructuralFeature)STAMPPackage.Literals.HAZARD_CAUSAL_FACTOR__UNSAFE_CONTROL_ACTION).addInverse(STAMPPackage.Literals.UCA_ANALYSIS_RESULT__UNSAFE_CONTROL_ACTION).add((EStructuralFeature)STAMPPackage.Literals.UCA_ANALYSIS_RESULT__GUIDE_WORD).add((EStructuralFeature)STAMPPackage.Literals.UCA_GUIDE_WORD__UCA_ID_POSTFIX).create(), EFeaturePath.builder().add((EStructuralFeature)STAMPPackage.Literals.HAZARD_CAUSAL_FACTOR__UNSAFE_CONTROL_ACTION).add((EStructuralFeature)STAMPPackage.Literals.IDENTIFIED_ELEMENT__ID).create()}));
        return reorganizer;
    }
}

