/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.edit;

import java.util.ArrayList;
import java.util.Locale;
import net.astah.emf.common.ecore.EcoreCopier;
import net.astah.project.AbstractFacetActivator;
import net.astah.project.Facet;
import net.astah.project.Project;
import net.astah.project.ProjectPackage;
import net.astah.stpa.stamp.HCFHintWordSet;
import net.astah.stpa.stamp.STAMPFactory;
import net.astah.stpa.stamp.STAMPPackage;
import net.astah.stpa.stamp.STPAAnalysis;
import net.astah.stpa.stamp.UCAGuideWord;
import net.astah.stpa.stamp.UCAGuideWordSet;
import net.astah.stpa.stamp.resource.STAMPResources;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.uml2.uml.Model;

public class STPAFacetActivator
extends AbstractFacetActivator {
    public Command activate(EditingDomain domain, final Project project, Facet facet) {
        UCAGuideWordSet guideWordSet = STAMPFactory.eINSTANCE.createUCAGuideWordSet();
        ArrayList<UCAGuideWord> guideWords = new ArrayList<UCAGuideWord>();
        guideWords.add(this.createGuideWord("N", "Not Providing"));
        guideWords.add(this.createGuideWord("P", "Providing causes hazard"));
        guideWords.add(this.createGuideWord("T", "Too early / Too late"));
        guideWords.add(this.createGuideWord("D", "Stop too soon / Applying too long"));
        guideWordSet.getGuideWords().addAll(guideWords);
        HCFHintWordSet hintWordSet = this.createHintWordSet(project);
        final STPAAnalysis analysis = STAMPFactory.eINSTANCE.createSTPAAnalysis();
        analysis.getUCAGuideWordSets().add((Object)guideWordSet);
        analysis.getHCFHintWordSets().add((Object)hintWordSet);
        Resource resource = this.createResource(domain, project, "model.stamp");
        CompoundCommand command = new CompoundCommand();
        command.append((Command)new AddCommand(domain, resource.getContents(), (Object)analysis));
        command.append(AddCommand.create((EditingDomain)domain, (Object)facet, (Object)ProjectPackage.Literals.FACET__CONTENTS, (Object)analysis));
        project.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                block0 : switch (msg.getFeatureID(Project.class)) {
                    case 20: {
                        switch (msg.getEventType()) {
                            case 3: {
                                Object value = msg.getNewValue();
                                if (!(value instanceof Model)) break block0;
                                analysis.setOwner((EObject)((Model)value));
                                project.eAdapters().remove((Object)this);
                                break block0;
                            }
                        }
                        break;
                    }
                }
            }
        });
        return command.unwrap();
    }

    public Command migrate(EditingDomain domain, Facet facet) {
        return null;
    }

    protected boolean isFacetResource(Resource resource) {
        return resource.getContents().stream().anyMatch(this::isFacetContent);
    }

    private boolean isFacetContent(EObject eObject) {
        return eObject.eClass().getEPackage() == STAMPPackage.eINSTANCE;
    }

    private UCAGuideWord createGuideWord(String id, String name) {
        UCAGuideWord guideWord = STAMPFactory.eINSTANCE.createUCAGuideWord();
        guideWord.setUcaIdPostfix(id);
        guideWord.setName(name);
        return guideWord;
    }

    private HCFHintWordSet createHintWordSet(Project project) {
        HCFHintWordSet primer = STAMPResources.getLibraryHCFHintWordSet((EObject)project, (String)("Primer_" + Locale.getDefault().getLanguage()));
        if (primer == null || primer.getHintWords().size() == 0) {
            primer = STAMPResources.getLibraryHCFHintWordSet((EObject)project, (String)"Primer");
        }
        EcoreCopier copier = new EcoreCopier();
        HCFHintWordSet copyObject = (HCFHintWordSet)copier.copy((EObject)primer);
        return copyObject;
    }
}

